/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.accesstransformer;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraftforge.accesstransformer.AccessTransformer;
import net.minecraftforge.accesstransformer.Target;
import net.minecraftforge.accesstransformer.TargetType;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class MethodTarget
extends Target<MethodNode> {
    private final String methodName;
    private final List<Type> arguments;
    private final Type returnType;
    private final String targetName;

    public MethodTarget(String className, String methodName, List<String> arguments, String returnValue) {
        super(className);
        this.methodName = methodName;
        this.arguments = arguments.stream().map(s -> s.replaceAll("\\.", "/")).map(Type::getType).collect(Collectors.toList());
        this.returnType = Type.getType((String)returnValue.replaceAll("\\.", "/"));
        this.targetName = methodName + "(" + arguments.stream().collect(Collectors.joining()) + ")" + this.returnType;
    }

    @Override
    public TargetType getType() {
        return TargetType.METHOD;
    }

    @Override
    public String toString() {
        return super.toString() + " " + Objects.toString(this.methodName) + "(" + Objects.toString(this.arguments.stream().map(Object::toString).collect(Collectors.joining())) + ")" + Objects.toString(this.returnType);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MethodTarget)) {
            return false;
        }
        return super.equals(obj) && Objects.equals(this.methodName, ((MethodTarget)obj).methodName) && Objects.deepEquals(this.arguments, ((MethodTarget)obj).arguments) && Objects.equals(this.returnType, ((MethodTarget)obj).returnType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClassName(), this.getType(), this.methodName});
    }

    @Override
    public String targetName() {
        return this.targetName;
    }

    @Override
    public void apply(MethodNode node, AccessTransformer.Modifier targetAccess, AccessTransformer.FinalState targetFinalState, Set<String> privateChanged) {
        boolean wasPrivate = (node.access & 2) == 2;
        node.access = targetAccess.mergeWith(node.access);
        node.access = targetFinalState.mergeWith(node.access);
        if (wasPrivate && !"<init>".equals(node.name) && (node.access & 2) != 2) {
            privateChanged.add(node.name + node.desc);
        }
    }
}

