var GlWrapper = Java.type("com.github.tartaricacid.touhoulittlemaid.client.animation.script.GlWrapper");

Java.asJSONCompatible({
    animation: function (maid, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, modelMap) {
        legLeft = modelMap.get("legLeft");
        legRight = modelMap.get("legRight");
        armLeft = modelMap.get("armLeft");
        armRight = modelMap.get("armRight");

        if (maid.isRiding()) {
            ridingPosture(legLeft, legRight);
        } else if (maid.isSitting()) {
            sittingPosture(armLeft, armRight, legLeft, legRight);
        }
    }
})

function ridingPosture(legLeft, legRight) {
    if (legLeft != undefined) {
        legLeft.setRotateAngleX(-1.25);
        legLeft.setRotateAngleZ(-0.780);
    }
    if (legRight != undefined) {
        legRight.setRotateAngleX(-1.25);
        legRight.setRotateAngleZ(0.780);
    }
    GlWrapper.translate(0, 0.5, 0);
}

function sittingPosture(armLeft, armRight, legLeft, legRight) {
    if (armLeft != undefined) {
        armLeft.setRotateAngleX(-0.5);
        armLeft.setRotateAngleZ(0);
    }
    if (armRight != undefined) {
        armRight.setRotateAngleX(-0.5);
        armRight.setRotateAngleZ(0);
    }
}