/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.commonmark.internal;

import dev.dediamondpro.resourcify.libs.commonmark.internal.util.Parsing;
import dev.dediamondpro.resourcify.libs.commonmark.node.Block;
import dev.dediamondpro.resourcify.libs.commonmark.node.IndentedCodeBlock;
import dev.dediamondpro.resourcify.libs.commonmark.node.Paragraph;
import dev.dediamondpro.resourcify.libs.commonmark.parser.SourceLine;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.AbstractBlockParser;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.AbstractBlockParserFactory;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.BlockContinue;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.BlockStart;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.MatchedBlockParser;
import dev.dediamondpro.resourcify.libs.commonmark.parser.block.ParserState;
import java.util.ArrayList;
import java.util.List;

public class IndentedCodeBlockParser
extends AbstractBlockParser {
    private final IndentedCodeBlock block = new IndentedCodeBlock();
    private final List<CharSequence> lines = new ArrayList<CharSequence>();

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.getIndent() >= Parsing.CODE_BLOCK_INDENT) {
            return BlockContinue.atColumn(state.getColumn() + Parsing.CODE_BLOCK_INDENT);
        }
        if (state.isBlank()) {
            return BlockContinue.atIndex(state.getNextNonSpaceIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine line) {
        this.lines.add(line.getContent());
    }

    @Override
    public void closeBlock() {
        int lastNonBlank;
        for (lastNonBlank = this.lines.size() - 1; lastNonBlank >= 0 && Parsing.isBlank(this.lines.get(lastNonBlank)); --lastNonBlank) {
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < lastNonBlank + 1; ++i2) {
            sb.append(this.lines.get(i2));
            sb.append('\n');
        }
        String literal = sb.toString();
        this.block.setLiteral(literal);
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (state.getIndent() >= Parsing.CODE_BLOCK_INDENT && !state.isBlank() && !(state.getActiveBlockParser().getBlock() instanceof Paragraph)) {
                return BlockStart.of(new IndentedCodeBlockParser()).atColumn(state.getColumn() + Parsing.CODE_BLOCK_INDENT);
            }
            return BlockStart.none();
        }
    }
}

