/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.minemark.elements;

import dev.dediamondpro.resourcify.libs.minemark.LayoutData;
import dev.dediamondpro.resourcify.libs.minemark.LayoutStyle;
import dev.dediamondpro.resourcify.libs.minemark.elements.Element;
import dev.dediamondpro.resourcify.libs.minemark.style.Style;
import dev.dediamondpro.resourcify.libs.minemark.utils.MouseButton;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;

public abstract class ChildMovingElement<S extends Style, R>
extends Element<S, R> {
    protected final MarkerType markerType = this.getMarkerType();
    protected LayoutData.MarkDownElementPosition marker;
    protected float totalHeight;
    protected float extraXOffset;
    protected float extraYOffset;

    public ChildMovingElement(@NotNull S style, @NotNull LayoutStyle layoutStyle, @Nullable Element<S, R> parent, @NotNull String qName, @Nullable Attributes attributes) {
        super(style, layoutStyle, parent, qName, attributes);
    }

    @Override
    public void generateLayout(LayoutData layoutData, R renderData) {
        if (layoutData.isLineOccupied()) {
            layoutData.nextLine();
        }
        float markerWidth = this.getMarkerWidth(layoutData, renderData);
        float outsidePadding = this.getOutsidePadding(layoutData, renderData);
        float insidePadding = this.getInsidePadding(layoutData, renderData);
        layoutData.updatePadding(outsidePadding);
        LayoutData newLayoutData = new LayoutData(layoutData.getMaxWidth() - markerWidth - insidePadding * (this.markerType == MarkerType.BLOCK ? 2.0f : 1.0f));
        if (this.markerType == MarkerType.ONE_LINE) {
            this.marker = layoutData.addElement(LayoutStyle.Alignment.LEFT, markerWidth, this.getMarkerHeight(layoutData, renderData));
            newLayoutData.setTopSpacing(layoutData.getCurrentLine().getTopSpacing());
            newLayoutData.lockTopSpacing();
            newLayoutData.setLineHeight(layoutData.getLineHeight());
            newLayoutData.setBottomSpacing(layoutData.getCurrentLine().getBottomSpacing());
        }
        LayoutData.MarkDownLine firstLine = newLayoutData.getCurrentLine();
        this.generateNewLayout(newLayoutData, renderData);
        this.totalHeight = newLayoutData.getY() + newLayoutData.getCurrentLine().getHeight();
        if (this.markerType == MarkerType.ONE_LINE) {
            layoutData.updateLineHeight(firstLine.getRawHeight());
            newLayoutData.setBottomSpacing(layoutData.getCurrentLine().getBottomSpacing());
            if (newLayoutData.getCurrentLine() != firstLine) {
                layoutData.nextLine();
                layoutData.setLineHeight(newLayoutData.getCurrentLine().getBottomY() - firstLine.getHeight());
            }
        } else {
            this.marker = layoutData.addElement(LayoutStyle.Alignment.LEFT, this.markerType == MarkerType.BLOCK ? layoutData.getMaxWidth() : markerWidth, this.totalHeight + insidePadding * 2.0f);
        }
        layoutData.nextLine();
        this.extraXOffset = (this.markerType == MarkerType.BLOCK ? 0.0f : this.marker.getRightX()) + insidePadding;
        this.extraYOffset = (this.markerType == MarkerType.ONE_LINE ? this.marker.getLine().getY() : this.marker.getY()) + insidePadding;
    }

    protected void generateNewLayout(LayoutData layoutData, R renderData) {
        for (Element child : this.children) {
            child.generateLayoutInternal(layoutData, renderData);
        }
    }

    @Override
    @ApiStatus.Internal
    public void drawInternal(float xOffset, float yOffset, float mouseX, float mouseY, R renderData) {
        if (this.marker != null) {
            this.drawMarker(this.marker.getX() + xOffset, this.marker.getY() + yOffset, this.marker.getWidth(), this.marker.getHeight(), renderData);
        }
        for (Element child : this.children) {
            child.drawInternal(xOffset + this.extraXOffset, yOffset + this.extraYOffset, mouseX - this.extraXOffset, mouseY - this.extraYOffset, renderData);
        }
    }

    @Override
    @ApiStatus.Internal
    public void beforeDrawInternal(float xOffset, float yOffset, float mouseX, float mouseY, R renderData) {
        super.beforeDrawInternal(xOffset + this.extraXOffset, yOffset + this.extraXOffset, mouseX - this.extraXOffset, mouseY - this.extraYOffset, renderData);
    }

    @Override
    @ApiStatus.Internal
    public void onMouseClickedInternal(MouseButton button, float mouseX, float mouseY) {
        super.onMouseClickedInternal(button, mouseX - this.extraXOffset, mouseY - this.extraYOffset);
    }

    protected abstract void drawMarker(float var1, float var2, float var3, float var4, R var5);

    protected MarkerType getMarkerType() {
        return MarkerType.FULL;
    }

    protected abstract float getMarkerWidth(LayoutData var1, R var2);

    protected float getMarkerHeight(LayoutData layoutData, R renderData) {
        throw new IllegalStateException("\"getMarkerHeight\" should be implemented for \"MarkerType.ONE_LINE\"!");
    }

    protected float getOutsidePadding(LayoutData layoutData, R renderData) {
        return 0.0f;
    }

    protected float getInsidePadding(LayoutData layoutData, R renderData) {
        return 0.0f;
    }

    protected static enum MarkerType {
        ONE_LINE,
        FULL,
        BLOCK;

    }
}

