/*
 * Decompiled with CFR 0.152.
 */
package dev.dediamondpro.resourcify.libs.universal;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.dediamondpro.resourcify.libs.universal.ChatColor;
import dev.dediamondpro.resourcify.libs.universal.UMatrixStack;
import dev.dediamondpro.resourcify.libs.universal.UMinecraft;
import dev.dediamondpro.resourcify.libs.universal.utils.ReleasedDynamicTexture;
import dev.dediamondpro.resourcify.libs.universal.vertex.UVertexConsumer;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class UGraphics {
    private static final Pattern formattingCodePattern = Pattern.compile("(?i)\u00a7[0-9A-FK-OR]");
    private static UMatrixStack UNIT_STACK = UMatrixStack.UNIT;
    public static Style EMPTY_WITH_FONT_ID = Style.f_131099_.m_131150_(new ResourceLocation("minecraft", "alt"));
    public static int ZERO_TEXT_ALPHA = 10;
    private BufferBuilder instance;
    private VertexFormat vertexFormat;
    private static final Font.DisplayMode TEXT_LAYER_TYPE = Font.DisplayMode.NORMAL;
    private static final Map<VertexFormat, Supplier<ShaderInstance>> DEFAULT_SHADERS = new IdentityHashMap<VertexFormat, Supplier<ShaderInstance>>();
    private RenderType renderLayer;

    public UGraphics(BufferBuilder instance) {
        this.instance = instance;
    }

    public UVertexConsumer asUVertexConsumer() {
        return UVertexConsumer.of((VertexConsumer)this.instance);
    }

    public static UGraphics getFromTessellator() {
        return new UGraphics(UGraphics.getTessellator().m_85915_());
    }

    public static Tesselator getTessellator() {
        return Tesselator.m_85913_();
    }

    @Deprecated
    public static void draw() {
        UGraphics.getTessellator().m_85914_();
    }

    public static boolean isCoreProfile() {
        return true;
    }

    @Deprecated
    public static void enableStencil() {
    }

    public static void cullFace(int mode) {
        GL11.glCullFace((int)mode);
    }

    public static void enableLighting() {
    }

    public static void disableLighting() {
    }

    public static void disableLight(int mode) {
    }

    public static void enableLight(int mode) {
    }

    public static void enableBlend() {
        RenderSystem.enableBlend();
    }

    @Deprecated
    public static void disableTexture2D() {
    }

    public static void disableAlpha() {
    }

    public static void alphaFunc(int func, float ref) {
    }

    public static void shadeModel(int mode) {
    }

    public static void blendEquation(int equation) {
        RenderSystem.blendEquation((int)equation);
    }

    public static void tryBlendFuncSeparate(int srcFactor, int dstFactor, int srcFactorAlpha, int dstFactorAlpha) {
        RenderSystem.blendFuncSeparate((int)srcFactor, (int)dstFactor, (int)srcFactorAlpha, (int)dstFactorAlpha);
    }

    @Deprecated
    public static void enableTexture2D() {
    }

    public static void disableBlend() {
        RenderSystem.disableBlend();
    }

    public static void deleteTexture(int glTextureId) {
        RenderSystem.deleteTexture((int)glTextureId);
    }

    public static void enableAlpha() {
    }

    public static void configureTexture(int glTextureId, Runnable block) {
        int prevTextureBinding = GL11.glGetInteger((int)32873);
        RenderSystem.bindTexture((int)glTextureId);
        block.run();
        RenderSystem.bindTexture((int)prevTextureBinding);
    }

    public static void configureTextureUnit(int index, Runnable block) {
        int prevActiveTexture = UGraphics.getActiveTexture();
        UGraphics.setActiveTexture(33984 + index);
        block.run();
        UGraphics.setActiveTexture(prevActiveTexture);
    }

    @Deprecated
    public static void activeTexture(int glId) {
        UGraphics.setActiveTexture(glId);
    }

    public static int getActiveTexture() {
        return GL11.glGetInteger((int)34016);
    }

    public static void setActiveTexture(int glId) {
        GlStateManager._activeTexture((int)glId);
    }

    @Deprecated
    public static void bindTexture(int glTextureId) {
        RenderSystem.setShaderTexture((int)(GlStateManager._getActiveTexture() - 33984), (int)glTextureId);
    }

    @Deprecated
    public static void bindTexture(ResourceLocation resourceLocation) {
        UGraphics.bindTexture(UGraphics.getOrLoadTextureId(resourceLocation));
    }

    public static void bindTexture(int index, int glTextureId) {
        RenderSystem.setShaderTexture((int)index, (int)glTextureId);
    }

    public static void bindTexture(int index, ResourceLocation resourceLocation) {
        UGraphics.bindTexture(index, UGraphics.getOrLoadTextureId(resourceLocation));
    }

    private static int getOrLoadTextureId(ResourceLocation resourceLocation) {
        TextureManager textureManager = UMinecraft.getMinecraft().m_91097_();
        AbstractTexture texture = textureManager.m_118506_(resourceLocation);
        if (texture == null) {
            texture = new SimpleTexture(resourceLocation);
            textureManager.m_118495_(resourceLocation, texture);
        }
        return texture.m_117963_();
    }

    public static int getStringWidth(String in) {
        return UMinecraft.getFontRenderer().m_92895_(in);
    }

    public static int getFontHeight() {
        Objects.requireNonNull(UMinecraft.getFontRenderer());
        return 9;
    }

    @Deprecated
    public static void drawString(String text, float x, float y, int color, boolean shadow) {
        UGraphics.drawString(UNIT_STACK, text, x, y, color, shadow);
    }

    public static void drawString(UMatrixStack stack, String text, float x, float y, int color, boolean shadow) {
        if ((color >> 24 & 0xFF) <= 10) {
            return;
        }
        MultiBufferSource.BufferSource irendertypebuffer$impl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        UMinecraft.getFontRenderer().m_271703_(text, x, y, color, shadow, stack.peek().getModel(), (MultiBufferSource)irendertypebuffer$impl, TEXT_LAYER_TYPE, 0, 0xF000F0);
        irendertypebuffer$impl.m_109911_();
    }

    @Deprecated
    public static void drawString(String text, float x, float y, int color, int shadowColor) {
        UGraphics.drawString(UNIT_STACK, text, x, y, color, shadowColor);
    }

    public static void drawString(UMatrixStack stack, String text, float x, float y, int color, int shadowColor) {
        if ((color >> 24 & 0xFF) <= 10) {
            return;
        }
        String shadowText = ChatColor.Companion.stripColorCodes(text);
        MultiBufferSource.BufferSource irendertypebuffer$impl = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        UMinecraft.getFontRenderer().m_271703_(shadowText, x + 1.0f, y + 1.0f, shadowColor, false, stack.peek().getModel(), (MultiBufferSource)irendertypebuffer$impl, TEXT_LAYER_TYPE, 0, 0xF000F0);
        UMinecraft.getFontRenderer().m_271703_(text, x, y, color, false, stack.peek().getModel(), (MultiBufferSource)irendertypebuffer$impl, TEXT_LAYER_TYPE, 0, 0xF000F0);
        irendertypebuffer$impl.m_109911_();
    }

    public static List<String> listFormattedStringToWidth(String str, int wrapWidth) {
        return UGraphics.listFormattedStringToWidth(str, wrapWidth, true);
    }

    public static List<String> listFormattedStringToWidth(String str, int wrapWidth, boolean safe) {
        if (safe) {
            String tmp = formattingCodePattern.matcher(str).replaceAll("");
            int max = 0;
            for (String s : tmp.split(" ")) {
                max = Math.max(max, UGraphics.getStringWidth(s));
            }
            wrapWidth = Math.max(max, wrapWidth);
        }
        ArrayList<String> strings = new ArrayList<String>();
        StringSplitter charManager = UMinecraft.getFontRenderer().m_92865_();
        FormattedText properties2 = charManager.m_92389_((FormattedText)Component.m_237113_((String)str).m_130948_(EMPTY_WITH_FONT_ID), wrapWidth, Style.f_131099_);
        properties2.m_5651_(string -> {
            strings.add(string);
            return Optional.empty();
        });
        return strings;
    }

    public static float getCharWidth(char character) {
        return UGraphics.getStringWidth(String.valueOf(character));
    }

    public static void glClear(int mode) {
        GL11.glClear((int)mode);
    }

    public static void glClearStencil(int mode) {
        GL11.glClearStencil((int)mode);
    }

    public static ReleasedDynamicTexture getTexture(InputStream stream) {
        try {
            return new ReleasedDynamicTexture(NativeImage.m_85058_((InputStream)stream));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to read image");
        }
    }

    public static ReleasedDynamicTexture getTexture(BufferedImage img) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", baos);
            return new ReleasedDynamicTexture(NativeImage.m_85058_((InputStream)new ByteArrayInputStream(baos.toByteArray())));
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to create texture");
        }
    }

    public static ReleasedDynamicTexture getEmptyTexture() {
        return new ReleasedDynamicTexture(0, 0);
    }

    public static void glUseProgram(int program) {
        GlStateManager._glUseProgram((int)program);
    }

    public static boolean isOpenGl21Supported() {
        return true;
    }

    public static boolean areShadersSupported() {
        return true;
    }

    public static int glCreateProgram() {
        return GlStateManager.glCreateProgram();
    }

    public static int glCreateShader(int type2) {
        return GlStateManager.glCreateShader((int)type2);
    }

    public static void glCompileShader(int shaderIn) {
        GlStateManager.glCompileShader((int)shaderIn);
    }

    public static int glGetShaderi(int shaderIn, int pname) {
        return GlStateManager.glGetShaderi((int)shaderIn, (int)pname);
    }

    public static String glGetShaderInfoLog(int shader, int maxLen) {
        return GlStateManager.glGetShaderInfoLog((int)shader, (int)maxLen);
    }

    public static void glAttachShader(int program, int shaderIn) {
        GlStateManager.glAttachShader((int)program, (int)shaderIn);
    }

    public static void glLinkProgram(int program) {
        GlStateManager.glLinkProgram((int)program);
    }

    public static int glGetProgrami(int program, int pname) {
        return GlStateManager.glGetProgrami((int)program, (int)pname);
    }

    public static String glGetProgramInfoLog(int program, int maxLen) {
        return GlStateManager.glGetProgramInfoLog((int)program, (int)maxLen);
    }

    public static void color4f(float red, float green, float blue, float alpha) {
        RenderSystem.setShaderColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public static void directColor3f(float red, float green, float blue) {
        UGraphics.color4f(red, green, blue, 1.0f);
    }

    public static void enableDepth() {
        RenderSystem.enableDepthTest();
    }

    public static void depthFunc(int mode) {
        RenderSystem.depthFunc((int)mode);
    }

    public static void depthMask(boolean flag) {
        RenderSystem.depthMask((boolean)flag);
    }

    public static void disableDepth() {
        RenderSystem.disableDepthTest();
    }

    public static void setShader(Supplier<ShaderInstance> shader) {
        RenderSystem.setShader(shader);
    }

    public UGraphics beginWithActiveShader(DrawMode mode, CommonVertexFormats format) {
        return this.beginWithActiveShader(mode, format.mc);
    }

    public UGraphics beginWithActiveShader(DrawMode mode, VertexFormat format) {
        this.vertexFormat = format;
        this.instance.m_166779_(mode.mcMode, format);
        return this;
    }

    public UGraphics beginWithDefaultShader(DrawMode mode, CommonVertexFormats format) {
        return this.beginWithDefaultShader(mode, format.mc);
    }

    public UGraphics beginWithDefaultShader(DrawMode mode, VertexFormat format) {
        Supplier<ShaderInstance> shader = DEFAULT_SHADERS.get(format);
        if (shader == null) {
            throw new IllegalArgumentException("No default shader for " + String.valueOf(format) + ". Bind your own and use beginWithActiveShader instead.");
        }
        RenderSystem.setShader(shader);
        return this.beginWithActiveShader(mode, format);
    }

    public UGraphics beginRenderLayer(RenderType renderLayer) {
        this.renderLayer = renderLayer;
        this.beginWithActiveShader(DrawMode.fromRenderLayer(renderLayer), renderLayer.m_110508_());
        return this;
    }

    @Deprecated
    public UGraphics begin(int glMode, CommonVertexFormats format) {
        return this.begin(glMode, format.mc);
    }

    @Deprecated
    public UGraphics begin(int glMode, VertexFormat format) {
        this.beginWithDefaultShader(DrawMode.fromGl(glMode), format);
        return this;
    }

    public void drawDirect() {
        if (this.renderLayer != null) {
            this.renderLayer.m_276775_(this.instance, RenderSystem.getVertexSorting());
            return;
        }
        this.doDraw();
    }

    public void drawSorted(int cameraX, int cameraY, int cameraZ) {
        if (this.renderLayer != null) {
            this.renderLayer.m_276775_(this.instance, RenderSystem.getVertexSorting());
            return;
        }
        this.instance.m_277127_(RenderSystem.getVertexSorting());
        this.doDraw();
    }

    private void doDraw() {
        VertexFormat vertexFormat = this.vertexFormat;
        if (vertexFormat == null) {
            UGraphics.getTessellator().m_85914_();
            return;
        }
        UGraphics.getTessellator().m_85914_();
    }

    @Deprecated
    public UGraphics pos(double x, double y, double z) {
        return this.pos(UNIT_STACK, x, y, z);
    }

    public UGraphics pos(UMatrixStack stack, double x, double y, double z) {
        if (stack == UNIT_STACK) {
            this.instance.m_5483_(x, y, z);
        } else {
            this.instance.m_252986_(stack.peek().getModel(), (float)x, (float)y, (float)z);
        }
        return this;
    }

    @Deprecated
    public UGraphics norm(float x, float y, float z) {
        return this.norm(UNIT_STACK, x, y, z);
    }

    public UGraphics norm(UMatrixStack stack, float x, float y, float z) {
        if (stack == UNIT_STACK) {
            this.instance.m_5601_(x, y, z);
        } else {
            this.instance.m_252939_(stack.peek().getNormal(), x, y, z);
        }
        return this;
    }

    public UGraphics color(int red, int green, int blue, int alpha) {
        return this.color((float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, (float)alpha / 255.0f);
    }

    public UGraphics color(float red, float green, float blue, float alpha) {
        this.instance.m_85950_(red, green, blue, alpha);
        return this;
    }

    public UGraphics color(Color color) {
        return this.color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public UGraphics endVertex() {
        this.instance.m_5752_();
        return this;
    }

    public UGraphics tex(double u, double v) {
        this.instance.m_7421_((float)u, (float)v);
        return this;
    }

    public UGraphics overlay(int u, int v) {
        this.instance.m_7122_(u, v);
        return this;
    }

    public UGraphics light(int u, int v) {
        this.instance.m_7120_(u, v);
        return this;
    }

    static {
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_166851_, GameRenderer::m_172757_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85813_, GameRenderer::m_172829_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85814_, GameRenderer::m_172808_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85815_, GameRenderer::m_172811_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85816_, GameRenderer::m_172832_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85817_, GameRenderer::m_172817_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85818_, GameRenderer::m_172814_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85819_, GameRenderer::m_172820_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85820_, GameRenderer::m_172835_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85821_, GameRenderer::m_172637_);
        DEFAULT_SHADERS.put(DefaultVertexFormat.f_85822_, GameRenderer::m_172838_);
    }

    public static enum CommonVertexFormats {
        POSITION(DefaultVertexFormat.f_85814_),
        POSITION_COLOR(DefaultVertexFormat.f_85815_),
        POSITION_TEXTURE(DefaultVertexFormat.f_85817_),
        POSITION_TEXTURE_COLOR(DefaultVertexFormat.f_85819_),
        POSITION_COLOR_TEXTURE_LIGHT(DefaultVertexFormat.f_85811_),
        POSITION_TEXTURE_LIGHT_COLOR(DefaultVertexFormat.f_85821_),
        POSITION_TEXTURE_COLOR_LIGHT(DefaultVertexFormat.f_85813_),
        POSITION_TEXTURE_COLOR_NORMAL(DefaultVertexFormat.f_85822_);

        public final VertexFormat mc;

        private CommonVertexFormats(VertexFormat mc) {
            this.mc = mc;
        }
    }

    public static enum DrawMode {
        LINES(1),
        LINE_STRIP(3),
        TRIANGLES(4),
        TRIANGLE_STRIP(5),
        TRIANGLE_FAN(6),
        QUADS(7);

        private final int glMode;
        private final VertexFormat.Mode mcMode;

        private DrawMode(int glMode) {
            this.glMode = glMode;
            this.mcMode = DrawMode.glToMcDrawMode(glMode);
        }

        private static VertexFormat.Mode glToMcDrawMode(int glMode) {
            switch (glMode) {
                case 1: {
                    return VertexFormat.Mode.LINES;
                }
                case 3: {
                    return VertexFormat.Mode.LINE_STRIP;
                }
                case 4: {
                    return VertexFormat.Mode.TRIANGLES;
                }
                case 5: {
                    return VertexFormat.Mode.TRIANGLE_STRIP;
                }
                case 6: {
                    return VertexFormat.Mode.TRIANGLE_FAN;
                }
                case 7: {
                    return VertexFormat.Mode.QUADS;
                }
            }
            throw new IllegalArgumentException("Unsupported draw mode " + glMode);
        }

        private static DrawMode fromMc(VertexFormat.Mode mcMode) {
            switch (mcMode) {
                case LINES: {
                    return LINES;
                }
                case LINE_STRIP: {
                    return LINE_STRIP;
                }
                case TRIANGLES: {
                    return TRIANGLES;
                }
                case TRIANGLE_STRIP: {
                    return TRIANGLE_STRIP;
                }
                case TRIANGLE_FAN: {
                    return TRIANGLE_FAN;
                }
                case QUADS: {
                    return QUADS;
                }
            }
            throw new IllegalArgumentException("Unsupported draw mode " + String.valueOf(mcMode));
        }

        public static DrawMode fromGl(int glMode) {
            switch (glMode) {
                case 1: {
                    return LINES;
                }
                case 3: {
                    return LINE_STRIP;
                }
                case 4: {
                    return TRIANGLES;
                }
                case 5: {
                    return TRIANGLE_STRIP;
                }
                case 6: {
                    return TRIANGLE_FAN;
                }
                case 7: {
                    return QUADS;
                }
            }
            throw new IllegalArgumentException("Unsupported draw mode " + glMode);
        }

        public static DrawMode fromRenderLayer(RenderType renderLayer) {
            return DrawMode.fromMc(renderLayer.m_173186_());
        }
    }
}

