/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.explosiveenhancement;

import com.mojang.logging.LogUtils;
import dev.xylonity.explosiveenhancement.config.ExplosiveEnhancementConfig;
import dev.xylonity.explosiveenhancement.registry.ExplosiveParticleManager;
import dev.xylonity.explosiveenhancement.registry.ExplosiveParticles;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import org.slf4j.Logger;

@Mod(value="explosiveenhancement")
public class ExplosiveEnhancement {
    public static final String MOD_ID = "explosiveenhancement";
    public static final Logger LOGGER = LogUtils.getLogger();

    public ExplosiveEnhancement() {
        if (FMLLoader.getDist() == Dist.DEDICATED_SERVER) {
            LOGGER.warn("Explosive Enhancement: Reforged won't be loaded as it should be initialized on the client side.");
        } else {
            LOGGER.info("Explosive Enhancement: Reforged loaded correctly, initializing particles...");
            this.init();
        }
    }

    private void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ExplosiveEnhancementConfig.SPEC, "explosiveenhancement.toml");
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        ExplosiveParticleManager.setup(modBus);
        ExplosiveParticles.init();
        modBus.addListener(ExplosiveParticles::registerProviders);
    }
}

