/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.mixin;

import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import de.cheaterpaul.fallingleaves.init.ClientMod;
import de.cheaterpaul.fallingleaves.init.FallingLeavesConfig;
import de.cheaterpaul.fallingleaves.util.LeafUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LeavesBlock.class})
public abstract class LeafTickMixin {
    @Inject(at={@At(value="HEAD")}, method={"animateTick(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"})
    private void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random, CallbackInfo ci) {
        LeafSettingsEntry leafSettings = ClientMod.getLeafSetting(ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_()));
        if (leafSettings == null && !(state.m_60734_() instanceof LeavesBlock)) {
            return;
        }
        if (!((Boolean)FallingLeavesConfig.CONFIG.dropFromPlayerPlacedBlocks.get()).booleanValue() && ((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue()) {
            return;
        }
        double spawnChance = 1.0;
        double modifier = ((Integer)FallingLeavesConfig.CONFIG.leafSpawnRate.get()).intValue();
        if (leafSettings != null) {
            spawnChance = leafSettings.spawnRateFactor();
            if (leafSettings.considerAsConifer()) {
                modifier = ((Integer)FallingLeavesConfig.CONFIG.coniferLeafSpawnRate.get()).intValue();
            }
        }
        modifier = modifier / 10.0 / 75.0;
        spawnChance *= modifier;
        while (spawnChance > 0.0) {
            if (random.m_188500_() < spawnChance) {
                LeafUtil.trySpawnLeafParticle(state, world, pos, random, leafSettings);
            }
            spawnChance -= 1.0;
        }
    }
}

