/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.gui.integration;

import com.mojang.blaze3d.Blaze3D;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.mixin.MouseHandlerAccessor;

public class ScreenEventListener
implements GuiEventListener,
NarratableEntry {
    public static final double DOUBLE_CLICK_TIME = 0.2;
    private final IGuiIntegratedParent gui;
    private final Screen screen;
    private int doubleClickButton = -1;
    private double time;
    private double x;
    private double y;
    private boolean released = false;
    private boolean focused;

    public ScreenEventListener(IGuiIntegratedParent gui, Screen screen) {
        this.gui = gui;
        this.screen = screen;
    }

    public int getOffsetX() {
        return (this.screen.f_96543_ - this.gui.getTopLayer().getWidth()) / 2;
    }

    public int getOffsetY() {
        return (this.screen.f_96544_ - this.gui.getTopLayer().getHeight()) / 2;
    }

    public void tick() {
        if (this.doubleClickButton != -1 && Blaze3D.m_83640_() - this.time > 0.2) {
            this.fireRemaingEvents();
        }
    }

    public double getEventTime() {
        return ((MouseHandlerAccessor)Minecraft.m_91087_().f_91067_).getLastMouseEventTime();
    }

    protected void fireRemaingEvents() {
        if (this.doubleClickButton != -1) {
            this.gui.getTopLayer().mouseClicked(null, this.x, this.y, this.doubleClickButton);
            if (this.released) {
                this.gui.getTopLayer().mouseReleased(null, this.x, this.y, this.doubleClickButton);
            }
            this.doubleClickButton = -1;
            this.released = false;
        }
    }

    public void m_94757_(double x, double y) {
        this.gui.getTopLayer().mouseMoved(null, x - (double)this.getOffsetX(), y - (double)this.getOffsetY());
    }

    public boolean m_6375_(double x, double y, int button) {
        if (this.gui.getTopLayer().testForDoubleClick(null, x - (double)this.getOffsetX(), y - (double)this.getOffsetY(), button)) {
            if (this.doubleClickButton == button) {
                this.released = false;
                this.doubleClickButton = -1;
                return this.gui.getTopLayer().mouseDoubleClicked(null, x - (double)this.getOffsetX(), y - (double)this.getOffsetY(), button);
            }
            this.fireRemaingEvents();
            this.doubleClickButton = button;
            this.time = this.getEventTime();
            this.x = x - (double)this.getOffsetX();
            this.y = y - (double)this.getOffsetY();
            return true;
        }
        this.fireRemaingEvents();
        return this.gui.getTopLayer().mouseClicked(null, x - (double)this.getOffsetX(), y - (double)this.getOffsetY(), button);
    }

    public boolean m_6348_(double x, double y, int button) {
        if (this.doubleClickButton == button) {
            this.released = true;
            return true;
        }
        this.fireRemaingEvents();
        this.gui.getTopLayer().mouseReleased(null, x - (double)this.getOffsetX(), y - (double)this.getOffsetY(), button);
        return true;
    }

    public boolean m_7979_(double x, double y, int button, double dragX, double dragY) {
        if (this.doubleClickButton == -1) {
            this.gui.getTopLayer().mouseDragged(null, x - (double)this.getOffsetX(), y - (double)this.getOffsetY(), button, dragX, dragY, Blaze3D.m_83640_() - this.time);
        }
        return true;
    }

    public boolean m_6050_(double x, double y, double delta) {
        return this.gui.getTopLayer().mouseScrolled(null, x - (double)this.getOffsetX(), y - (double)this.getOffsetY(), delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.gui.getTopLayer().keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.gui.getTopLayer().keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        return this.gui.getTopLayer().charTyped(codePoint, modifiers);
    }

    public void m_93692_(boolean focused) {
        this.focused = focused;
    }

    public boolean m_93696_() {
        return this.focused;
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        return true;
    }

    public void m_142291_(NarrationElementOutput p_169152_) {
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }
}

