/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.emojiful.util;

import com.hrznstudio.emojiful.api.Emoji;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;
import org.w3c.dom.Node;

public class EmojiUtil
extends RenderType {
    private EmojiUtil(String string, VertexFormat vertexFormat, VertexFormat.Mode mode, int i, boolean bl, boolean bl2, Runnable runnable, Runnable runnable2) {
        super(string, vertexFormat, mode, i, bl, bl2, runnable, runnable2);
    }

    public static RenderType createRenderType(Emoji emoji) {
        RenderType.CompositeState state = RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(GameRenderer::m_172749_)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(emoji.getResourceLocationForBinding(), false, false)).m_110685_(new RenderStateShard.TransparencyStateShard("translucent_transparency", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        })).m_110671_(new RenderStateShard.LightmapStateShard(true)).m_110691_(false);
        return RenderType.m_173215_((String)"emoji_render", (VertexFormat)DefaultVertexFormat.f_85820_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)true, (RenderType.CompositeState)state);
    }

    public static float renderEmoji(Emoji emoji, float x, float y, Matrix4f matrix, MultiBufferSource buffer, int packedLight) {
        float textureSize = 16.0f;
        float textureX = 0.0f / textureSize;
        float textureY = 0.0f / textureSize;
        float textureOffset = 16.0f / textureSize;
        float size = 10.0f;
        float offsetY = 1.0f;
        float offsetX = 0.0f;
        VertexConsumer builder = buffer.m_6299_(EmojiUtil.createRenderType(emoji));
        builder.m_252986_(matrix, x - offsetX, y - offsetY, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(textureX, textureY).m_85969_(packedLight).m_5752_();
        builder.m_252986_(matrix, x - offsetX, y + size - offsetY, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(textureX, textureY + textureOffset).m_85969_(packedLight).m_5752_();
        builder.m_252986_(matrix, x - offsetX + size, y + size - offsetY, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(textureX + textureOffset, textureY + textureOffset).m_85969_(packedLight).m_5752_();
        builder.m_252986_(matrix, x - offsetX + size, y - offsetY, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(textureX + textureOffset, textureY / textureSize).m_85969_(packedLight).m_5752_();
        return 10.0f;
    }

    public static String cleanStringForRegex(String string) {
        return string.replaceAll("\\)", "\\\\)").replaceAll("\\(", "\\\\(").replaceAll("\\|", "\\\\|").replaceAll("\\*", "\\\\*");
    }

    public static List<Pair<BufferedImage, Integer>> splitGif(File file) throws IOException {
        ArrayList<Pair<BufferedImage, Integer>> images = new ArrayList<Pair<BufferedImage, Integer>>();
        ImageReader reader = ImageIO.getImageReadersBySuffix("gif").next();
        reader.setInput(ImageIO.createImageInputStream(new FileInputStream(file)), false);
        IIOMetadata metadata = reader.getImageMetadata(0);
        String metaFormatName = metadata.getNativeMetadataFormatName();
        for (int i = 0; i < reader.getNumImages(true); ++i) {
            int frameLength = 1;
            BufferedImage image = reader.read(i);
            BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 6);
            newImage.getGraphics().drawImage(image, 0, 0, null);
            IIOMetadataNode root = (IIOMetadataNode)reader.getImageMetadata(i).getAsTree(metaFormatName);
            int nNodes = root.getLength();
            for (int j = 0; j < nNodes; ++j) {
                Node node = root.item(j);
                if (!node.getNodeName().equalsIgnoreCase("GraphicControlExtension")) continue;
                frameLength = Integer.parseInt(((IIOMetadataNode)node).getAttribute("delayTime"));
                break;
            }
            images.add((Pair<BufferedImage, Integer>)Pair.of((Object)newImage, (Object)frameLength));
        }
        return images;
    }
}

