/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.createmod.catnip.config.ui.ConfigHelper;
import net.createmod.catnip.net.ClientboundConfigPacket;
import net.createmod.catnip.net.ClientboundSimpleActionPacket;
import net.createmod.catnip.net.ConfigPathArgument;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.ponder.Ponder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.fml.config.ModConfig;

public class ConfigCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"config").executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            CatnipServices.NETWORK.sendToPlayer((Player)player, new ClientboundSimpleActionPacket("configScreen", ""));
            return 1;
        })).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"path", (ArgumentType)ConfigPathArgument.path()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            CatnipServices.NETWORK.sendToPlayer((Player)player, new ClientboundSimpleActionPacket("configScreen", ConfigPathArgument.getPath((CommandContext<CommandSourceStack>)ctx, "path").toString()));
            return 1;
        })).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> {
            ConfigHelper.ConfigPath path = ConfigPathArgument.getPath((CommandContext<CommandSourceStack>)ctx, "path");
            String value = StringArgumentType.getString((CommandContext)ctx, (String)"value");
            if (path.getType() == ModConfig.Type.CLIENT) {
                ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
                CatnipServices.NETWORK.sendToPlayer((Player)player, new ClientboundConfigPacket(path.toString(), value));
                return 1;
            }
            try {
                ConfigHelper.setConfigValue(path, value);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Great Success!"), false);
                return 1;
            }
            catch (ConfigHelper.InvalidValueException e) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Config could not be set the the specified value!"));
                return 0;
            }
            catch (Exception e) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Something went wrong while trying to set config value. Check the server logs for more information"));
                Ponder.LOGGER.warn("Exception during server-side config value set:", (Throwable)e);
                return 0;
            }
        }))));
    }
}

