/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.data;

import java.util.regex.PatternSyntaxException;

public class Glob {
    private static final String REGEX_META_CHARS = ".^$+{[]|()";
    private static final String GLOB_META_CHARS = "\\*?[{";
    private static final char EOL = '\u0000';

    public static boolean isRegexMeta(char c) {
        return REGEX_META_CHARS.indexOf(c) != -1;
    }

    public static boolean isGlobMeta(char c) {
        return GLOB_META_CHARS.indexOf(c) != -1;
    }

    private static char next(String glob, int i) {
        return i < glob.length() ? glob.charAt(i) : (char)'\u0000';
    }

    public static String toRegexPattern(String globPattern) throws PatternSyntaxException {
        boolean inGroup = false;
        StringBuilder regex = new StringBuilder("^");
        int i = 0;
        block9: while (i < globPattern.length()) {
            char c = globPattern.charAt(i++);
            switch (c) {
                case '*': {
                    regex.append(".*");
                    continue block9;
                }
                case '?': {
                    regex.append(".");
                    continue block9;
                }
                case ',': {
                    if (inGroup) {
                        regex.append("|");
                        continue block9;
                    }
                    regex.append(',');
                    continue block9;
                }
                case '[': {
                    if (Glob.next(globPattern, i) == ']') {
                        throw new PatternSyntaxException("Cannot have set with no entries", globPattern, i);
                    }
                    regex.append("[");
                    if (Glob.next(globPattern, i) == '^') {
                        regex.append("\\^");
                        ++i;
                    } else {
                        if (Glob.next(globPattern, i) == '!') {
                            regex.append('^');
                            ++i;
                        }
                        if (Glob.next(globPattern, i) == '-') {
                            regex.append('-');
                            ++i;
                        }
                    }
                    boolean hasRangeStart = false;
                    char last = '\u0000';
                    while (i < globPattern.length() && (c = globPattern.charAt(i++)) != ']') {
                        if (c == '\\' || c == '[' || c == '&' && Glob.next(globPattern, i) == '&') {
                            regex.append('\\');
                        }
                        regex.append(c);
                        if (c == '-') {
                            if (!hasRangeStart) {
                                throw new PatternSyntaxException("Invalid range", globPattern, i - 1);
                            }
                            if ((c = Glob.next(globPattern, i++)) == '\u0000' || c == ']') break;
                            if (c < last) {
                                throw new PatternSyntaxException("Invalid range", globPattern, i - 3);
                            }
                            regex.append(c);
                            hasRangeStart = false;
                            continue;
                        }
                        hasRangeStart = true;
                        last = c;
                    }
                    if (c != ']') {
                        throw new PatternSyntaxException("Missing ']'", globPattern, i - 1);
                    }
                    regex.append("]");
                    continue block9;
                }
                case '\\': {
                    char next;
                    if (i == globPattern.length()) {
                        throw new PatternSyntaxException("No character to escape", globPattern, i - 1);
                    }
                    if (Glob.isGlobMeta(next = globPattern.charAt(i++)) || Glob.isRegexMeta(next)) {
                        regex.append('\\');
                    }
                    regex.append(next);
                    continue block9;
                }
                case '{': {
                    if (inGroup) {
                        throw new PatternSyntaxException("Cannot nest groups", globPattern, i - 1);
                    }
                    regex.append("(?");
                    if (Glob.next(globPattern, i) == '!') {
                        regex.append('!');
                        ++i;
                    } else {
                        regex.append(":");
                    }
                    inGroup = true;
                    continue block9;
                }
                case '}': {
                    if (inGroup) {
                        regex.append(")");
                        inGroup = false;
                        continue block9;
                    }
                    regex.append('}');
                    continue block9;
                }
            }
            if (Glob.isRegexMeta(c)) {
                regex.append('\\');
            }
            regex.append(c);
        }
        if (inGroup) {
            throw new PatternSyntaxException("Missing '}'", globPattern, i - 1);
        }
        return regex.append('$').toString();
    }

    public static String toRegexPattern(String globPattern, String defaultPatternIfError) {
        try {
            return Glob.toRegexPattern(globPattern);
        }
        catch (PatternSyntaxException ignored) {
            return defaultPatternIfError;
        }
    }
}

