/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.data;

import java.util.Comparator;
import java.util.function.Function;
import net.createmod.catnip.data.Pair;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class IntAttached<V>
extends Pair<Integer, V> {
    protected IntAttached(Integer first, V second) {
        super(first, second);
    }

    public static <V> IntAttached<V> with(int number, V value) {
        return new IntAttached<V>(number, value);
    }

    public static <V> IntAttached<V> withZero(V value) {
        return new IntAttached<V>(0, value);
    }

    public boolean isZero() {
        return (Integer)this.first == 0;
    }

    public boolean exceeds(int value) {
        return (Integer)this.first > value;
    }

    public boolean isOrBelowZero() {
        return (Integer)this.first <= 0;
    }

    public void increment() {
        Integer n = (Integer)this.first;
        this.first = (Integer)this.first + 1;
    }

    public void decrement() {
        Integer n = (Integer)this.first;
        this.first = (Integer)this.first - 1;
    }

    public V getValue() {
        return (V)this.getSecond();
    }

    public CompoundTag serializeNBT(Function<V, CompoundTag> serializer) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128365_("Item", (Tag)serializer.apply(this.getValue()));
        nbt.m_128405_("Location", ((Integer)this.getFirst()).intValue());
        return nbt;
    }

    public static Comparator<? super IntAttached<?>> comparator() {
        return (i1, i2) -> Integer.compare((Integer)i2.getFirst(), (Integer)i1.getFirst());
    }

    public static <T> IntAttached<T> read(CompoundTag nbt, Function<CompoundTag, T> deserializer) {
        return IntAttached.with(nbt.m_128451_("Location"), deserializer.apply(nbt.m_128469_("Item")));
    }
}

