/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.gui.element;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import javax.annotation.Nullable;
import net.createmod.catnip.gui.ILightingSettings;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.AbstractRenderElement;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.platform.CatnipClientServices;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;

public class GuiGameElement {
    public static GuiRenderBuilder of(ItemStack stack) {
        return new GuiItemRenderBuilder(stack);
    }

    public static GuiRenderBuilder of(ItemLike itemProvider) {
        return new GuiItemRenderBuilder(itemProvider);
    }

    public static GuiRenderBuilder of(BlockState state) {
        return new GuiBlockStateRenderBuilder(state);
    }

    public static GuiRenderBuilder of(BlockState state, BlockEntity blockEntity) {
        return new GuiBlockEntityRenderBuilder(state, blockEntity);
    }

    public static GuiRenderBuilder of(BlockEntity blockEntity) {
        return GuiGameElement.of(blockEntity.m_58900_(), blockEntity);
    }

    public static GuiRenderBuilder of(Fluid fluid) {
        return new GuiBlockStateRenderBuilder((BlockState)fluid.m_76145_().m_76188_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(0)));
    }

    public static GuiRenderBuilder of(PartialModel partial) {
        return new GuiBlockPartialRenderBuilder(partial);
    }

    public static class GuiItemRenderBuilder
    extends GuiRenderBuilder {
        private final ItemStack stack;

        public GuiItemRenderBuilder(ItemStack stack) {
            this.stack = stack;
        }

        public GuiItemRenderBuilder(ItemLike provider) {
            this(new ItemStack(provider));
        }

        @Override
        public void render(GuiGraphics graphics) {
            PoseStack poseStack = graphics.m_280168_();
            this.prepareMatrix(poseStack);
            this.transformMatrix(poseStack);
            GuiItemRenderBuilder.renderItemIntoGUI(poseStack, this.stack, this.customLighting == null);
            this.cleanUpMatrix(poseStack);
        }

        public static void renderItemIntoGUI(PoseStack poseStack, ItemStack stack, boolean useDefaultLighting) {
            boolean flatLighting;
            ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
            BakedModel bakedModel = renderer.m_174264_(stack, null, null, 0);
            renderer.f_115096_.m_118506_(InventoryMenu.f_39692_).m_117960_(false, false);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            RenderSystem.enableBlend();
            RenderSystem.enableCull();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 100.0f);
            poseStack.m_252880_(8.0f, -8.0f, 0.0f);
            poseStack.m_85841_(16.0f, 16.0f, 16.0f);
            MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
            boolean bl = flatLighting = !bakedModel.m_7547_();
            if (useDefaultLighting && flatLighting) {
                Lighting.m_84930_();
            }
            renderer.m_115143_(stack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_, bakedModel);
            RenderSystem.disableDepthTest();
            buffer.m_109911_();
            RenderSystem.enableDepthTest();
            if (useDefaultLighting && flatLighting) {
                Lighting.m_84931_();
            }
            poseStack.m_85849_();
        }
    }

    public static class GuiBlockStateRenderBuilder
    extends GuiBlockModelRenderBuilder {
        public GuiBlockStateRenderBuilder(BlockState blockstate) {
            super(Minecraft.m_91087_().m_91289_().m_110910_(blockstate), blockstate, null);
        }

        @Override
        protected void renderModel(BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource buffer, PoseStack poseStack) {
            if (this.blockState.m_60734_() instanceof BaseFireBlock) {
                Lighting.m_84930_();
                super.renderModel(blockRenderer, buffer, poseStack);
                Lighting.m_84931_();
                return;
            }
            super.renderModel(blockRenderer, buffer, poseStack);
            if (this.blockState.m_60819_().m_76178_()) {
                return;
            }
            CatnipClientServices.CLIENT_HOOKS.renderFullFluidState(poseStack, buffer, this.blockState.m_60819_());
            buffer.m_109911_();
        }
    }

    public static class GuiBlockEntityRenderBuilder
    extends GuiBlockModelRenderBuilder {
        public GuiBlockEntityRenderBuilder(BlockState blockState, BlockEntity blockEntity) {
            super(Minecraft.m_91087_().m_91289_().m_110910_(blockState), blockState, blockEntity);
        }

        @Override
        protected void renderModel(BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource buffer, PoseStack ms) {
            this.renderBlockEntity(blockRenderer, buffer, ms);
            super.renderModel(blockRenderer, buffer, ms);
        }

        private void renderBlockEntity(BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource buffer, PoseStack ms) {
            if (this.blockEntity == null) {
                return;
            }
            BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(this.blockEntity);
            if (renderer == null) {
                return;
            }
            BlockState stateBefore = this.blockEntity.m_58900_();
            this.blockEntity.m_155250_(this.blockState);
            renderer.m_6922_(this.blockEntity, 0.0f, ms, (MultiBufferSource)buffer, 0xF000F0, OverlayTexture.f_118083_);
            this.blockEntity.m_155250_(stateBefore);
        }
    }

    public static abstract class GuiRenderBuilder
    extends AbstractRenderElement {
        protected double xLocal;
        protected double yLocal;
        protected double zLocal;
        protected double xRot;
        protected double yRot;
        protected double zRot;
        protected double scale = 1.0;
        protected int color = 0xFFFFFF;
        protected Vec3 rotationOffset = Vec3.f_82478_;
        @Nullable
        protected ILightingSettings customLighting = null;

        public GuiRenderBuilder atLocal(double x, double y, double z) {
            this.xLocal = x;
            this.yLocal = y;
            this.zLocal = z;
            return this;
        }

        public GuiRenderBuilder rotate(double xRot, double yRot, double zRot) {
            this.xRot = xRot;
            this.yRot = yRot;
            this.zRot = zRot;
            return this;
        }

        public GuiRenderBuilder rotateBlock(double xRot, double yRot, double zRot) {
            return this.rotate(xRot, yRot, zRot).withRotationOffset(VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_));
        }

        public GuiRenderBuilder scale(double scale) {
            this.scale = scale;
            return this;
        }

        public GuiRenderBuilder color(int color) {
            this.color = color;
            return this;
        }

        public GuiRenderBuilder withRotationOffset(Vec3 offset) {
            this.rotationOffset = offset;
            return this;
        }

        public GuiRenderBuilder lighting(ILightingSettings lighting) {
            this.customLighting = lighting;
            return this;
        }

        protected void prepareMatrix(PoseStack poseStack) {
            poseStack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.prepareLighting(poseStack);
        }

        protected void transformMatrix(PoseStack poseStack) {
            poseStack.m_252880_(this.x, this.y, this.z);
            poseStack.m_85841_((float)this.scale, (float)this.scale, (float)this.scale);
            poseStack.m_85837_(this.xLocal, this.yLocal, this.zLocal);
            UIRenderHelper.flipForGuiRender(poseStack);
            poseStack.m_85837_(this.rotationOffset.f_82479_, this.rotationOffset.f_82480_, this.rotationOffset.f_82481_);
            poseStack.m_252781_(Axis.f_252403_.m_252977_((float)this.zRot));
            poseStack.m_252781_(Axis.f_252529_.m_252977_((float)this.xRot));
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)this.yRot));
            poseStack.m_85837_(-this.rotationOffset.f_82479_, -this.rotationOffset.f_82480_, -this.rotationOffset.f_82481_);
        }

        protected void cleanUpMatrix(PoseStack poseStack) {
            poseStack.m_85849_();
            this.cleanUpLighting(poseStack);
        }

        protected void prepareLighting(PoseStack poseStack) {
            if (this.customLighting != null) {
                this.customLighting.applyLighting();
            } else {
                Lighting.m_84931_();
            }
        }

        protected void cleanUpLighting(PoseStack poseStack) {
            if (this.customLighting != null) {
                Lighting.m_84931_();
            }
        }
    }

    public static class GuiBlockPartialRenderBuilder
    extends GuiBlockModelRenderBuilder {
        public GuiBlockPartialRenderBuilder(PartialModel partial) {
            super(partial.get(), null, null);
        }
    }

    protected static class GuiBlockModelRenderBuilder
    extends GuiRenderBuilder {
        protected BakedModel blockModel;
        protected BlockState blockState;
        @Nullable
        protected BlockEntity blockEntity;

        public GuiBlockModelRenderBuilder(BakedModel blockmodel, @Nullable BlockState blockState, @Nullable BlockEntity blockEntity) {
            this.blockState = blockState == null ? Blocks.f_50016_.m_49966_() : blockState;
            this.blockModel = blockmodel;
            this.blockEntity = blockEntity;
        }

        @Override
        public void render(GuiGraphics graphics) {
            PoseStack poseStack = graphics.m_280168_();
            this.prepareMatrix(poseStack);
            Minecraft mc = Minecraft.m_91087_();
            BlockRenderDispatcher blockRenderer = mc.m_91289_();
            MultiBufferSource.BufferSource buffer = graphics.m_280091_();
            this.transformMatrix(poseStack);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
            this.renderModel(blockRenderer, buffer, poseStack);
            this.cleanUpMatrix(poseStack);
        }

        protected void renderModel(BlockRenderDispatcher blockRenderer, MultiBufferSource.BufferSource buffer, PoseStack ms) {
            CatnipClientServices.CLIENT_HOOKS.renderGuiGameElementModel(blockRenderer, buffer, ms, this.blockState, this.blockModel, this.color, this.blockEntity);
            buffer.m_109911_();
        }
    }
}

