/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.lang;

import com.google.common.base.Strings;
import java.text.BreakIterator;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.platform.CatnipClientServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;

public final class FontHelper {
    public static final int MAX_WIDTH_PER_LINE = 200;

    private FontHelper() {
    }

    public static Style styleFromColor(ChatFormatting color) {
        return Style.f_131099_.m_131157_(color);
    }

    public static Style styleFromColor(int hex) {
        return Style.f_131099_.m_178520_(hex);
    }

    public static List<Component> cutStringTextComponent(String s, Palette palette) {
        return FontHelper.cutTextComponent((Component)Component.m_237113_((String)s), palette);
    }

    public static List<Component> cutTextComponent(Component c, Palette palette) {
        return FontHelper.cutTextComponent(c, palette.primary(), palette.highlight());
    }

    public static List<Component> cutStringTextComponent(String s, Style primaryStyle, Style highlightStyle) {
        return FontHelper.cutTextComponent((Component)Component.m_237113_((String)s), primaryStyle, highlightStyle);
    }

    public static List<Component> cutTextComponent(Component c, Style primaryStyle, Style highlightStyle) {
        return FontHelper.cutTextComponent(c, primaryStyle, highlightStyle, 0);
    }

    public static List<Component> cutStringTextComponent(String c, Style primaryStyle, Style highlightStyle, int indent) {
        return FontHelper.cutTextComponent((Component)Component.m_237113_((String)c), primaryStyle, highlightStyle, indent);
    }

    public static List<Component> cutTextComponent(Component c, Style primaryStyle, Style highlightStyle, int indent) {
        String s = c.getString();
        LinkedList<String> words = new LinkedList<String>();
        BreakIterator iterator = BreakIterator.getLineInstance(CatnipClientServices.CLIENT_HOOKS.getCurrentLocale());
        iterator.setText(s);
        int start = iterator.first();
        int end = iterator.next();
        while (end != -1) {
            String word = s.substring(start, end);
            words.add(word);
            start = end;
            end = iterator.next();
        }
        Font font = Minecraft.m_91087_().f_91062_;
        LinkedList<String> lines = new LinkedList<String>();
        StringBuilder currentLine = new StringBuilder();
        int width = 0;
        for (String word : words) {
            int newWidth = font.m_92895_(word.replaceAll("_", ""));
            if (width + newWidth > 200) {
                if (width > 0) {
                    String line = currentLine.toString();
                    lines.add(line);
                    currentLine = new StringBuilder();
                    width = 0;
                } else {
                    lines.add(word);
                    continue;
                }
            }
            currentLine.append(word);
            width += newWidth;
        }
        if (width > 0) {
            lines.add(currentLine.toString());
        }
        MutableComponent lineStart = Component.m_237113_((String)Strings.repeat((String)" ", (int)indent));
        lineStart.m_130948_(primaryStyle);
        ArrayList<Component> formattedLines = new ArrayList<Component>(lines.size());
        Couple<Style> styles = Couple.create(highlightStyle, primaryStyle);
        boolean currentlyHighlighted = false;
        for (String string : lines) {
            String[] split;
            MutableComponent currentComponent = lineStart.m_6879_();
            for (String part : split = string.split("_")) {
                currentComponent.m_7220_((Component)Component.m_237113_((String)part).m_130948_(styles.get(currentlyHighlighted)));
                currentlyHighlighted = !currentlyHighlighted;
            }
            formattedLines.add((Component)currentComponent);
            currentlyHighlighted = !currentlyHighlighted;
        }
        return formattedLines;
    }

    public record Palette(Style primary, Style highlight) {
        public static final Palette STANDARD_CREATE = new Palette(FontHelper.styleFromColor(13211468), FontHelper.styleFromColor(15850873));
        public static final Palette BLUE = Palette.ofColors(ChatFormatting.BLUE, ChatFormatting.AQUA);
        public static final Palette GREEN = Palette.ofColors(ChatFormatting.DARK_GREEN, ChatFormatting.GREEN);
        public static final Palette YELLOW = Palette.ofColors(ChatFormatting.GOLD, ChatFormatting.YELLOW);
        public static final Palette RED = Palette.ofColors(ChatFormatting.DARK_RED, ChatFormatting.RED);
        public static final Palette PURPLE = Palette.ofColors(ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE);
        public static final Palette GRAY = Palette.ofColors(ChatFormatting.DARK_GRAY, ChatFormatting.GRAY);
        public static final Palette ALL_GRAY = Palette.ofColors(ChatFormatting.GRAY, ChatFormatting.GRAY);
        public static final Palette GRAY_AND_BLUE = Palette.ofColors(ChatFormatting.GRAY, ChatFormatting.BLUE);
        public static final Palette GRAY_AND_WHITE = Palette.ofColors(ChatFormatting.GRAY, ChatFormatting.WHITE);
        public static final Palette GRAY_AND_GOLD = Palette.ofColors(ChatFormatting.GRAY, ChatFormatting.GOLD);
        public static final Palette GRAY_AND_RED = Palette.ofColors(ChatFormatting.GRAY, ChatFormatting.RED);

        public static Palette ofColors(ChatFormatting primary, ChatFormatting highlight) {
            return new Palette(FontHelper.styleFromColor(primary), FontHelper.styleFromColor(highlight));
        }
    }
}

