/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.math;

import com.mojang.math.Axis;
import javax.annotation.Nullable;
import net.createmod.ponder.mixin.client.accessor.GameRendererAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class VecHelper {
    public static final Vec3 CENTER_OF_ORIGIN = new Vec3(0.5, 0.5, 0.5);

    public static Vec3 rotate(Vec3 vec, Vec3 rotationVec) {
        return VecHelper.rotate(vec, rotationVec.f_82479_, rotationVec.f_82480_, rotationVec.f_82481_);
    }

    public static Vec3 rotate(Vec3 vec, double xRot, double yRot, double zRot) {
        return VecHelper.rotate(VecHelper.rotate(VecHelper.rotate(vec, xRot, Direction.Axis.X), yRot, Direction.Axis.Y), zRot, Direction.Axis.Z);
    }

    public static Vec3 rotateCentered(Vec3 vec, double deg, Direction.Axis axis) {
        Vec3 shift = VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_);
        return VecHelper.rotate(vec.m_82546_(shift), deg, axis).m_82549_(shift);
    }

    public static Vec3 rotate(Vec3 vec, double deg, Direction.Axis axis) {
        if (deg == 0.0) {
            return vec;
        }
        if (vec == Vec3.f_82478_) {
            return vec;
        }
        float angle = (float)(deg / 180.0 * Math.PI);
        double sin = Mth.m_14031_((float)angle);
        double cos = Mth.m_14089_((float)angle);
        double x = vec.f_82479_;
        double y = vec.f_82480_;
        double z = vec.f_82481_;
        if (axis == Direction.Axis.X) {
            return new Vec3(x, y * cos - z * sin, z * cos + y * sin);
        }
        if (axis == Direction.Axis.Y) {
            return new Vec3(x * cos + z * sin, y, z * cos - x * sin);
        }
        if (axis == Direction.Axis.Z) {
            return new Vec3(x * cos - y * sin, y * cos + x * sin, z);
        }
        return vec;
    }

    public static Vec3 mirrorCentered(Vec3 vec, Mirror mirror) {
        Vec3 shift = VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_);
        return VecHelper.mirror(vec.m_82546_(shift), mirror).m_82549_(shift);
    }

    public static Vec3 mirror(Vec3 vec, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return vec;
        }
        if (vec == Vec3.f_82478_) {
            return vec;
        }
        double x = vec.f_82479_;
        double y = vec.f_82480_;
        double z = vec.f_82481_;
        if (mirror == Mirror.LEFT_RIGHT) {
            return new Vec3(x, y, -z);
        }
        if (mirror == Mirror.FRONT_BACK) {
            return new Vec3(-x, y, z);
        }
        return vec;
    }

    public static Vec3 lookAt(Vec3 vec, Vec3 fwd) {
        Vec3 up;
        double dot = (fwd = fwd.m_82541_()).m_82526_(up = new Vec3(0.0, 1.0, 0.0));
        if (Math.abs(dot) > 0.999) {
            up = new Vec3(0.0, 0.0, dot > 0.0 ? 1.0 : -1.0);
        }
        Vec3 right = fwd.m_82537_(up).m_82541_();
        up = right.m_82537_(fwd).m_82541_();
        double x = vec.f_82479_ * right.f_82479_ + vec.f_82480_ * up.f_82479_ + vec.f_82481_ * fwd.f_82479_;
        double y = vec.f_82479_ * right.f_82480_ + vec.f_82480_ * up.f_82480_ + vec.f_82481_ * fwd.f_82480_;
        double z = vec.f_82479_ * right.f_82481_ + vec.f_82480_ * up.f_82481_ + vec.f_82481_ * fwd.f_82481_;
        return new Vec3(x, y, z);
    }

    public static boolean isVecPointingTowards(Vec3 vec, Direction direction) {
        return Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82526_(vec.m_82541_()) > 0.125;
    }

    public static Vec3 getCenterOf(Vec3i pos) {
        if (pos.equals((Object)Vec3i.f_123288_)) {
            return CENTER_OF_ORIGIN;
        }
        return Vec3.m_82528_((Vec3i)pos).m_82520_(0.5, 0.5, 0.5);
    }

    public static Vec3 offsetRandomly(Vec3 vec, RandomSource r, float radius) {
        return new Vec3(vec.f_82479_ + (double)((r.m_188501_() - 0.5f) * 2.0f * radius), vec.f_82480_ + (double)((r.m_188501_() - 0.5f) * 2.0f * radius), vec.f_82481_ + (double)((r.m_188501_() - 0.5f) * 2.0f * radius));
    }

    public static Vec3 axisAlingedPlaneOf(Vec3 vec) {
        vec = vec.m_82541_();
        return new Vec3(1.0, 1.0, 1.0).m_82492_(Math.abs(vec.f_82479_), Math.abs(vec.f_82480_), Math.abs(vec.f_82481_));
    }

    public static Vec3 axisAlingedPlaneOf(Direction face) {
        return VecHelper.axisAlingedPlaneOf(Vec3.m_82528_((Vec3i)face.m_122436_()));
    }

    public static ListTag writeNBT(Vec3 vec) {
        ListTag listnbt = new ListTag();
        listnbt.add((Object)DoubleTag.m_128500_((double)vec.f_82479_));
        listnbt.add((Object)DoubleTag.m_128500_((double)vec.f_82480_));
        listnbt.add((Object)DoubleTag.m_128500_((double)vec.f_82481_));
        return listnbt;
    }

    public static CompoundTag writeNBTCompound(Vec3 vec) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128365_("V", (Tag)VecHelper.writeNBT(vec));
        return compoundTag;
    }

    public static Vec3 readNBT(ListTag list) {
        if (list.isEmpty()) {
            return Vec3.f_82478_;
        }
        return new Vec3(list.m_128772_(0), list.m_128772_(1), list.m_128772_(2));
    }

    public static Vec3 readNBTCompound(CompoundTag nbt) {
        return VecHelper.readNBT(nbt.m_128437_("V", 6));
    }

    public static void write(Vec3 vec, FriendlyByteBuf buffer) {
        buffer.writeDouble(vec.f_82479_);
        buffer.writeDouble(vec.f_82480_);
        buffer.writeDouble(vec.f_82481_);
    }

    public static Vec3 read(FriendlyByteBuf buffer) {
        return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static Vec3 voxelSpace(double x, double y, double z) {
        return new Vec3(x, y, z).m_82490_(0.0625);
    }

    public static int getCoordinate(Vec3i pos, Direction.Axis axis) {
        return axis.m_7863_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static float getCoordinate(Vec3 vec, Direction.Axis axis) {
        return (float)axis.m_6150_(vec.f_82479_, vec.f_82480_, vec.f_82481_);
    }

    public static boolean onSameAxis(BlockPos pos1, BlockPos pos2, Direction.Axis axis) {
        if (pos1.equals((Object)pos2)) {
            return true;
        }
        for (Direction.Axis otherAxis : Direction.Axis.values()) {
            if (axis == otherAxis || VecHelper.getCoordinate((Vec3i)pos1, otherAxis) == VecHelper.getCoordinate((Vec3i)pos2, otherAxis)) continue;
            return false;
        }
        return true;
    }

    public static Vec3 clamp(Vec3 vec, float maxLength) {
        return vec.m_82556_() > (double)(maxLength * maxLength) ? vec.m_82541_().m_82490_((double)maxLength) : vec;
    }

    public static Vec3 lerp(float p, Vec3 from, Vec3 to) {
        return from.m_82549_(to.m_82546_(from).m_82490_((double)p));
    }

    public static Vec3 slerp(float p, Vec3 from, Vec3 to) {
        double theta = Math.acos(from.m_82526_(to));
        return from.m_82490_((double)Mth.m_14031_((float)(1.0f - p)) * theta).m_82549_(to.m_82490_((double)Mth.m_14031_((float)((float)(theta * (double)p))))).m_82490_((double)(1.0f / Mth.m_14031_((float)((float)theta))));
    }

    public static Vec3 clampComponentWise(Vec3 vec, float maxLength) {
        return new Vec3(Mth.m_14008_((double)vec.f_82479_, (double)(-maxLength), (double)maxLength), Mth.m_14008_((double)vec.f_82480_, (double)(-maxLength), (double)maxLength), Mth.m_14008_((double)vec.f_82481_, (double)(-maxLength), (double)maxLength));
    }

    public static Vec3 componentMin(Vec3 vec1, Vec3 vec2) {
        return new Vec3(Math.min(vec1.f_82479_, vec2.f_82479_), Math.min(vec1.f_82480_, vec2.f_82480_), Math.min(vec1.f_82481_, vec2.f_82481_));
    }

    public static Vec3 componentMax(Vec3 vec1, Vec3 vec2) {
        return new Vec3(Math.max(vec1.f_82479_, vec2.f_82479_), Math.max(vec1.f_82480_, vec2.f_82480_), Math.max(vec1.f_82481_, vec2.f_82481_));
    }

    public static Vec3 project(Vec3 vec, Vec3 ontoVec) {
        if (ontoVec.equals((Object)Vec3.f_82478_)) {
            return Vec3.f_82478_;
        }
        return ontoVec.m_82490_(vec.m_82526_(ontoVec) / ontoVec.m_82556_());
    }

    @Nullable
    public static Vec3 intersectSphere(Vec3 origin, Vec3 lineDirection, Vec3 sphereCenter, double radius) {
        Vec3 diff;
        double lineDotDiff;
        double delta;
        if (lineDirection.equals((Object)Vec3.f_82478_)) {
            return null;
        }
        if (lineDirection.m_82556_() != 1.0) {
            lineDirection = lineDirection.m_82541_();
        }
        if ((delta = (lineDotDiff = lineDirection.m_82526_(diff = origin.m_82546_(sphereCenter))) * lineDotDiff - (diff.m_82556_() - radius * radius)) < 0.0) {
            return null;
        }
        double t = -lineDotDiff + Math.sqrt(delta);
        return origin.m_82549_(lineDirection.m_82490_(t));
    }

    public static Vec3 projectToPlayerView(Vec3 target, float partialTicks) {
        Entity renderViewEntity;
        Camera ari = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 camera_pos = ari.m_90583_();
        Quaternionf camera_rotation_conj = new Quaternionf((Quaternionfc)ari.m_253121_());
        camera_rotation_conj.conjugate();
        Vector3f result3f = new Vector3f((float)(camera_pos.f_82479_ - target.f_82479_), (float)(camera_pos.f_82480_ - target.f_82480_), (float)(camera_pos.f_82481_ - target.f_82481_));
        result3f.rotate((Quaternionfc)camera_rotation_conj);
        Minecraft mc = Minecraft.m_91087_();
        if (((Boolean)mc.f_91066_.m_231830_().m_231551_()).booleanValue() && (renderViewEntity = mc.m_91288_()) instanceof Player) {
            Player playerEntity = (Player)renderViewEntity;
            float walkDist_modified = playerEntity.f_19787_;
            float f = walkDist_modified - playerEntity.f_19867_;
            float f1 = -(walkDist_modified + f * partialTicks);
            float f2 = Mth.m_14179_((float)partialTicks, (float)playerEntity.f_36099_, (float)playerEntity.f_36100_);
            Quaternionf q2 = Axis.f_252529_.m_252977_(Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI - 0.2f)) * f2) * 5.0f);
            q2.conjugate();
            result3f.rotate((Quaternionfc)q2);
            Quaternionf q1 = Axis.f_252403_.m_252977_(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 3.0f);
            q1.conjugate();
            result3f.rotate((Quaternionfc)q1);
            Vector3f bob_translation = new Vector3f(Mth.m_14031_((float)(f1 * (float)Math.PI)) * f2 * 0.5f, -Math.abs(Mth.m_14089_((float)(f1 * (float)Math.PI)) * f2), 0.0f);
            bob_translation.set(bob_translation.x(), -bob_translation.y(), bob_translation.z());
            result3f.add((Vector3fc)bob_translation);
        }
        float fov = (float)((GameRendererAccessor)mc.f_91063_).catnip$callGetFov(ari, partialTicks, true);
        float half_height = (float)mc.m_91268_().m_85446_() / 2.0f;
        float scale_factor = half_height / (result3f.z() * (float)Math.tan(Math.toRadians(fov / 2.0f)));
        return new Vec3((double)(-result3f.x() * scale_factor), (double)(result3f.y() * scale_factor), (double)result3f.z());
    }

    public static Vec3 bezier(Vec3 p1, Vec3 p2, Vec3 q1, Vec3 q2, float t) {
        Vec3 v1 = VecHelper.lerp(t, p1, q1);
        Vec3 v2 = VecHelper.lerp(t, q1, q2);
        Vec3 v3 = VecHelper.lerp(t, q2, p2);
        Vec3 inner1 = VecHelper.lerp(t, v1, v2);
        Vec3 inner2 = VecHelper.lerp(t, v2, v3);
        return VecHelper.lerp(t, inner1, inner2);
    }

    public static Vec3 bezierDerivative(Vec3 p1, Vec3 p2, Vec3 q1, Vec3 q2, float t) {
        return p1.m_82490_((double)(-3.0f * t * t + 6.0f * t - 3.0f)).m_82549_(q1.m_82490_((double)(9.0f * t * t - 12.0f * t + 3.0f))).m_82549_(q2.m_82490_((double)(-9.0f * t * t + 6.0f * t))).m_82549_(p2.m_82490_((double)(3.0f * t * t)));
    }

    @Nullable
    public static double[] intersectRanged(Vec3 p1, Vec3 q1, Vec3 p2, Vec3 q2, Direction.Axis plane) {
        Vec3 pDiff = p2.m_82546_(p1);
        Vec3 qDiff = q2.m_82546_(q1);
        double[] intersect = VecHelper.intersect(p1, q1, pDiff.m_82541_(), qDiff.m_82541_(), plane);
        if (intersect == null) {
            return null;
        }
        if (intersect[0] < 0.0 || intersect[1] < 0.0) {
            return null;
        }
        if (intersect[0] * intersect[0] > pDiff.m_82556_() || intersect[1] * intersect[1] > qDiff.m_82556_()) {
            return null;
        }
        return intersect;
    }

    @Nullable
    public static double[] intersect(Vec3 p1, Vec3 p2, Vec3 r, Vec3 s, Direction.Axis plane) {
        if (plane == Direction.Axis.X) {
            p1 = new Vec3(p1.f_82480_, 0.0, p1.f_82481_);
            p2 = new Vec3(p2.f_82480_, 0.0, p2.f_82481_);
            r = new Vec3(r.f_82480_, 0.0, r.f_82481_);
            s = new Vec3(s.f_82480_, 0.0, s.f_82481_);
        }
        if (plane == Direction.Axis.Z) {
            p1 = new Vec3(p1.f_82479_, 0.0, p1.f_82480_);
            p2 = new Vec3(p2.f_82479_, 0.0, p2.f_82480_);
            r = new Vec3(r.f_82479_, 0.0, r.f_82480_);
            s = new Vec3(s.f_82479_, 0.0, s.f_82480_);
        }
        Vec3 qminusp = p2.m_82546_(p1);
        double rcs = r.f_82479_ * s.f_82481_ - r.f_82481_ * s.f_82479_;
        if (Mth.m_14082_((double)rcs, (double)0.0)) {
            return null;
        }
        Vec3 rdivrcs = r.m_82490_(1.0 / rcs);
        Vec3 sdivrcs = s.m_82490_(1.0 / rcs);
        double t = qminusp.f_82479_ * sdivrcs.f_82481_ - qminusp.f_82481_ * sdivrcs.f_82479_;
        double u = qminusp.f_82479_ * rdivrcs.f_82481_ - qminusp.f_82481_ * rdivrcs.f_82479_;
        return new double[]{t, u};
    }

    public static double alignedDistanceToFace(Vec3 pos, BlockPos blockPos, Direction face) {
        Direction.Axis axis = face.m_122434_();
        return Math.abs(VecHelper.getCoordinate(pos, axis) - (float)(blockPos.m_123304_(axis) + (face.m_122421_() == Direction.AxisDirection.POSITIVE ? 1 : 0)));
    }
}

