/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.outliner;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.render.BindableTexture;
import net.createmod.catnip.render.PonderRenderTypes;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BlockClusterOutline
extends Outline {
    private final Cluster cluster;
    protected final Vector3f pos0Temp = new Vector3f();
    protected final Vector3f pos1Temp = new Vector3f();
    protected final Vector3f pos2Temp = new Vector3f();
    protected final Vector3f pos3Temp = new Vector3f();
    protected final Vector3f normalTemp = new Vector3f();
    protected final Vector3f originTemp = new Vector3f();

    public BlockClusterOutline(Iterable<BlockPos> positions) {
        this.cluster = new Cluster();
        positions.forEach(this.cluster::include);
    }

    @Override
    public void render(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, float pt) {
        this.params.loadColor(this.colorTemp);
        Vector4f color = this.colorTemp;
        int lightmap = this.params.lightmap;
        boolean disableLineNormals = this.params.disableLineNormals;
        this.renderFaces(ms, buffer, camera, pt, color, lightmap);
        this.renderEdges(ms, buffer, camera, pt, color, lightmap, disableLineNormals);
    }

    protected void renderFaces(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, float pt, Vector4f color, int lightmap) {
        BindableTexture faceTexture = this.params.faceTexture;
        if (faceTexture == null) {
            return;
        }
        if (this.cluster.isEmpty()) {
            return;
        }
        ms.m_85836_();
        ms.m_85837_((double)this.cluster.anchor.m_123341_() - camera.f_82479_, (double)this.cluster.anchor.m_123342_() - camera.f_82480_, (double)this.cluster.anchor.m_123343_() - camera.f_82481_);
        PoseStack.Pose pose = ms.m_85850_();
        RenderType renderType = PonderRenderTypes.outlineTranslucent(faceTexture.getLocation(), true);
        VertexConsumer consumer = buffer.getLateBuffer(renderType);
        this.cluster.visibleFaces.forEach((face, axisDirection) -> {
            Direction direction = Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)face.axis);
            BlockPos pos = face.pos;
            if (axisDirection == Direction.AxisDirection.POSITIVE) {
                pos = pos.m_121945_(direction.m_122424_());
            }
            this.bufferBlockFace(pose, consumer, pos, direction, color, lightmap);
        });
        ms.m_85849_();
    }

    protected void renderEdges(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera, float pt, Vector4f color, int lightmap, boolean disableNormals) {
        float lineWidth = this.params.getLineWidth();
        if (lineWidth == 0.0f) {
            return;
        }
        if (this.cluster.isEmpty()) {
            return;
        }
        ms.m_85836_();
        ms.m_85837_((double)this.cluster.anchor.m_123341_() - camera.f_82479_, (double)this.cluster.anchor.m_123342_() - camera.f_82480_, (double)this.cluster.anchor.m_123343_() - camera.f_82481_);
        PoseStack.Pose pose = ms.m_85850_();
        VertexConsumer consumer = buffer.m_6299_(PonderRenderTypes.outlineSolid());
        this.cluster.visibleEdges.forEach(edge -> {
            BlockPos pos = edge.pos;
            Vector3f origin = this.originTemp;
            origin.set((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)edge.axis);
            this.bufferCuboidLine(pose, consumer, origin, direction, 1.0f, lineWidth, color, lightmap, disableNormals);
        });
        ms.m_85849_();
    }

    public static void loadFaceData(Direction face, Vector3f pos0, Vector3f pos1, Vector3f pos2, Vector3f pos3, Vector3f normal) {
        switch (face) {
            case DOWN: {
                pos0.set(0.0f, 0.0f, 1.0f);
                pos1.set(0.0f, 0.0f, 0.0f);
                pos2.set(1.0f, 0.0f, 0.0f);
                pos3.set(1.0f, 0.0f, 1.0f);
                normal.set(0.0f, -1.0f, 0.0f);
                break;
            }
            case UP: {
                pos0.set(0.0f, 1.0f, 0.0f);
                pos1.set(0.0f, 1.0f, 1.0f);
                pos2.set(1.0f, 1.0f, 1.0f);
                pos3.set(1.0f, 1.0f, 0.0f);
                normal.set(0.0f, 1.0f, 0.0f);
                break;
            }
            case NORTH: {
                pos0.set(1.0f, 1.0f, 0.0f);
                pos1.set(1.0f, 0.0f, 0.0f);
                pos2.set(0.0f, 0.0f, 0.0f);
                pos3.set(0.0f, 1.0f, 0.0f);
                normal.set(0.0f, 0.0f, -1.0f);
                break;
            }
            case SOUTH: {
                pos0.set(0.0f, 1.0f, 1.0f);
                pos1.set(0.0f, 0.0f, 1.0f);
                pos2.set(1.0f, 0.0f, 1.0f);
                pos3.set(1.0f, 1.0f, 1.0f);
                normal.set(0.0f, 0.0f, 1.0f);
                break;
            }
            case WEST: {
                pos0.set(0.0f, 1.0f, 0.0f);
                pos1.set(0.0f, 0.0f, 0.0f);
                pos2.set(0.0f, 0.0f, 1.0f);
                pos3.set(0.0f, 1.0f, 1.0f);
                normal.set(-1.0f, 0.0f, 0.0f);
                break;
            }
            case EAST: {
                pos0.set(1.0f, 1.0f, 1.0f);
                pos1.set(1.0f, 0.0f, 1.0f);
                pos2.set(1.0f, 0.0f, 0.0f);
                pos3.set(1.0f, 1.0f, 0.0f);
                normal.set(1.0f, 0.0f, 0.0f);
            }
        }
    }

    public static void addPos(float x, float y, float z, Vector3f pos0, Vector3f pos1, Vector3f pos2, Vector3f pos3) {
        pos0.add(x, y, z);
        pos1.add(x, y, z);
        pos2.add(x, y, z);
        pos3.add(x, y, z);
    }

    protected void bufferBlockFace(PoseStack.Pose pose, VertexConsumer consumer, BlockPos pos, Direction face, Vector4f color, int lightmap) {
        Vector3f pos0 = this.pos0Temp;
        Vector3f pos1 = this.pos1Temp;
        Vector3f pos2 = this.pos2Temp;
        Vector3f pos3 = this.pos3Temp;
        Vector3f normal = this.normalTemp;
        BlockClusterOutline.loadFaceData(face, pos0, pos1, pos2, pos3, normal);
        BlockClusterOutline.addPos((float)pos.m_123341_() + (float)(face.m_122429_() * 1) / 128.0f, (float)pos.m_123342_() + (float)(face.m_122430_() * 1) / 128.0f, (float)pos.m_123343_() + (float)(face.m_122431_() * 1) / 128.0f, pos0, pos1, pos2, pos3);
        this.bufferQuad(pose, consumer, pos0, pos1, pos2, pos3, color, lightmap, normal);
    }

    private static class Cluster {
        private BlockPos anchor;
        private Map<MergeEntry, Direction.AxisDirection> visibleFaces;
        private Set<MergeEntry> visibleEdges = new HashSet<MergeEntry>();

        public Cluster() {
            this.visibleFaces = new HashMap<MergeEntry, Direction.AxisDirection>();
        }

        public boolean isEmpty() {
            return this.anchor == null;
        }

        public void include(BlockPos pos) {
            if (this.anchor == null) {
                this.anchor = pos;
            }
            pos = pos.m_121996_((Vec3i)this.anchor);
            for (Direction.Axis axis : Iterate.axes) {
                Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
                int[] nArray = Iterate.zeroAndOne;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int offset = nArray[i];
                    MergeEntry entry = new MergeEntry(axis, pos.m_5484_(direction, offset));
                    if (this.visibleFaces.remove(entry) != null) continue;
                    this.visibleFaces.put(entry, offset == 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE);
                }
            }
            block2: for (Direction.Axis axis : Iterate.axes) {
                for (Direction.Axis axis2 : Iterate.axes) {
                    if (axis == axis2) continue;
                    for (Direction.Axis axis3 : Iterate.axes) {
                        if (axis == axis3 || axis2 == axis3) continue;
                        Direction direction = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis2);
                        Direction direction2 = Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis3);
                        for (int offset : Iterate.zeroAndOne) {
                            BlockPos entryPos = pos.m_5484_(direction, offset);
                            for (int offset2 : Iterate.zeroAndOne) {
                                MergeEntry entry = new MergeEntry(axis, entryPos = entryPos.m_5484_(direction2, offset2));
                                if (this.visibleEdges.remove(entry)) continue;
                                this.visibleEdges.add(entry);
                            }
                        }
                    }
                    continue block2;
                }
            }
        }
    }

    private static class MergeEntry {
        private Direction.Axis axis;
        private BlockPos pos;

        public MergeEntry(Direction.Axis axis, BlockPos pos) {
            this.axis = axis;
            this.pos = pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MergeEntry)) {
                return false;
            }
            MergeEntry other = (MergeEntry)o;
            return this.axis == other.axis && this.pos.equals((Object)other.pos);
        }

        public int hashCode() {
            return this.pos.hashCode() * 31 + this.axis.ordinal();
        }
    }
}

