/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.render.PonderRenderTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BasicFluidRenderer {
    public static VertexConsumer getFluidBuilder(MultiBufferSource buffer) {
        return buffer.m_6299_(PonderRenderTypes.fluid());
    }

    public static void renderFluidBox(Fluid fluid, long amount, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, boolean renderBottom, boolean invertGasses) {
        BasicFluidRenderer.renderFluidBox(fluid, amount, xMin, yMin, zMin, xMax, yMax, zMax, BasicFluidRenderer.getFluidBuilder(buffer), ms, light, renderBottom, invertGasses, null);
    }

    public static void renderFluidBox(Fluid fluid, long amount, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack ms, int light, boolean renderBottom, boolean invertGasses) {
        BasicFluidRenderer.renderFluidBox(fluid, amount, xMin, yMin, zMin, xMax, yMax, zMax, builder, ms, light, renderBottom, invertGasses, null);
    }

    public static void renderFluidBox(Fluid fluid, long amount, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, MultiBufferSource buffer, PoseStack ms, int light, boolean renderBottom, boolean invertGasses, @Nullable CompoundTag fluidData) {
        BasicFluidRenderer.renderFluidBox(fluid, amount, xMin, yMin, zMin, xMax, yMax, zMax, BasicFluidRenderer.getFluidBuilder(buffer), ms, light, renderBottom, invertGasses, fluidData);
    }

    public static void renderFluidBox(Fluid fluid, long amount, float xMin, float yMin, float zMin, float xMax, float yMax, float zMax, VertexConsumer builder, PoseStack ms, int light, boolean renderBottom, boolean invertGasses, @Nullable CompoundTag fluidData) {
        TextureAtlasSprite fluidTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(CatnipServices.FLUID_HELPER.getStillTexture(fluid, amount, fluidData));
        int color = CatnipServices.FLUID_HELPER.getColor(fluid, amount, fluidData);
        int blockLightIn = light >> 4 & 0xF;
        int luminosity = Math.max(blockLightIn, CatnipServices.FLUID_HELPER.getLuminosity(fluid, amount, fluidData));
        light = light & 0xF00000 | luminosity << 4;
        Vec3 center = new Vec3((double)(xMin + (xMax - xMin) / 2.0f), (double)(yMin + (yMax - yMin) / 2.0f), (double)(zMin + (zMax - zMin) / 2.0f));
        ms.m_85836_();
        if (invertGasses && CatnipServices.FLUID_HELPER.isLighterThanAir(fluid)) {
            ms.m_85837_(center.f_82479_, center.f_82480_, center.f_82481_);
            ms.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            ms.m_85837_(-center.f_82479_, -center.f_82480_, -center.f_82481_);
        }
        for (Direction side : Iterate.directions) {
            boolean positive;
            if (side == Direction.DOWN && !renderBottom) continue;
            boolean bl = positive = side.m_122421_() == Direction.AxisDirection.POSITIVE;
            if (side.m_122434_().m_122479_()) {
                if (side.m_122434_() == Direction.Axis.X) {
                    BasicFluidRenderer.renderStillTiledFace(side, zMin, yMin, zMax, yMax, positive ? xMax : xMin, builder, ms, light, color, fluidTexture);
                    continue;
                }
                BasicFluidRenderer.renderStillTiledFace(side, xMin, yMin, xMax, yMax, positive ? zMax : zMin, builder, ms, light, color, fluidTexture);
                continue;
            }
            BasicFluidRenderer.renderStillTiledFace(side, xMin, zMin, xMax, zMax, positive ? yMax : yMin, builder, ms, light, color, fluidTexture);
        }
        ms.m_85849_();
    }

    public static void renderStillTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture) {
        BasicFluidRenderer.renderTiledFace(dir, left, down, right, up, depth, builder, ms, light, color, texture, 1.0f);
    }

    public static void renderTiledFace(Direction dir, float left, float down, float right, float up, float depth, VertexConsumer builder, PoseStack ms, int light, int color, TextureAtlasSprite texture, float textureScale) {
        boolean positive = dir.m_122421_() == Direction.AxisDirection.POSITIVE;
        boolean horizontal = dir.m_122434_().m_122479_();
        boolean x = dir.m_122434_() == Direction.Axis.X;
        float shrink = texture.m_118417_() * 0.25f * textureScale;
        float centerU = texture.m_118409_() + (texture.m_118410_() - texture.m_118409_()) * 0.5f * textureScale;
        float centerV = texture.m_118411_() + (texture.m_118412_() - texture.m_118411_()) * 0.5f * textureScale;
        float x2 = 0.0f;
        float y2 = 0.0f;
        float x1 = left;
        while (x1 < right) {
            float u2;
            float u1;
            float f = Mth.m_14143_((float)x1);
            x2 = Math.min(f + 1.0f, right);
            if (dir == Direction.NORTH || dir == Direction.EAST) {
                f = Mth.m_14167_((float)x2);
                u1 = texture.m_118367_((double)((f - x2) * 16.0f * textureScale));
                u2 = texture.m_118367_((double)((f - x1) * 16.0f * textureScale));
            } else {
                u1 = texture.m_118367_((double)((x1 - f) * 16.0f * textureScale));
                u2 = texture.m_118367_((double)((x2 - f) * 16.0f * textureScale));
            }
            u1 = Mth.m_14179_((float)shrink, (float)u1, (float)centerU);
            u2 = Mth.m_14179_((float)shrink, (float)u2, (float)centerU);
            float y1 = down;
            while (y1 < up) {
                float v2;
                float v1;
                f = Mth.m_14143_((float)y1);
                y2 = Math.min(f + 1.0f, up);
                if (dir == Direction.UP) {
                    v1 = texture.m_118393_((double)((y1 - f) * 16.0f * textureScale));
                    v2 = texture.m_118393_((double)((y2 - f) * 16.0f * textureScale));
                } else {
                    f = Mth.m_14167_((float)y2);
                    v1 = texture.m_118393_((double)((f - y2) * 16.0f * textureScale));
                    v2 = texture.m_118393_((double)((f - y1) * 16.0f * textureScale));
                }
                v1 = Mth.m_14179_((float)shrink, (float)v1, (float)centerV);
                v2 = Mth.m_14179_((float)shrink, (float)v2, (float)centerV);
                if (horizontal) {
                    if (x) {
                        BasicFluidRenderer.putVertex(builder, ms, depth, y2, positive ? x2 : x1, color, u1, v1, dir, light);
                        BasicFluidRenderer.putVertex(builder, ms, depth, y1, positive ? x2 : x1, color, u1, v2, dir, light);
                        BasicFluidRenderer.putVertex(builder, ms, depth, y1, positive ? x1 : x2, color, u2, v2, dir, light);
                        BasicFluidRenderer.putVertex(builder, ms, depth, y2, positive ? x1 : x2, color, u2, v1, dir, light);
                    } else {
                        BasicFluidRenderer.putVertex(builder, ms, positive ? x1 : x2, y2, depth, color, u1, v1, dir, light);
                        BasicFluidRenderer.putVertex(builder, ms, positive ? x1 : x2, y1, depth, color, u1, v2, dir, light);
                        BasicFluidRenderer.putVertex(builder, ms, positive ? x2 : x1, y1, depth, color, u2, v2, dir, light);
                        BasicFluidRenderer.putVertex(builder, ms, positive ? x2 : x1, y2, depth, color, u2, v1, dir, light);
                    }
                } else {
                    BasicFluidRenderer.putVertex(builder, ms, x1, depth, positive ? y1 : y2, color, u1, v1, dir, light);
                    BasicFluidRenderer.putVertex(builder, ms, x1, depth, positive ? y2 : y1, color, u1, v2, dir, light);
                    BasicFluidRenderer.putVertex(builder, ms, x2, depth, positive ? y2 : y1, color, u2, v2, dir, light);
                    BasicFluidRenderer.putVertex(builder, ms, x2, depth, positive ? y1 : y2, color, u2, v1, dir, light);
                }
                y1 = y2;
            }
            x1 = x2;
        }
    }

    protected static void putVertex(VertexConsumer builder, PoseStack ms, float x, float y, float z, int color, float u, float v, Direction face, int light) {
        Vec3i normal = face.m_122436_();
        PoseStack.Pose peek = ms.m_85850_();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        builder.m_252986_(peek.m_252922_(), x, y, z).m_6122_(r, g, b, a).m_7421_(u, v).m_85969_(light).m_252939_(peek.m_252943_(), (float)normal.m_123341_(), (float)normal.m_123342_(), (float)normal.m_123343_()).m_5752_();
    }
}

