/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.createmod.catnip.platform.CatnipClientServices;
import net.createmod.catnip.render.MutableTemplateMesh;
import net.createmod.catnip.render.ShadeSeparatingSuperByteBuffer;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.ponder.mixin.client.accessor.BufferBuilderAccessor;
import net.minecraft.client.renderer.block.model.BakedQuad;

public class ShadedBlockSbbBuilder
implements VertexConsumer {
    protected final BufferBuilder bufferBuilder;
    protected final IntList shadeSwapVertices = new IntArrayList();
    protected boolean currentShade;

    public static ShadedBlockSbbBuilder create() {
        return CatnipClientServices.CLIENT_HOOKS.createSbbBuilder(new BufferBuilder(512));
    }

    public static ShadedBlockSbbBuilder create(BufferBuilder builder) {
        return CatnipClientServices.CLIENT_HOOKS.createSbbBuilder(builder);
    }

    public ShadedBlockSbbBuilder(BufferBuilder bufferBuilder) {
        this.bufferBuilder = bufferBuilder;
    }

    public void begin() {
        this.bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        this.shadeSwapVertices.clear();
        this.currentShade = true;
    }

    public SuperByteBuffer end() {
        BufferBuilder.RenderedBuffer data = this.bufferBuilder.m_231175_();
        MutableTemplateMesh mesh = new MutableTemplateMesh(data);
        return new ShadeSeparatingSuperByteBuffer(mesh.toImmutable(), this.shadeSwapVertices.toIntArray());
    }

    public BufferBuilder unwrap(boolean shade) {
        this.prepareForGeometry(shade);
        return this.bufferBuilder;
    }

    private void prepareForGeometry(boolean shade) {
        if (shade != this.currentShade) {
            this.shadeSwapVertices.add(((BufferBuilderAccessor)this.bufferBuilder).catnip$getVertices());
            this.currentShade = shade;
        }
    }

    protected void prepareForGeometry(BakedQuad quad) {
        this.prepareForGeometry(quad.m_111307_());
    }

    public void m_85987_(PoseStack.Pose pose, BakedQuad quad, float red, float green, float blue, int light, int overlay) {
        this.prepareForGeometry(quad);
        this.bufferBuilder.m_85987_(pose, quad, red, green, blue, light, overlay);
    }

    public void m_85995_(PoseStack.Pose pose, BakedQuad quad, float[] brightnesses, float red, float green, float blue, int[] lights, int overlay, boolean readExistingColor) {
        this.prepareForGeometry(quad);
        this.bufferBuilder.m_85995_(pose, quad, brightnesses, red, green, blue, lights, overlay, readExistingColor);
    }

    public VertexConsumer m_5483_(double x, double y, double z) {
        throw new UnsupportedOperationException("ShadedBlockSbbBuilder only supports putBulkData!");
    }

    public VertexConsumer m_6122_(int red, int green, int blue, int alpha) {
        throw new UnsupportedOperationException("ShadedBlockSbbBuilder only supports putBulkData!");
    }

    public VertexConsumer m_7421_(float u, float v) {
        throw new UnsupportedOperationException("ShadedBlockSbbBuilder only supports putBulkData!");
    }

    public VertexConsumer m_7122_(int u, int v) {
        throw new UnsupportedOperationException("ShadedBlockSbbBuilder only supports putBulkData!");
    }

    public VertexConsumer m_7120_(int u, int v) {
        throw new UnsupportedOperationException("ShadedBlockSbbBuilder only supports putBulkData!");
    }

    public VertexConsumer m_5601_(float x, float y, float z) {
        throw new UnsupportedOperationException("ShadedBlockSbbBuilder only supports putBulkData!");
    }

    public void m_5752_() {
        throw new UnsupportedOperationException("ShadedBlockSbbBuilder only supports putBulkData!");
    }

    public void m_7404_(int red, int green, int blue, int alpha) {
        throw new UnsupportedOperationException("ShadedBlockSbbBuilder only supports putBulkData!");
    }

    public void m_141991_() {
        throw new UnsupportedOperationException("ShadedBlockSbbBuilder only supports putBulkData!");
    }
}

