/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.gui.NavigatableSimiScreen;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.platform.CatnipClientServices;
import net.createmod.catnip.platform.CatnipServices;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.Ponder;
import net.createmod.ponder.enums.PonderKeybinds;
import net.createmod.ponder.foundation.PonderIndex;
import net.createmod.ponder.foundation.ui.PonderUI;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class PonderTooltipHandler {
    private static final Color borderA = new Color(0x5000FF, false).setImmutable();
    private static final Color borderB = new Color(0x5555FF, false).setImmutable();
    private static final Color borderC = new Color(0xFFFFFF, false).setImmutable();
    public static boolean enable = true;
    static LerpedFloat holdKeyProgress = LerpedFloat.linear().startWithValue(0.0);
    static ItemStack hoveredStack = ItemStack.f_41583_;
    static ItemStack trackingStack = ItemStack.f_41583_;
    static boolean subject = false;
    static boolean deferTick = false;
    public static final String HOLD_TO_PONDER = "ui.hold_to_ponder";
    public static final String SUBJECT = "ui.subject";

    public static void tick() {
        deferTick = true;
    }

    public static void deferredTick() {
        deferTick = false;
        Minecraft instance = Minecraft.m_91087_();
        Screen currentScreen = instance.f_91080_;
        if (hoveredStack.m_41619_() || trackingStack.m_41619_()) {
            trackingStack = ItemStack.f_41583_;
            holdKeyProgress.startWithValue(0.0);
            return;
        }
        float value = holdKeyProgress.getValue();
        if (!subject && CatnipClientServices.CLIENT_HOOKS.isKeyPressed(PonderTooltipHandler.ponderKeybind()) && currentScreen != null) {
            if (value >= 1.0f) {
                if (currentScreen instanceof NavigatableSimiScreen) {
                    ((NavigatableSimiScreen)currentScreen).centerScalingOnMouse();
                }
                ScreenOpener.transitionTo(PonderUI.of(trackingStack));
                holdKeyProgress.startWithValue(0.0);
                return;
            }
            holdKeyProgress.setValue(Math.min(1.0f, value + Math.max(0.25f, value) * 0.25f));
        } else {
            holdKeyProgress.setValue(Math.max(0.0f, value - 0.05f));
        }
        hoveredStack = ItemStack.f_41583_;
    }

    public static void addToTooltip(List<Component> toolTip, ItemStack stack) {
        MutableComponent component;
        if (!enable) {
            return;
        }
        if (NavigatableSimiScreen.isCurrentlyRenderingPreviousScreen()) {
            return;
        }
        PonderTooltipHandler.updateHovered(stack);
        if (deferTick) {
            PonderTooltipHandler.deferredTick();
        }
        if (trackingStack != stack) {
            return;
        }
        float renderPartialTicks = Minecraft.m_91087_().m_91296_();
        Object object = component = subject ? Ponder.lang().translate(SUBJECT, new Object[0]).component().m_130940_(ChatFormatting.GREEN) : PonderTooltipHandler.makeProgressBar(Math.min(1.0f, holdKeyProgress.getValue(renderPartialTicks) * 8.0f / 7.0f));
        if (toolTip.size() < 2) {
            toolTip.add((Component)component);
        } else {
            toolTip.add(1, (Component)component);
        }
    }

    protected static void updateHovered(ItemStack stack) {
        PonderUI ponderUI;
        ItemStack uiSubject;
        Minecraft instance = Minecraft.m_91087_();
        Screen currentScreen = instance.f_91080_;
        boolean inPonderUI = currentScreen instanceof PonderUI;
        ItemStack prevStack = trackingStack;
        hoveredStack = ItemStack.f_41583_;
        subject = false;
        if (inPonderUI && !(uiSubject = (ponderUI = (PonderUI)currentScreen).getSubject()).m_41619_() && stack.m_150930_(uiSubject.m_41720_())) {
            subject = true;
        }
        if (stack.m_41619_()) {
            return;
        }
        if (!PonderIndex.getSceneAccess().doScenesExistForId(CatnipServices.REGISTRIES.getKeyOrThrow(stack.m_41720_()))) {
            return;
        }
        if (prevStack.m_41619_() || !prevStack.m_150930_(stack.m_41720_())) {
            holdKeyProgress.startWithValue(0.0);
        }
        hoveredStack = stack;
        trackingStack = stack;
    }

    public static Optional<Couple<Color>> handleTooltipColor(ItemStack stack) {
        if (trackingStack != stack) {
            return Optional.empty();
        }
        if (holdKeyProgress.getValue() == 0.0f) {
            return Optional.empty();
        }
        float renderPartialTicks = Minecraft.m_91087_().m_91296_();
        float progress = Math.min(1.0f, holdKeyProgress.getValue(renderPartialTicks) * 8.0f / 7.0f);
        Color startC = PonderTooltipHandler.getSmoothColorForProgress(progress);
        Color endC = PonderTooltipHandler.getSmoothColorForProgress(progress);
        return Optional.of(Couple.create(startC, endC));
    }

    private static Color getSmoothColorForProgress(float progress) {
        if ((double)progress < 0.5) {
            return borderA.mixWith(borderB, progress * 2.0f);
        }
        return borderB.mixWith(borderC, (progress - 0.5f) * 2.0f);
    }

    private static Component makeProgressBar(float progress) {
        MutableComponent holdW = Ponder.lang().translate(HOLD_TO_PONDER, ((MutableComponent)PonderTooltipHandler.ponderKeybind().m_90863_()).m_130940_(ChatFormatting.GRAY)).style(ChatFormatting.DARK_GRAY).component();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        float charWidth = fontRenderer.m_92895_("|");
        float tipWidth = fontRenderer.m_92852_((FormattedText)holdW);
        int total = (int)(tipWidth / charWidth);
        int current = (int)(progress * (float)total);
        if (progress > 0.0f) {
            Object bars = "";
            bars = (String)bars + ChatFormatting.GRAY + Strings.repeat((String)"|", (int)current);
            if (progress < 1.0f) {
                bars = (String)bars + ChatFormatting.DARK_GRAY + Strings.repeat((String)"|", (int)(total - current));
            }
            return Component.m_237113_((String)bars);
        }
        return holdW;
    }

    protected static KeyMapping ponderKeybind() {
        return PonderKeybinds.PONDER.getKeybind();
    }
}

