/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.ponder.foundation.element;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.ponder.api.element.ParrotElement;
import net.createmod.ponder.api.element.ParrotPose;
import net.createmod.ponder.api.level.PonderLevel;
import net.createmod.ponder.foundation.PonderScene;
import net.createmod.ponder.foundation.element.AnimatedSceneElementBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.phys.Vec3;

public class ParrotElementImpl
extends AnimatedSceneElementBase
implements ParrotElement {
    protected Vec3 location;
    @Nullable
    protected Parrot entity;
    protected ParrotPose pose;
    protected Supplier<? extends ParrotPose> initialPose;

    public static ParrotElement create(Vec3 location, Supplier<? extends ParrotPose> pose) {
        return new ParrotElementImpl(location, pose);
    }

    protected ParrotElementImpl(Vec3 location, Supplier<? extends ParrotPose> pose) {
        this.location = location;
        this.initialPose = pose;
        this.pose = this.initialPose.get();
    }

    @Override
    public void reset(PonderScene scene) {
        super.reset(scene);
        this.setPose(this.initialPose.get());
        this.entity.m_20343_(0.0, 0.0, 0.0);
        this.entity.f_19854_ = 0.0;
        this.entity.f_19855_ = 0.0;
        this.entity.f_19856_ = 0.0;
        this.entity.f_19790_ = 0.0;
        this.entity.f_19791_ = 0.0;
        this.entity.f_19792_ = 0.0;
        this.entity.f_19860_ = 0.0f;
        this.entity.m_146926_(0.0f);
        this.entity.f_19859_ = 180.0f;
        this.entity.m_146922_(180.0f);
    }

    @Override
    public void tick(PonderScene scene) {
        super.tick(scene);
        if (this.entity == null) {
            this.entity = this.pose.create(scene.getWorld());
            this.entity.f_19859_ = 180.0f;
            this.entity.m_146922_(180.0f);
        }
        ++this.entity.f_19797_;
        this.entity.f_20886_ = this.entity.f_20885_;
        this.entity.f_29352_ = this.entity.f_29351_;
        this.entity.f_29353_ = this.entity.f_29350_;
        this.entity.m_6853_(true);
        this.entity.f_19854_ = this.entity.m_20185_();
        this.entity.f_19855_ = this.entity.m_20186_();
        this.entity.f_19856_ = this.entity.m_20189_();
        this.entity.f_19859_ = this.entity.m_146908_();
        this.entity.f_19860_ = this.entity.m_146909_();
        this.pose.tick(scene, this.entity, this.location);
        this.entity.f_19790_ = this.entity.m_20185_();
        this.entity.f_19791_ = this.entity.m_20186_();
        this.entity.f_19792_ = this.entity.m_20189_();
    }

    @Override
    public void setPositionOffset(Vec3 position, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        if (!immediate) {
            return;
        }
        this.entity.f_19854_ = position.f_82479_;
        this.entity.f_19855_ = position.f_82480_;
        this.entity.f_19856_ = position.f_82481_;
    }

    @Override
    public void setRotation(Vec3 eulers, boolean immediate) {
        if (this.entity == null) {
            return;
        }
        this.entity.m_146926_((float)eulers.f_82479_);
        this.entity.m_146922_((float)eulers.f_82480_);
        if (!immediate) {
            return;
        }
        this.entity.f_19860_ = this.entity.m_146909_();
        this.entity.f_19859_ = this.entity.m_146908_();
    }

    @Override
    public Vec3 getPositionOffset() {
        return this.entity != null ? this.entity.m_20182_() : Vec3.f_82478_;
    }

    @Override
    public Vec3 getRotation() {
        return this.entity != null ? new Vec3((double)this.entity.m_146909_(), (double)this.entity.m_146908_(), 0.0) : Vec3.f_82478_;
    }

    @Override
    protected void renderLast(PonderLevel world, MultiBufferSource buffer, GuiGraphics graphics, float fade, float pt) {
        PoseStack poseStack = graphics.m_280168_();
        EntityRenderDispatcher entityrenderermanager = Minecraft.m_91087_().m_91290_();
        if (this.entity == null) {
            this.entity = this.pose.create(world);
            this.entity.f_19859_ = 180.0f;
            this.entity.m_146922_(180.0f);
        }
        poseStack.m_85836_();
        poseStack.m_85837_(this.location.f_82479_, this.location.f_82480_, this.location.f_82481_);
        poseStack.m_85837_(Mth.m_14139_((double)pt, (double)this.entity.f_19854_, (double)this.entity.m_20185_()), Mth.m_14139_((double)pt, (double)this.entity.f_19855_, (double)this.entity.m_20186_()), Mth.m_14139_((double)pt, (double)this.entity.f_19856_, (double)this.entity.m_20189_()));
        float angle = AngleHelper.angleLerp(pt, this.entity.f_19859_, this.entity.m_146908_());
        poseStack.m_252781_(Axis.f_252436_.m_252977_(angle));
        entityrenderermanager.m_114384_((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, pt, poseStack, buffer, this.lightCoordsFromFade(fade));
        poseStack.m_85849_();
    }

    @Override
    public void setPose(ParrotPose pose) {
        this.pose = pose;
    }
}

