/*
 * Decompiled with CFR 0.152.
 */
package com.github.exopandora.shouldersurfing.forge.compat;

import com.github.exopandora.shouldersurfing.compat.Mods;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class ShoulderSurfingCompatMixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        return true;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        ArrayList<String> mixins = new ArrayList<String>();
        ShoulderSurfingCompatMixinPlugin.addCreateModMixins(mixins);
        ShoulderSurfingCompatMixinPlugin.addOculusMixins(mixins);
        return mixins.isEmpty() ? null : mixins;
    }

    private static void addOculusMixins(List<String> mixins) {
        String oculusModVersion = Mods.OCULUS.getModVersion();
        if (oculusModVersion != null) {
            DefaultArtifactVersion version = new DefaultArtifactVersion(oculusModVersion);
            if (ShoulderSurfingCompatMixinPlugin.parseVersionRangeSilent("[1.7.0-snapshot,)").containsVersion((ArtifactVersion)version)) {
                mixins.add("iris.MixinSheets_1_7_0");
            } else if (ShoulderSurfingCompatMixinPlugin.parseVersionRangeSilent("[1.6.15,1.7.0)").containsVersion((ArtifactVersion)version)) {
                mixins.add("iris.MixinSheets_1_6_15");
            }
        }
    }

    private static void addCreateModMixins(List<String> mixins) {
        String createModVersion = Mods.CREATE.getModVersion();
        if (createModVersion != null) {
            DefaultArtifactVersion version = new DefaultArtifactVersion(createModVersion);
            if (ShoulderSurfingCompatMixinPlugin.parseVersionRangeSilent("[6.0.0,)").containsVersion((ArtifactVersion)version)) {
                mixins.add("create.MixinContraptionHandlerClient_6_0_0");
            } else if (ShoulderSurfingCompatMixinPlugin.parseVersionRangeSilent("(,6.0.0)").containsVersion((ArtifactVersion)version)) {
                mixins.add("create.MixinContraptionHandlerClient_0_5_0");
            }
        }
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    private static VersionRange parseVersionRangeSilent(String predicate) {
        try {
            return VersionRange.createFromVersionSpec((String)predicate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

