/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import mods.flammpfeil.slashblade.capability.mobeffect.CapabilityMobEffect;
import mods.flammpfeil.slashblade.entity.ai.StunGoal;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StunManager {
    static final int DEFAULT_STUN_TICKS = 10;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityJoinWorldEvent(EntityJoinLevelEvent event) {
        if (!(event.getEntity() instanceof PathfinderMob)) {
            return;
        }
        PathfinderMob entity = (PathfinderMob)event.getEntity();
        entity.f_21345_.m_25352_(-1, (Goal)new StunGoal(entity));
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(LivingEvent.LivingTickEvent event) {
        LivingEntity target = event.getEntity();
        if (!(target instanceof PathfinderMob)) {
            return;
        }
        if (target.m_9236_() == null) {
            return;
        }
        boolean onStun = target.getCapability(CapabilityMobEffect.MOB_EFFECT).filter(state -> state.isStun(target.m_9236_().m_46467_())).isPresent();
        if (onStun) {
            Vec3 motion = target.m_20184_();
            if (5.0f < target.f_19789_) {
                target.m_20334_(motion.f_82479_, motion.f_82480_ - 2.0, motion.f_82481_);
            } else if (motion.f_82480_ < 0.0) {
                target.m_20334_(motion.f_82479_, motion.f_82480_ * 0.25, motion.f_82481_);
            }
        }
    }

    public static void setStun(LivingEntity target, LivingEntity attacker) {
        StunManager.setStun(target);
    }

    public static void setStun(LivingEntity target) {
        StunManager.setStun(target, 10L);
    }

    public static void setStun(LivingEntity target, long duration) {
        if (!(target instanceof PathfinderMob)) {
            return;
        }
        if (target.m_9236_() == null) {
            return;
        }
        target.getCapability(CapabilityMobEffect.MOB_EFFECT).ifPresent(state -> state.setManagedStun(target.m_9236_().m_46467_(), duration));
    }

    public static void removeStun(LivingEntity target) {
        if (target.m_9236_() == null) {
            return;
        }
        if (!(target instanceof LivingEntity)) {
            return;
        }
        target.getCapability(CapabilityMobEffect.MOB_EFFECT).ifPresent(state -> state.clearStunTimeOut());
    }
}

