/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.ability;

import java.util.EnumSet;
import java.util.Map;
import mods.flammpfeil.slashblade.capability.inputstate.CapabilityInputState;
import mods.flammpfeil.slashblade.event.InputCommandEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.item.SwordType;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import mods.flammpfeil.slashblade.registry.combo.ComboState;
import mods.flammpfeil.slashblade.slasharts.SlashArts;
import mods.flammpfeil.slashblade.util.InputCommand;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.timers.TimerCallback;
import net.minecraft.world.level.timers.TimerQueue;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SuperSlashArts {
    public static SuperSlashArts getInstance() {
        return SingletonHolder.instance;
    }

    private SuperSlashArts() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onInputChange(final InputCommandEvent event) {
        EnumSet<InputCommand> old = event.getOld();
        EnumSet<InputCommand> current = event.getCurrent();
        final ServerPlayer sender = event.getEntity();
        InputCommand targetCommnad = InputCommand.SPRINT;
        boolean onDown = !old.contains((Object)targetCommnad) && current.contains((Object)targetCommnad);
        final RandomSource random = sender.m_217043_();
        final Long pressTime = event.getState().getLastPressTime(targetCommnad);
        if (onDown) {
            sender.getCapability(CapabilityInputState.INPUT_STATE).ifPresent(input -> {
                input.getScheduler().schedule("sendPartical", pressTime + 5L, new TimerCallback<LivingEntity>(){

                    public void handle(LivingEntity rawEntity, TimerQueue<LivingEntity> queue, long now) {
                        if (!(rawEntity instanceof ServerPlayer)) {
                            return;
                        }
                        ServerPlayer entity = (ServerPlayer)rawEntity;
                        InputCommand targetCommnad = InputCommand.SPRINT;
                        boolean inputSucceed = entity.getCapability(CapabilityInputState.INPUT_STATE).filter(input -> input.getCommands().contains((Object)targetCommnad) && (!InputCommand.anyMatch(input.getCommands(), InputCommand.move) || !input.getCommands().contains((Object)InputCommand.SNEAK)) && input.getLastPressTime(targetCommnad) == pressTime.longValue()).isPresent();
                        if (!inputSucceed) {
                            return;
                        }
                        ItemStack mainHandItem = entity.m_21205_();
                        mainHandItem.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                            if (state.isBroken() || state.getDamage() > 0 || state.isSealed() || !SwordType.from(mainHandItem).contains((Object)SwordType.BEWITCHED) || !SwordType.from(mainHandItem).contains((Object)SwordType.FIERCEREDGE)) {
                                return;
                            }
                            if (!entity.m_20096_()) {
                                return;
                            }
                            for (int i = 0; i < 32; ++i) {
                                double zDist;
                                double yDist;
                                double xDist = random.m_188501_() * 2.0f - 1.0f;
                                if (xDist * xDist + (yDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * yDist + (zDist = (double)(random.m_188501_() * 2.0f - 1.0f)) * zDist > 1.0) continue;
                                double x = sender.m_20165_(xDist / 4.0);
                                double y = sender.m_20227_(0.5 + yDist / 4.0);
                                double z = sender.m_20246_(zDist / 4.0);
                                ((ServerLevel)event.getEntity().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123789_, x, y, z, 0, xDist, yDist + 0.2, zDist, 1.0);
                            }
                        });
                    }
                });
                input.getScheduler().schedule("chargeSuperSA", pressTime + 20L, new TimerCallback<LivingEntity>(){

                    public void handle(LivingEntity rawEntity, TimerQueue<LivingEntity> queue, long now) {
                        if (!(rawEntity instanceof ServerPlayer)) {
                            return;
                        }
                        ServerPlayer entity = (ServerPlayer)rawEntity;
                        InputCommand targetCommnad = InputCommand.SPRINT;
                        boolean inputSucceed = entity.getCapability(CapabilityInputState.INPUT_STATE).filter(input -> input.getCommands().contains((Object)targetCommnad) && (!InputCommand.anyMatch(input.getCommands(), InputCommand.move) || !input.getCommands().contains((Object)InputCommand.SNEAK)) && input.getLastPressTime(targetCommnad) == pressTime.longValue()).isPresent();
                        if (!inputSucceed) {
                            return;
                        }
                        SuperSlashArts.releaseSSA(entity);
                    }
                });
            });
        }
    }

    public static void releaseSSA(ServerPlayer entity) {
        ItemStack mainHandItem = entity.m_21205_();
        mainHandItem.getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
            if (state.isBroken() || state.getDamage() > 0 || state.isSealed() || !SwordType.from(mainHandItem).contains((Object)SwordType.BEWITCHED) || !SwordType.from(mainHandItem).contains((Object)SwordType.FIERCEREDGE)) {
                return;
            }
            if (!entity.m_20096_()) {
                return;
            }
            mainHandItem.m_41622_(mainHandItem.m_41776_() / 2, (LivingEntity)entity, ItemSlashBlade.getOnBroken(mainHandItem));
            Map.Entry<Integer, ResourceLocation> currentloc = state.resolvCurrentComboStateTicks((LivingEntity)entity);
            ComboState currentCS = (ComboState)ComboStateRegistry.REGISTRY.get().getValue(currentloc.getValue());
            ResourceLocation csloc = state.getSlashArts().doArts(SlashArts.ArtsType.Super, (LivingEntity)entity);
            ComboState cs = (ComboState)ComboStateRegistry.REGISTRY.get().getValue(csloc);
            if (csloc != ComboStateRegistry.NONE.getId() && !currentloc.getValue().equals((Object)csloc) && currentCS.getPriority() > cs.getPriority()) {
                state.updateComboSeq((LivingEntity)entity, csloc);
            }
        });
    }

    private static final class SingletonHolder {
        private static final SuperSlashArts instance = new SuperSlashArts();

        private SingletonHolder() {
        }
    }
}

