/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.compat.playerAnim;

import com.google.common.collect.Maps;
import dev.kosmx.playerAnim.api.layered.AnimationStack;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import java.util.HashMap;
import java.util.Map;
import mods.flammpfeil.slashblade.compat.playerAnim.VmdAnimation;
import mods.flammpfeil.slashblade.event.BladeMotionEvent;
import mods.flammpfeil.slashblade.init.DefaultResources;
import mods.flammpfeil.slashblade.registry.ComboStateRegistry;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class PlayerAnimationOverrider {
    private Map<ResourceLocation, VmdAnimation> animation = this.initAnimations();
    private static final ResourceLocation MotionLocation = new ResourceLocation("slashblade", "model/pa/player_motion.vmd");

    public static PlayerAnimationOverrider getInstance() {
        return SingletonHolder.instance;
    }

    private PlayerAnimationOverrider() {
    }

    public void register() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public Map<ResourceLocation, VmdAnimation> getAnimation() {
        return this.animation;
    }

    @SubscribeEvent
    public void onBladeAnimationStart(BladeMotionEvent event) {
        if (!(event.getEntity() instanceof AbstractClientPlayer)) {
            return;
        }
        AbstractClientPlayer player = (AbstractClientPlayer)event.getEntity();
        AnimationStack animationStack = PlayerAnimationAccess.getPlayerAnimLayer((AbstractClientPlayer)player);
        VmdAnimation animation = this.getAnimation().get(event.getCombo());
        if (animation != null) {
            animationStack.removeLayer(0);
            animation.play();
            animationStack.addAnimLayer(0, (IAnimation)animation.getClone());
        }
    }

    private Map<ResourceLocation, VmdAnimation> initAnimations() {
        HashMap map = Maps.newHashMap();
        map.put(ComboStateRegistry.PIERCING.getId(), new VmdAnimation(DefaultResources.testPLLocation, 1.0, 90.0, false));
        map.put(ComboStateRegistry.PIERCING_JUST.getId(), new VmdAnimation(DefaultResources.testPLLocation, 34.0, 90.0, false));
        map.put(ComboStateRegistry.COMBO_A1_END2.getId(), new VmdAnimation(MotionLocation, 21.0, 41.0, false));
        map.put(ComboStateRegistry.COMBO_A1.getId(), new VmdAnimation(MotionLocation, 1.0, 41.0, false));
        map.put(ComboStateRegistry.COMBO_A2.getId(), new VmdAnimation(MotionLocation, 100.0, 151.0, false));
        map.put(ComboStateRegistry.COMBO_C.getId(), new VmdAnimation(MotionLocation, 400.0, 488.0, false));
        map.put(ComboStateRegistry.COMBO_A3.getId(), new VmdAnimation(MotionLocation, 200.0, 306.0, false));
        map.put(ComboStateRegistry.COMBO_A4.getId(), new VmdAnimation(MotionLocation, 500.0, 608.0, false));
        map.put(ComboStateRegistry.COMBO_A4_EX.getId(), new VmdAnimation(MotionLocation, 800.0, 894.0, false));
        map.put(ComboStateRegistry.COMBO_A5.getId(), new VmdAnimation(MotionLocation, 900.0, 1061.0, false));
        map.put(ComboStateRegistry.COMBO_B1.getId(), new VmdAnimation(MotionLocation, 700.0, 787.0, false));
        map.put(ComboStateRegistry.COMBO_B2.getId(), new VmdAnimation(MotionLocation, 710.0, 787.0, false));
        map.put(ComboStateRegistry.COMBO_B3.getId(), new VmdAnimation(MotionLocation, 710.0, 787.0, false));
        map.put(ComboStateRegistry.COMBO_B4.getId(), new VmdAnimation(MotionLocation, 710.0, 787.0, false));
        map.put(ComboStateRegistry.COMBO_B5.getId(), new VmdAnimation(MotionLocation, 710.0, 787.0, false));
        map.put(ComboStateRegistry.COMBO_B6.getId(), new VmdAnimation(MotionLocation, 710.0, 787.0, false));
        map.put(ComboStateRegistry.COMBO_B7.getId(), new VmdAnimation(MotionLocation, 710.0, 787.0, false));
        map.put(ComboStateRegistry.CIRCLE_SLASH.getId(), new VmdAnimation(MotionLocation, 725.0, 787.0, false));
        map.put(ComboStateRegistry.AERIAL_RAVE_A1.getId(), new VmdAnimation(MotionLocation, 1100.0, 1132.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.AERIAL_RAVE_A2.getId(), new VmdAnimation(MotionLocation, 1200.0, 1241.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.AERIAL_RAVE_A3.getId(), new VmdAnimation(MotionLocation, 1300.0, 1338.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.AERIAL_RAVE_B3.getId(), new VmdAnimation(MotionLocation, 1400.0, 1443.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.AERIAL_RAVE_B4.getId(), new VmdAnimation(MotionLocation, 1500.0, 1547.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.UPPERSLASH.getId(), new VmdAnimation(MotionLocation, 1600.0, 1693.0, false));
        map.put(ComboStateRegistry.UPPERSLASH_JUMP.getId(), new VmdAnimation(MotionLocation, 1700.0, 1717.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.AERIAL_CLEAVE.getId(), new VmdAnimation(MotionLocation, 1800.0, 1817.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.AERIAL_CLEAVE_LOOP.getId(), new VmdAnimation(MotionLocation, 1812.0, 1817.0, true).setBlendLegs(false));
        map.put(ComboStateRegistry.AERIAL_CLEAVE_LANDING.getId(), new VmdAnimation(MotionLocation, 1816.0, 1886.0, false));
        map.put(ComboStateRegistry.RAPID_SLASH.getId(), new VmdAnimation(MotionLocation, 2000.0, 2073.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.RAPID_SLASH_QUICK.getId(), new VmdAnimation(MotionLocation, 2000.0, 2073.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.RISING_STAR.getId(), new VmdAnimation(MotionLocation, 2100.0, 2147.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.JUDGEMENT_CUT.getId(), new VmdAnimation(MotionLocation, 1900.0, 1963.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.JUDGEMENT_CUT_SLASH_AIR.getId(), new VmdAnimation(MotionLocation, 1923.0, 1963.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.JUDGEMENT_CUT_SLASH_JUST.getId(), new VmdAnimation(MotionLocation, 1923.0, 1963.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.VOID_SLASH.getId(), new VmdAnimation(MotionLocation, 2200.0, 2299.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.SAKURA_END_LEFT.getId(), new VmdAnimation(MotionLocation, 1816.0, 1859.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.SAKURA_END_RIGHT.getId(), new VmdAnimation(MotionLocation, 204.0, 314.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.SAKURA_END_LEFT_AIR.getId(), new VmdAnimation(MotionLocation, 1300.0, 1328.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.SAKURA_END_RIGHT_AIR.getId(), new VmdAnimation(MotionLocation, 1200.0, 1241.0, false).setBlendLegs(false));
        map.put(ComboStateRegistry.DRIVE_HORIZONTAL.getId(), new VmdAnimation(MotionLocation, 400.0, 488.0, false));
        map.put(ComboStateRegistry.DRIVE_VERTICAL.getId(), new VmdAnimation(MotionLocation, 1600.0, 1693.0, false));
        map.put(ComboStateRegistry.WAVE_EDGE_VERTICAL.getId(), new VmdAnimation(MotionLocation, 1600.0, 1693.0, false));
        map.put(ComboStateRegistry.JUDGEMENT_CUT_END.getId(), new VmdAnimation(MotionLocation, 1923.0, 1963.0, false));
        return map;
    }

    private static final class SingletonHolder {
        private static final PlayerAnimationOverrider instance = new PlayerAnimationOverrider();

        private SingletonHolder() {
        }
    }
}

