/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.ability.ArrowReflector;
import mods.flammpfeil.slashblade.ability.TNTExtinguisher;
import mods.flammpfeil.slashblade.capability.concentrationrank.ConcentrationRankCapabilityProvider;
import mods.flammpfeil.slashblade.capability.concentrationrank.IConcentrationRank;
import mods.flammpfeil.slashblade.capability.slashblade.ISlashBladeState;
import mods.flammpfeil.slashblade.entity.EntityAbstractSummonedSword;
import mods.flammpfeil.slashblade.entity.EntitySlashEffect;
import mods.flammpfeil.slashblade.entity.IShootable;
import mods.flammpfeil.slashblade.entity.Projectile;
import mods.flammpfeil.slashblade.event.SlashBladeEvent;
import mods.flammpfeil.slashblade.item.ItemSlashBlade;
import mods.flammpfeil.slashblade.registry.ModAttributes;
import mods.flammpfeil.slashblade.util.KnockBacks;
import mods.flammpfeil.slashblade.util.PlayerAttackHelper;
import mods.flammpfeil.slashblade.util.TargetSelector;
import mods.flammpfeil.slashblade.util.VectorHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class AttackManager {
    public static boolean isPowered(LivingEntity entity) {
        boolean result;
        ItemStack blade = entity.m_21205_();
        boolean bl = result = entity.m_21023_(MobEffects.f_19600_) || entity.m_21023_(MobEffects.f_19612_);
        if (blade.getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            ISlashBladeState state = (ISlashBladeState)blade.getCapability(ItemSlashBlade.BLADESTATE).orElseThrow(NullPointerException::new);
            SlashBladeEvent.PowerBladeEvent event = new SlashBladeEvent.PowerBladeEvent(blade, state, entity, result);
            MinecraftForge.EVENT_BUS.post((Event)event);
            result = event.isPowered();
        }
        return result;
    }

    public static void areaAttack(LivingEntity playerIn, Consumer<LivingEntity> beforeHit) {
        AttackManager.areaAttack(playerIn, beforeHit, 1.0f, true, true, false);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll) {
        return AttackManager.doSlash(playerIn, roll, false);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll, boolean mute) {
        return AttackManager.doSlash(playerIn, roll, mute, false);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll, boolean mute, boolean critical) {
        return AttackManager.doSlash(playerIn, roll, mute, critical, 1.0);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll, boolean mute, boolean critical, double comboRatio) {
        return AttackManager.doSlash(playerIn, roll, Vec3.f_82478_, mute, critical, comboRatio);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll, Vec3 centerOffset, boolean mute, boolean critical, double comboRatio) {
        return AttackManager.doSlash(playerIn, roll, centerOffset, mute, critical, comboRatio, KnockBacks.cancel);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll, Vec3 centerOffset, boolean mute, boolean critical, double comboRatio, KnockBacks knockback) {
        int colorCode = playerIn.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getColorCode()).orElseGet(() -> 0xFFFFFF);
        return AttackManager.doSlash(playerIn, roll, colorCode, centerOffset, mute, critical, comboRatio, knockback);
    }

    public static EntitySlashEffect doSlash(LivingEntity playerIn, float roll, int colorCode, Vec3 centerOffset, boolean mute, boolean critical, double comboRatio, KnockBacks knockback) {
        if (playerIn.m_9236_().m_5776_()) {
            return null;
        }
        ItemStack blade = playerIn.m_21205_();
        if (!blade.getCapability(ItemSlashBlade.BLADESTATE).isPresent()) {
            return null;
        }
        if (MinecraftForge.EVENT_BUS.post((Event)new SlashBladeEvent.DoSlashEvent(blade, (ISlashBladeState)blade.getCapability(ItemSlashBlade.BLADESTATE).orElseThrow(NullPointerException::new), playerIn, roll, critical, comboRatio, knockback))) {
            return null;
        }
        Vec3 pos = playerIn.m_20182_().m_82520_(0.0, (double)playerIn.m_20192_() * 0.75, 0.0).m_82549_(playerIn.m_20154_().m_82490_((double)0.3f));
        pos = pos.m_82549_(VectorHelper.getVectorForRotation(-90.0f, playerIn.m_5675_(0.0f)).m_82490_(centerOffset.f_82480_)).m_82549_(VectorHelper.getVectorForRotation(0.0f, playerIn.m_5675_(0.0f) + 90.0f).m_82490_(centerOffset.f_82481_)).m_82549_(playerIn.m_20154_().m_82490_(centerOffset.f_82481_));
        EntitySlashEffect jc = new EntitySlashEffect((EntityType<? extends Projectile>)SlashBlade.RegistryEvents.SlashEffect, playerIn.m_9236_());
        jc.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        jc.m_5602_((Entity)playerIn);
        jc.setRotationRoll(roll);
        jc.m_146922_(playerIn.m_146908_());
        jc.m_146926_(0.0f);
        jc.setColor(colorCode);
        jc.setMute(mute);
        jc.setIsCritical(critical);
        jc.setDamage(comboRatio);
        jc.setKnockBack(knockback);
        if (playerIn != null) {
            playerIn.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).ifPresent(rank -> jc.setRank(rank.getRankLevel(playerIn.m_9236_().m_46467_())));
        }
        playerIn.m_9236_().m_7967_((Entity)jc);
        return jc;
    }

    public static void doVoidSlashAttack(final LivingEntity living) {
        if (living.m_9236_().m_5776_()) {
            return;
        }
        Vec3 pos = living.m_20182_().m_82520_(0.0, (double)living.m_20192_() * 0.75, 0.0).m_82549_(living.m_20154_().m_82490_((double)0.3f));
        pos = pos.m_82549_(VectorHelper.getVectorForRotation(-90.0f, living.m_5675_(0.0f)).m_82490_(Vec3.f_82478_.f_82480_)).m_82549_(VectorHelper.getVectorForRotation(0.0f, living.m_5675_(0.0f) + 90.0f).m_82490_(Vec3.f_82478_.f_82481_)).m_82549_(living.m_20154_().m_82490_(Vec3.f_82478_.f_82481_));
        EntitySlashEffect jc = new EntitySlashEffect(SlashBlade.RegistryEvents.SlashEffect, living.m_9236_()){

            @Override
            public double getDamage() {
                return 0.0;
            }

            @Override
            public SoundEvent getSlashSound() {
                return SoundEvents.f_11704_;
            }

            @Override
            protected void tryDespawn() {
                if (!this.m_9236_().m_5776_() && this.getLifetime() < this.f_19797_) {
                    this.m_9236_().m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11983_, SoundSource.PLAYERS, 1.0f, 0.625f + 0.1f * this.f_19796_.m_188501_());
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123808_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 16, 0.7, 0.7, 0.7, 0.02);
                    this.getAlreadyHits().forEach(entity -> {
                        if (entity.m_6084_()) {
                            Entity patt9781$temp;
                            float yRot = this.m_19749_() != null ? this.m_19749_().m_146908_() : 0.0f;
                            entity.m_246865_(new Vec3(-Math.sin(yRot * (float)Math.PI / 180.0f) * 0.5, 0.05, Math.cos(yRot * (float)Math.PI / 180.0f) * 0.5));
                            double baseAmount = living.m_21133_(Attributes.f_22281_);
                            int powerLevel = living.m_21205_().getEnchantmentLevel(Enchantments.f_44988_);
                            baseAmount *= (double)(1.0f + (float)powerLevel * 0.1f);
                            if (living instanceof Player) {
                                Player player = (Player)living;
                                IConcentrationRank.ConcentrationRanks rankBonus = player.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).map(rp -> rp.getRank(player.m_20193_().m_46467_())).orElse(IConcentrationRank.ConcentrationRanks.NONE);
                                float rankDamageBonus = (float)rankBonus.level / 2.0f;
                                if (IConcentrationRank.ConcentrationRanks.S.level <= rankBonus.level) {
                                    int refine = player.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(rp -> rp.getRefine()).orElse(0);
                                    int level = player.f_36078_;
                                    rankDamageBonus = (float)Math.max((double)rankDamageBonus, (double)Math.min(level, refine) * (Double)SlashBladeConfig.REFINE_DAMAGE_MULTIPLIER.get());
                                }
                                baseAmount += (double)rankDamageBonus;
                            }
                            if ((patt9781$temp = this.getShooter()) instanceof LivingEntity) {
                                LivingEntity shooter = (LivingEntity)patt9781$temp;
                                baseAmount *= (double)AttackManager.getSlashBladeDamageScale(shooter) * (Double)SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER.get();
                            }
                            AttackManager.doAttackWith(this.m_269291_().m_269104_((Entity)this, this.getShooter()), (float)baseAmount * 5.1f, entity, true, true);
                        }
                    });
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            }
        };
        jc.m_6034_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        jc.m_5602_((Entity)living);
        jc.setRotationRoll(180.0f);
        jc.m_146922_(living.m_146908_() - 22.5f);
        jc.m_146926_(0.0f);
        int colorCode = living.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(state -> state.getColorCode()).orElseGet(() -> 0xFFFFFF);
        jc.setColor(colorCode);
        jc.setMute(false);
        jc.setIsCritical(false);
        jc.setDamage(0.0);
        jc.setKnockBack(KnockBacks.cancel);
        if (living != null) {
            living.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).ifPresent(rank -> jc.setRank(rank.getRankLevel(living.m_9236_().m_46467_())));
        }
        jc.setLifetime(36);
        living.m_9236_().m_7967_((Entity)jc);
    }

    public static List<Entity> areaAttack(LivingEntity playerIn, Consumer<LivingEntity> beforeHit, float comboRatio, boolean forceHit, boolean resetHit, boolean mute) {
        return AttackManager.areaAttack(playerIn, beforeHit, comboRatio, forceHit, resetHit, mute, null);
    }

    public static List<Entity> areaAttack(LivingEntity playerIn, Consumer<LivingEntity> beforeHit, float comboRatio, boolean forceHit, boolean resetHit, boolean mute, List<Entity> exclude) {
        List<Object> founds = Lists.newArrayList();
        if (!playerIn.m_9236_().m_5776_()) {
            founds = TargetSelector.getTargettableEntitiesWithinAABB(playerIn.m_9236_(), playerIn);
            if (exclude != null) {
                founds.removeAll(exclude);
            }
            for (Entity entity : founds) {
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    beforeHit.accept(living);
                }
                AttackManager.doMeleeAttack(playerIn, entity, forceHit, resetHit, comboRatio);
            }
        }
        if (!mute) {
            playerIn.m_9236_().m_6263_((Player)null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.5f, 0.4f / (playerIn.m_217043_().m_188501_() * 0.4f + 0.8f));
        }
        return founds;
    }

    public static <E extends Entity> List<Entity> areaAttack(E owner, Consumer<LivingEntity> beforeHit, double reach, boolean forceHit, boolean resetHit) {
        return AttackManager.areaAttack(owner, beforeHit, reach, forceHit, resetHit, null);
    }

    public static <E extends Entity> List<Entity> areaAttack(E owner, Consumer<LivingEntity> beforeHit, double reach, boolean forceHit, boolean resetHit, List<Entity> exclude) {
        return AttackManager.areaAttack(owner, beforeHit, reach, forceHit, resetHit, 1.0f, exclude);
    }

    public static <E extends Entity> List<Entity> areaAttack(E owner, Consumer<LivingEntity> beforeHit, double reach, boolean forceHit, boolean resetHit, float comboRatio, List<Entity> exclude) {
        List<Object> founds = Lists.newArrayList();
        if (!owner.m_9236_().m_5776_()) {
            founds = TargetSelector.getTargettableEntitiesWithinAABB(owner.m_9236_(), reach, owner);
            if (exclude != null) {
                founds.removeAll(exclude);
            }
            for (Entity entity : founds) {
                if (entity instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity;
                    beforeHit.accept(living);
                }
                float baseAmount = (float)((IShootable)owner).getDamage();
                Entity entity2 = ((IShootable)owner).getShooter();
                if (entity2 instanceof LivingEntity) {
                    LivingEntity living = (LivingEntity)entity2;
                    if (!(owner instanceof EntitySlashEffect)) {
                        int powerLevel = living.m_21205_().getEnchantmentLevel(Enchantments.f_44988_);
                        baseAmount += (float)powerLevel * 0.1f;
                    }
                    baseAmount = (float)((double)baseAmount * living.m_21133_(Attributes.f_22281_));
                    if (owner instanceof Player) {
                        Player player = (Player)owner;
                        IConcentrationRank.ConcentrationRanks rankBonus = player.getCapability(ConcentrationRankCapabilityProvider.RANK_POINT).map(rp -> rp.getRank(player.m_20193_().m_46467_())).orElse(IConcentrationRank.ConcentrationRanks.NONE);
                        float rankDamageBonus = (float)rankBonus.level / 2.0f;
                        if (IConcentrationRank.ConcentrationRanks.S.level <= rankBonus.level) {
                            int refine = player.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).map(rp -> rp.getRefine()).orElse(0);
                            int level = player.f_36078_;
                            rankDamageBonus = (float)Math.max((double)rankDamageBonus, (double)Math.min(level, refine) * (Double)SlashBladeConfig.REFINE_DAMAGE_MULTIPLIER.get());
                        }
                        baseAmount += rankDamageBonus;
                    }
                    baseAmount = (float)((double)baseAmount * ((double)(comboRatio * AttackManager.getSlashBladeDamageScale(living)) * (Double)SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER.get()));
                }
                AttackManager.doAttackWith(owner.m_269291_().m_269104_(owner, ((IShootable)owner).getShooter()), baseAmount, entity, forceHit, resetHit);
            }
        }
        return founds;
    }

    public static void doManagedAttack(Consumer<Entity> attack, Entity target, boolean forceHit, boolean resetHit) {
        if (forceHit) {
            target.f_19802_ = 0;
        }
        attack.accept(target);
        if (resetHit) {
            target.f_19802_ = 0;
        }
    }

    public static void doAttackWith(DamageSource src, float amount, Entity target, boolean forceHit, boolean resetHit) {
        if (target instanceof EntityAbstractSummonedSword) {
            return;
        }
        AttackManager.doManagedAttack(t -> t.m_6469_(src, amount), target, forceHit, resetHit);
    }

    public static void doMeleeAttack(LivingEntity attacker, Entity target, boolean forceHit, boolean resetHit) {
        AttackManager.doMeleeAttack(attacker, target, forceHit, resetHit, 1.0f);
    }

    public static void doMeleeAttack(LivingEntity attacker, Entity target, boolean forceHit, boolean resetHit, float comboRatio) {
        if (attacker instanceof Player) {
            AttackManager.doManagedAttack(t -> attacker.m_21205_().getCapability(ItemSlashBlade.BLADESTATE).ifPresent(state -> {
                try {
                    state.setOnClick(true);
                    PlayerAttackHelper.attack((Player)attacker, t, comboRatio);
                }
                finally {
                    state.setOnClick(false);
                }
            }), target, forceHit, resetHit);
        } else {
            float baseAmount = (float)(attacker.m_21051_(Attributes.f_22281_).m_22135_() * (double)AttackManager.getSlashBladeDamageScale(attacker) * (Double)SlashBladeConfig.SLASHBLADE_DAMAGE_MULTIPLIER.get());
            AttackManager.doAttackWith(attacker.m_269291_().m_269333_(attacker), baseAmount, target, forceHit, resetHit);
        }
        ArrowReflector.doReflect(target, (Entity)attacker);
        TNTExtinguisher.doExtinguishing(target, attacker);
    }

    public static void playQuickSheathSoundAction(LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11744_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static void playPiercingSoundAction(LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        entity.m_9236_().m_6263_((Player)null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_12520_, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static Vec3 genRushOffset(LivingEntity entityIn) {
        return new Vec3((double)(entityIn.m_217043_().m_188501_() - 0.5f), (double)(entityIn.m_217043_().m_188501_() - 0.5f), 0.0).m_82490_(2.0);
    }

    public static float getSlashBladeDamageScale(LivingEntity entity) {
        if (entity.m_21051_(ModAttributes.getSlashBladeDamage()) != null) {
            return (float)entity.m_21051_(ModAttributes.getSlashBladeDamage()).m_22135_();
        }
        return 1.0f;
    }
}

