/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter.attribute.attributes;

import com.simibubi.create.content.logistics.item.filter.attribute.AllItemAttributeTypes;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttribute;
import com.simibubi.create.content.logistics.item.filter.attribute.ItemAttributeType;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class AddedByAttribute
implements ItemAttribute {
    private String modId;

    public AddedByAttribute(String modId) {
        this.modId = modId;
    }

    @Override
    public boolean appliesTo(ItemStack stack, Level world) {
        return this.modId.equals(stack.m_41720_().getCreatorModId(stack));
    }

    @Override
    public String getTranslationKey() {
        return "added_by";
    }

    @Override
    public Object[] getTranslationParameters() {
        Optional modContainerById = ModList.get().getModContainerById(this.modId);
        String name = modContainerById.map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(StringUtils.capitalize((String)this.modId));
        return new Object[]{name};
    }

    @Override
    public void save(CompoundTag nbt) {
        nbt.m_128359_("modId", this.modId);
    }

    @Override
    public void load(CompoundTag nbt) {
        this.modId = nbt.m_128461_("modId");
    }

    @Override
    public ItemAttributeType getType() {
        return AllItemAttributeTypes.ADDED_BY;
    }

    public static class Type
    implements ItemAttributeType {
        @Override
        @NotNull
        public ItemAttribute createAttribute() {
            return new AddedByAttribute("dummy");
        }

        @Override
        public List<ItemAttribute> getAllAttributes(ItemStack stack, Level level) {
            String id = stack.m_41720_().getCreatorModId(stack);
            return id == null ? Collections.emptyList() : List.of(new AddedByAttribute(id));
        }
    }
}

