/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.track;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPackets;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.FakeTrackBlock;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntityTilt;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.IMergeableBE;
import com.simibubi.create.foundation.blockEntity.RemoveBlockEntityPacket;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import dev.engine_room.flywheel.lib.visualization.VisualizationHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.fml.DistExecutor;

public class TrackBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity,
IMergeableBE {
    Map<BlockPos, BezierConnection> connections = new HashMap<BlockPos, BezierConnection>();
    boolean cancelDrops;
    public Pair<ResourceKey<Level>, BlockPos> boundLocation;
    public TrackBlockEntityTilt tilt;

    public TrackBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(100);
        this.tilt = new TrackBlockEntityTilt(this);
    }

    public Map<BlockPos, BezierConnection> getConnections() {
        return this.connections;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.f_58857_.f_46443_ && this.hasInteractableConnections()) {
            this.registerToCurveInteraction();
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.tilt.undoSmoothing();
    }

    @Override
    public void lazyTick() {
        for (BezierConnection connection : this.connections.values()) {
            if (!connection.isPrimary()) continue;
            this.manageFakeTracksAlong(connection, false);
        }
    }

    public void validateConnections() {
        HashSet<BlockPos> invalid = new HashSet<BlockPos>();
        for (Map.Entry<BlockPos, BezierConnection> entry : this.connections.entrySet()) {
            TrackBlockEntity trackBE;
            BezierConnection bc;
            block10: {
                BlockPos key;
                block9: {
                    BlockEntity blockEntity;
                    key = entry.getKey();
                    if (!key.equals((Object)(bc = entry.getValue()).getKey()) || !this.f_58858_.equals(bc.bePositions.getFirst())) {
                        invalid.add(key);
                        continue;
                    }
                    BlockState blockState = this.f_58857_.m_8055_(key);
                    Block block = blockState.m_60734_();
                    if (block instanceof ITrackBlock) {
                        ITrackBlock trackBlock = (ITrackBlock)block;
                        if (!((Boolean)blockState.m_61143_((Property)TrackBlock.HAS_BE)).booleanValue()) {
                            for (Vec3 v : trackBlock.getTrackAxes((BlockGetter)this.f_58857_, key, blockState)) {
                                Vec3 bcEndAxis;
                                if (!(v.m_82554_(bcEndAxis = (Vec3)bc.axes.getSecond()) < 9.765625E-4) && !(v.m_82554_(bcEndAxis.m_82490_(-1.0)) < 9.765625E-4)) continue;
                                this.f_58857_.m_7731_(key, (BlockState)blockState.m_61124_((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(true)), 3);
                            }
                        }
                    }
                    if (!((blockEntity = this.f_58857_.m_7702_(key)) instanceof TrackBlockEntity)) break block9;
                    trackBE = (TrackBlockEntity)blockEntity;
                    if (!blockEntity.m_58901_()) break block10;
                }
                invalid.add(key);
                continue;
            }
            if (trackBE.connections.containsKey(this.f_58858_)) continue;
            trackBE.addConnection(bc.secondary());
            trackBE.tilt.tryApplySmoothing();
        }
        for (BlockPos blockPos : invalid) {
            this.removeConnection(blockPos);
        }
    }

    public void addConnection(BezierConnection connection) {
        if (this.connections.containsKey(connection.getKey()) && connection.equalsSansMaterial(this.connections.get(connection.getKey()))) {
            return;
        }
        this.connections.put(connection.getKey(), connection);
        this.f_58857_.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), 1);
        this.notifyUpdate();
        if (connection.isPrimary()) {
            this.manageFakeTracksAlong(connection, false);
        }
    }

    public void removeConnection(BlockPos target) {
        if (this.isTilted()) {
            this.tilt.captureSmoothingHandles();
        }
        BezierConnection removed = this.connections.remove(target);
        this.notifyUpdate();
        if (removed != null) {
            this.manageFakeTracksAlong(removed, true);
        }
        if (!this.connections.isEmpty() || this.m_58900_().m_61145_(TrackBlock.SHAPE).orElse(TrackShape.NONE).isPortal()) {
            return;
        }
        BlockState blockState = this.f_58857_.m_8055_(this.f_58858_);
        if (blockState.m_61138_((Property)TrackBlock.HAS_BE)) {
            this.f_58857_.m_46597_(this.f_58858_, (BlockState)blockState.m_61124_((Property)TrackBlock.HAS_BE, (Comparable)Boolean.valueOf(false)));
        }
        AllPackets.getChannel().send(this.packetTarget(), (Object)new RemoveBlockEntityPacket(this.f_58858_));
    }

    public void removeInboundConnections(boolean dropAndDiscard) {
        for (BezierConnection bezierConnection : this.connections.values()) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(bezierConnection.getKey());
            if (!(blockEntity instanceof TrackBlockEntity)) {
                return;
            }
            TrackBlockEntity tbe = (TrackBlockEntity)blockEntity;
            tbe.removeConnection((BlockPos)bezierConnection.bePositions.getFirst());
            if (!dropAndDiscard) continue;
            if (!this.cancelDrops) {
                bezierConnection.spawnItems(this.f_58857_);
            }
            bezierConnection.spawnDestroyParticles(this.f_58857_);
        }
        if (dropAndDiscard) {
            AllPackets.getChannel().send(this.packetTarget(), (Object)new RemoveBlockEntityPacket(this.f_58858_));
        }
    }

    public void bind(ResourceKey<Level> boundDimension, BlockPos boundLocation) {
        this.boundLocation = Pair.of(boundDimension, (Object)boundLocation);
        this.m_6596_();
    }

    public boolean isTilted() {
        return this.tilt.smoothingAngle.isPresent();
    }

    @Override
    public void writeSafe(CompoundTag tag) {
        super.writeSafe(tag);
        this.writeTurns(tag, true);
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        this.writeTurns(tag, false);
        if (this.isTilted()) {
            tag.m_128347_("Smoothing", this.tilt.smoothingAngle.get().doubleValue());
        }
        if (this.boundLocation == null) {
            return;
        }
        tag.m_128365_("BoundLocation", (Tag)NbtUtils.m_129224_((BlockPos)((BlockPos)this.boundLocation.getSecond())));
        tag.m_128359_("BoundDimension", ((ResourceKey)this.boundLocation.getFirst()).m_135782_().toString());
    }

    private void writeTurns(CompoundTag tag, boolean restored) {
        ListTag listTag = new ListTag();
        for (BezierConnection bezierConnection : this.connections.values()) {
            listTag.add((Object)(restored ? this.tilt.restoreToOriginalCurve(bezierConnection.clone()) : bezierConnection).write(this.f_58858_));
        }
        tag.m_128365_("Connections", (Tag)listTag);
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.connections.clear();
        for (Tag t : tag.m_128437_("Connections", 10)) {
            if (!(t instanceof CompoundTag)) {
                return;
            }
            BezierConnection connection = new BezierConnection((CompoundTag)t, this.f_58858_);
            this.connections.put(connection.getKey(), connection);
        }
        boolean smoothingPreviously = this.tilt.smoothingAngle.isPresent();
        this.tilt.smoothingAngle = Optional.ofNullable(tag.m_128441_("Smoothing") ? Double.valueOf(tag.m_128459_("Smoothing")) : null);
        if (smoothingPreviously != this.tilt.smoothingAngle.isPresent() && clientPacket) {
            this.requestModelDataUpdate();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 16);
        }
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> VisualizationHelper.queueUpdate((BlockEntity)this));
        if (this.hasInteractableConnections()) {
            this.registerToCurveInteraction();
        } else {
            this.removeFromCurveInteraction();
        }
        if (tag.m_128441_("BoundLocation")) {
            this.boundLocation = Pair.of((Object)ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(tag.m_128461_("BoundDimension"))), (Object)NbtUtils.m_129239_((CompoundTag)tag.m_128469_("BoundLocation")));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    public void accept(BlockEntity other) {
        if (other instanceof TrackBlockEntity) {
            TrackBlockEntity track = (TrackBlockEntity)other;
            this.connections.putAll(track.connections);
        }
        this.validateConnections();
        this.f_58857_.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), 1);
    }

    public boolean hasInteractableConnections() {
        for (BezierConnection connection : this.connections.values()) {
            if (!connection.isPrimary()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void transform(BlockEntity be, StructureTransform transform) {
        HashMap<BlockPos, BezierConnection> restoredConnections = new HashMap<BlockPos, BezierConnection>();
        for (Map.Entry<BlockPos, BezierConnection> entry : this.connections.entrySet()) {
            restoredConnections.put(entry.getKey(), this.tilt.restoreToOriginalCurve(this.tilt.restoreToOriginalCurve(entry.getValue().secondary()).secondary()));
        }
        this.connections = restoredConnections;
        this.tilt.smoothingAngle = Optional.empty();
        if (transform.rotationAxis != Direction.Axis.Y) {
            return;
        }
        HashMap<BlockPos, BezierConnection> transformedConnections = new HashMap<BlockPos, BezierConnection>();
        for (Map.Entry<BlockPos, BezierConnection> entry : this.connections.entrySet()) {
            BezierConnection newConnection = entry.getValue();
            newConnection.normals.replace(transform::applyWithoutOffsetUncentered);
            newConnection.axes.replace(transform::applyWithoutOffsetUncentered);
            BlockPos diff = ((BlockPos)newConnection.bePositions.getSecond()).m_121996_((Vec3i)newConnection.bePositions.getFirst());
            newConnection.bePositions.setSecond((Object)BlockPos.m_274446_((Position)Vec3.m_82512_((Vec3i)((Vec3i)newConnection.bePositions.getFirst())).m_82549_(transform.applyWithoutOffsetUncentered(Vec3.m_82528_((Vec3i)diff)))));
            Vec3 beVec = Vec3.m_82528_((Vec3i)this.f_58858_);
            Vec3 teCenterVec = beVec.m_82520_(0.5, 0.5, 0.5);
            Vec3 start = (Vec3)newConnection.starts.getFirst();
            Vec3 startToBE = start.m_82546_(teCenterVec);
            Vec3 endToStart = ((Vec3)newConnection.starts.getSecond()).m_82546_(start);
            startToBE = transform.applyWithoutOffsetUncentered(startToBE).m_82549_(teCenterVec);
            endToStart = transform.applyWithoutOffsetUncentered(endToStart).m_82549_(startToBE);
            newConnection.starts.setFirst((Object)new TrackNodeLocation(startToBE).getLocation());
            newConnection.starts.setSecond((Object)new TrackNodeLocation(endToStart).getLocation());
            BlockPos newTarget = newConnection.getKey();
            transformedConnections.put(newTarget, newConnection);
        }
        this.connections = transformedConnections;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.f_58857_.f_46443_) {
            this.removeFromCurveInteraction();
        }
    }

    @Override
    public void remove() {
        super.remove();
        for (BezierConnection connection : this.connections.values()) {
            this.manageFakeTracksAlong(connection, true);
        }
        if (this.boundLocation != null && this.f_58857_ instanceof ServerLevel) {
            ServerLevel otherLevel = this.f_58857_.m_7654_().m_129880_((ResourceKey)this.boundLocation.getFirst());
            if (otherLevel == null) {
                return;
            }
            if (AllTags.AllBlockTags.TRACKS.matches(otherLevel.m_8055_((BlockPos)this.boundLocation.getSecond()))) {
                otherLevel.m_46961_((BlockPos)this.boundLocation.getSecond(), false);
            }
        }
    }

    private void registerToCurveInteraction() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::registerToCurveInteractionUnsafe);
    }

    private void removeFromCurveInteraction() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::removeFromCurveInteractionUnsafe);
    }

    public ModelData getModelData() {
        if (!this.isTilted()) {
            return super.getModelData();
        }
        return ModelData.builder().with(TrackBlockEntityTilt.ASCENDING_PROPERTY, (Object)this.tilt.smoothingAngle.get()).build();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void registerToCurveInteractionUnsafe() {
        ((Map)TrackBlockOutline.TRACKS_WITH_TURNS.get((LevelAccessor)this.f_58857_)).put(this.f_58858_, this);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void removeFromCurveInteractionUnsafe() {
        ((Map)TrackBlockOutline.TRACKS_WITH_TURNS.get((LevelAccessor)this.f_58857_)).remove(this.f_58858_);
    }

    public void manageFakeTracksAlong(BezierConnection bc, boolean remove) {
        Map<Pair<Integer, Integer>, Double> yLevels = bc.rasterise();
        for (Map.Entry<Pair<Integer, Integer>, Double> entry : yLevels.entrySet()) {
            double yValue = entry.getValue();
            int floor = Mth.m_14107_((double)yValue);
            BlockPos targetPos = new BlockPos(((Integer)entry.getKey().getFirst()).intValue(), floor, ((Integer)entry.getKey().getSecond()).intValue());
            targetPos = targetPos.m_121955_((Vec3i)bc.bePositions.getFirst()).m_6630_(1);
            BlockState stateAtPos = this.f_58857_.m_8055_(targetPos);
            boolean present = AllBlocks.FAKE_TRACK.has(stateAtPos);
            if (remove) {
                if (!present) continue;
                this.f_58857_.m_7471_(targetPos, false);
                continue;
            }
            FluidState fluidState = stateAtPos.m_60819_();
            if (!fluidState.m_76178_() && !fluidState.m_164512_((Fluid)Fluids.f_76193_)) continue;
            if (!present && stateAtPos.m_247087_()) {
                this.f_58857_.m_7731_(targetPos, ProperWaterloggedBlock.withWater((LevelAccessor)this.f_58857_, AllBlocks.FAKE_TRACK.getDefaultState(), targetPos), 3);
            }
            FakeTrackBlock.keepAlive((LevelAccessor)this.f_58857_, targetPos);
        }
    }
}

