/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.impl.contraption;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllTags;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.contraption.BlockMovementChecks;
import com.simibubi.create.api.contraption.ContraptionMovementSetting;
import com.simibubi.create.content.contraptions.actors.AttachedActorBlock;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterBlock;
import com.simibubi.create.content.contraptions.actors.psi.PortableStorageInterfaceBlock;
import com.simibubi.create.content.contraptions.bearing.ClockworkBearingBlock;
import com.simibubi.create.content.contraptions.bearing.ClockworkBearingBlockEntity;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlock;
import com.simibubi.create.content.contraptions.bearing.MechanicalBearingBlockEntity;
import com.simibubi.create.content.contraptions.bearing.SailBlock;
import com.simibubi.create.content.contraptions.chassis.AbstractChassisBlock;
import com.simibubi.create.content.contraptions.chassis.StickerBlock;
import com.simibubi.create.content.contraptions.mounted.CartAssemblerBlock;
import com.simibubi.create.content.contraptions.piston.MechanicalPistonBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyBlockEntity;
import com.simibubi.create.content.decoration.slidingDoor.SlidingDoorBlock;
import com.simibubi.create.content.decoration.steamWhistle.WhistleBlock;
import com.simibubi.create.content.decoration.steamWhistle.WhistleExtenderBlock;
import com.simibubi.create.content.fluids.tank.FluidTankBlock;
import com.simibubi.create.content.kinetics.crank.HandCrankBlock;
import com.simibubi.create.content.kinetics.fan.NozzleBlock;
import com.simibubi.create.content.logistics.packagerLink.PackagerLinkBlock;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.content.redstone.link.RedstoneLinkBlock;
import com.simibubi.create.content.trains.bogey.AbstractBogeyBlock;
import com.simibubi.create.content.trains.station.StationBlock;
import com.simibubi.create.content.trains.track.ITrackBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneWallTorchBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BellAttachType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;

public class BlockMovementChecksImpl {
    private static final List<BlockMovementChecks.MovementNecessaryCheck> MOVEMENT_NECESSARY_CHECKS = new ArrayList<BlockMovementChecks.MovementNecessaryCheck>();
    private static final List<BlockMovementChecks.MovementAllowedCheck> MOVEMENT_ALLOWED_CHECKS = new ArrayList<BlockMovementChecks.MovementAllowedCheck>();
    private static final List<BlockMovementChecks.BrittleCheck> BRITTLE_CHECKS = new ArrayList<BlockMovementChecks.BrittleCheck>();
    private static final List<BlockMovementChecks.AttachedCheck> ATTACHED_CHECKS = new ArrayList<BlockMovementChecks.AttachedCheck>();
    private static final List<BlockMovementChecks.NotSupportiveCheck> NOT_SUPPORTIVE_CHECKS = new ArrayList<BlockMovementChecks.NotSupportiveCheck>();

    public static synchronized void registerMovementNecessaryCheck(BlockMovementChecks.MovementNecessaryCheck check) {
        MOVEMENT_NECESSARY_CHECKS.add(0, check);
    }

    public static synchronized void registerMovementAllowedCheck(BlockMovementChecks.MovementAllowedCheck check) {
        MOVEMENT_ALLOWED_CHECKS.add(0, check);
    }

    public static synchronized void registerBrittleCheck(BlockMovementChecks.BrittleCheck check) {
        BRITTLE_CHECKS.add(0, check);
    }

    public static synchronized void registerAttachedCheck(BlockMovementChecks.AttachedCheck check) {
        ATTACHED_CHECKS.add(0, check);
    }

    public static synchronized void registerNotSupportiveCheck(BlockMovementChecks.NotSupportiveCheck check) {
        NOT_SUPPORTIVE_CHECKS.add(0, check);
    }

    public static boolean isMovementNecessary(BlockState state, Level world, BlockPos pos) {
        for (BlockMovementChecks.MovementNecessaryCheck check : MOVEMENT_NECESSARY_CHECKS) {
            BlockMovementChecks.CheckResult result = check.isMovementNecessary(state, world, pos);
            if (result == BlockMovementChecks.CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecksImpl.isMovementNecessaryFallback(state, world, pos);
    }

    public static boolean isMovementAllowed(BlockState state, Level world, BlockPos pos) {
        for (BlockMovementChecks.MovementAllowedCheck check : MOVEMENT_ALLOWED_CHECKS) {
            BlockMovementChecks.CheckResult result = check.isMovementAllowed(state, world, pos);
            if (result == BlockMovementChecks.CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecksImpl.isMovementAllowedFallback(state, world, pos);
    }

    public static boolean isBrittle(BlockState state) {
        for (BlockMovementChecks.BrittleCheck check : BRITTLE_CHECKS) {
            BlockMovementChecks.CheckResult result = check.isBrittle(state);
            if (result == BlockMovementChecks.CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecksImpl.isBrittleFallback(state);
    }

    public static boolean isBlockAttachedTowards(BlockState state, Level world, BlockPos pos, Direction direction) {
        for (BlockMovementChecks.AttachedCheck check : ATTACHED_CHECKS) {
            BlockMovementChecks.CheckResult result = check.isBlockAttachedTowards(state, world, pos, direction);
            if (result == BlockMovementChecks.CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecksImpl.isBlockAttachedTowardsFallback(state, world, pos, direction);
    }

    public static boolean isNotSupportive(BlockState state, Direction facing) {
        for (BlockMovementChecks.NotSupportiveCheck check : NOT_SUPPORTIVE_CHECKS) {
            BlockMovementChecks.CheckResult result = check.isNotSupportive(state, facing);
            if (result == BlockMovementChecks.CheckResult.PASS) continue;
            return result.toBoolean();
        }
        return BlockMovementChecksImpl.isNotSupportiveFallback(state, facing);
    }

    private static boolean isMovementNecessaryFallback(BlockState state, Level world, BlockPos pos) {
        if (BlockMovementChecks.isBrittle(state)) {
            return true;
        }
        if (AllTags.AllBlockTags.MOVABLE_EMPTY_COLLIDER.matches(state)) {
            return true;
        }
        if (state.m_60812_((BlockGetter)world, pos).m_83281_()) {
            return false;
        }
        return !state.m_247087_();
    }

    private static boolean isMovementAllowedFallback(BlockState state, Level world, BlockPos pos) {
        BlockEntity be;
        Block block = state.m_60734_();
        if (block instanceof AbstractChassisBlock) {
            return true;
        }
        if (state.m_60800_((BlockGetter)world, pos) == -1.0f) {
            return false;
        }
        if (AllTags.AllBlockTags.RELOCATION_NOT_SUPPORTED.matches(state)) {
            return false;
        }
        if (AllTags.AllBlockTags.NON_MOVABLE.matches(state)) {
            return false;
        }
        if (ContraptionMovementSetting.get(state) == ContraptionMovementSetting.UNMOVABLE) {
            return false;
        }
        if (block instanceof MechanicalPistonBlock && state.m_61143_(MechanicalPistonBlock.STATE) != MechanicalPistonBlock.PistonState.MOVING) {
            return true;
        }
        if (block instanceof MechanicalBearingBlock && (be = world.m_7702_(pos)) instanceof MechanicalBearingBlockEntity) {
            return !((MechanicalBearingBlockEntity)be).isRunning();
        }
        if (block instanceof ClockworkBearingBlock && (be = world.m_7702_(pos)) instanceof ClockworkBearingBlockEntity) {
            return !((ClockworkBearingBlockEntity)be).isRunning();
        }
        if (block instanceof PulleyBlock && (be = world.m_7702_(pos)) instanceof PulleyBlockEntity) {
            PulleyBlockEntity pulley = (PulleyBlockEntity)be;
            return !pulley.running;
        }
        if (AllBlocks.BELT.has(state)) {
            return true;
        }
        if (state.m_60734_() instanceof GrindstoneBlock) {
            return true;
        }
        if (state.m_60734_() instanceof ITrackBlock) {
            return false;
        }
        if (state.m_60734_() instanceof StationBlock) {
            return false;
        }
        return state.m_60811_() != PushReaction.BLOCK;
    }

    private static boolean isBrittleFallback(BlockState state) {
        Block block = state.m_60734_();
        if (state.m_61138_((Property)BlockStateProperties.f_61435_)) {
            return true;
        }
        if (block instanceof LadderBlock) {
            return true;
        }
        if (block instanceof TorchBlock) {
            return true;
        }
        if (block instanceof SignBlock) {
            return true;
        }
        if (block instanceof BasePressurePlateBlock) {
            return true;
        }
        if (block instanceof FaceAttachedHorizontalDirectionalBlock && !(block instanceof GrindstoneBlock) && !(block instanceof PackagerLinkBlock)) {
            return true;
        }
        if (block instanceof CartAssemblerBlock) {
            return false;
        }
        if (block instanceof BaseRailBlock) {
            return true;
        }
        if (block instanceof DiodeBlock) {
            return true;
        }
        if (block instanceof RedStoneWireBlock) {
            return true;
        }
        if (block instanceof WoolCarpetBlock) {
            return true;
        }
        if (block instanceof WhistleBlock) {
            return true;
        }
        if (block instanceof WhistleExtenderBlock) {
            return true;
        }
        return AllTags.AllBlockTags.BRITTLE.matches(state);
    }

    private static boolean isBlockAttachedTowardsFallback(BlockState state, Level world, BlockPos pos, Direction direction) {
        Block block = state.m_60734_();
        if (block instanceof LadderBlock) {
            return state.m_61143_((Property)LadderBlock.f_54337_) == direction.m_122424_();
        }
        if (block instanceof WallTorchBlock) {
            return state.m_61143_((Property)WallTorchBlock.f_58119_) == direction.m_122424_();
        }
        if (block instanceof WallSignBlock) {
            return state.m_61143_((Property)WallSignBlock.f_58064_) == direction.m_122424_();
        }
        if (block instanceof StandingSignBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof BasePressurePlateBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof DoorBlock) {
            if (state.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER && direction == Direction.UP) {
                return true;
            }
            return direction == Direction.DOWN;
        }
        if (block instanceof BedBlock) {
            Direction facing = (Direction)state.m_61143_((Property)BedBlock.f_54117_);
            if (state.m_61143_((Property)BedBlock.f_49440_) == BedPart.HEAD) {
                facing = facing.m_122424_();
            }
            return direction == facing;
        }
        if (block instanceof RedstoneLinkBlock) {
            return direction.m_122424_() == state.m_61143_((Property)RedstoneLinkBlock.f_52588_);
        }
        if (block instanceof FlowerPotBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof DiodeBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof RedStoneWireBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof WoolCarpetBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof RedstoneWallTorchBlock) {
            return state.m_61143_((Property)RedstoneWallTorchBlock.f_55740_) == direction.m_122424_();
        }
        if (block instanceof TorchBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof FaceAttachedHorizontalDirectionalBlock) {
            AttachFace attachFace = (AttachFace)state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_);
            if (attachFace == AttachFace.CEILING) {
                return direction == Direction.UP;
            }
            if (attachFace == AttachFace.FLOOR) {
                return direction == Direction.DOWN;
            }
            if (attachFace == AttachFace.WALL) {
                return direction.m_122424_() == state.m_61143_((Property)FaceAttachedHorizontalDirectionalBlock.f_54117_);
            }
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61435_)) {
            return direction == ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61435_) != false ? Direction.UP : Direction.DOWN);
        }
        if (block instanceof BaseRailBlock) {
            return direction == Direction.DOWN;
        }
        if (block instanceof AttachedActorBlock) {
            return direction == ((Direction)state.m_61143_((Property)HarvesterBlock.f_54117_)).m_122424_();
        }
        if (block instanceof HandCrankBlock) {
            return direction == ((Direction)state.m_61143_((Property)HandCrankBlock.FACING)).m_122424_();
        }
        if (block instanceof NozzleBlock) {
            return direction == ((Direction)state.m_61143_((Property)NozzleBlock.f_52588_)).m_122424_();
        }
        if (block instanceof BellBlock) {
            BellAttachType attachment = (BellAttachType)state.m_61143_((Property)BlockStateProperties.f_61377_);
            if (attachment == BellAttachType.FLOOR) {
                return direction == Direction.DOWN;
            }
            if (attachment == BellAttachType.CEILING) {
                return direction == Direction.UP;
            }
            return direction == state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        }
        if (state.m_60734_() instanceof SailBlock) {
            return direction.m_122434_() != ((Direction)state.m_61143_((Property)SailBlock.f_52588_)).m_122434_();
        }
        if (state.m_60734_() instanceof FluidTankBlock) {
            return ConnectivityHandler.isConnected((BlockGetter)world, pos, pos.m_121945_(direction));
        }
        if (state.m_60734_() instanceof ItemVaultBlock) {
            return ConnectivityHandler.isConnected((BlockGetter)world, pos, pos.m_121945_(direction));
        }
        if (AllBlocks.STICKER.has(state) && ((Boolean)state.m_61143_((Property)StickerBlock.EXTENDED)).booleanValue()) {
            return direction == state.m_61143_((Property)StickerBlock.f_52588_) && !BlockMovementChecks.isNotSupportive(world.m_8055_(pos.m_121945_(direction)), direction.m_122424_());
        }
        if (block instanceof AbstractBogeyBlock) {
            AbstractBogeyBlock bogey = (AbstractBogeyBlock)block;
            return bogey.getStickySurfaces((BlockGetter)world, pos, state).contains(direction);
        }
        if (block instanceof WhistleBlock) {
            return direction == ((Boolean)state.m_61143_((Property)WhistleBlock.WALL) != false ? (Direction)state.m_61143_((Property)WhistleBlock.FACING) : Direction.DOWN);
        }
        if (block instanceof WhistleExtenderBlock) {
            return direction == Direction.DOWN;
        }
        return false;
    }

    private static boolean isNotSupportiveFallback(BlockState state, Direction facing) {
        if (AllBlocks.MECHANICAL_DRILL.has(state)) {
            return state.m_61143_((Property)BlockStateProperties.f_61372_) == facing;
        }
        if (AllBlocks.MECHANICAL_BEARING.has(state)) {
            return state.m_61143_((Property)BlockStateProperties.f_61372_) == facing;
        }
        if (AllBlocks.CART_ASSEMBLER.has(state)) {
            return facing == Direction.DOWN;
        }
        if (AllBlocks.MECHANICAL_SAW.has(state)) {
            return state.m_61143_((Property)BlockStateProperties.f_61372_) == facing;
        }
        if (AllBlocks.PORTABLE_STORAGE_INTERFACE.has(state)) {
            return state.m_61143_((Property)PortableStorageInterfaceBlock.f_52588_) == facing;
        }
        if (state.m_60734_() instanceof AttachedActorBlock && !AllBlocks.MECHANICAL_ROLLER.has(state)) {
            return state.m_61143_((Property)BlockStateProperties.f_61374_) == facing;
        }
        if (AllBlocks.ROPE_PULLEY.has(state)) {
            return facing == Direction.DOWN;
        }
        if (state.m_60734_() instanceof WoolCarpetBlock) {
            return facing == Direction.UP;
        }
        if (state.m_60734_() instanceof SailBlock) {
            return facing.m_122434_() == ((Direction)state.m_61143_((Property)SailBlock.f_52588_)).m_122434_();
        }
        if (AllBlocks.PISTON_EXTENSION_POLE.has(state)) {
            return facing.m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_();
        }
        if (AllBlocks.MECHANICAL_PISTON_HEAD.has(state)) {
            return facing.m_122434_() != ((Direction)state.m_61143_((Property)BlockStateProperties.f_61372_)).m_122434_();
        }
        if (AllBlocks.STICKER.has(state) && !((Boolean)state.m_61143_((Property)StickerBlock.EXTENDED)).booleanValue()) {
            return facing == state.m_61143_((Property)StickerBlock.f_52588_);
        }
        if (state.m_60734_() instanceof SlidingDoorBlock) {
            return false;
        }
        return BlockMovementChecks.isBrittle(state);
    }
}

