/*
 * Decompiled with CFR 0.152.
 */
package net.stalosir.createkart;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.stalosir.createkart.ConfigCreateKart;
import net.stalosir.createkart.init.CreateKartModBlockEntities;
import net.stalosir.createkart.init.CreateKartModBlocks;
import net.stalosir.createkart.init.CreateKartModEntities;
import net.stalosir.createkart.init.CreateKartModItems;
import net.stalosir.createkart.init.CreateKartModSounds;
import net.stalosir.createkart.init.CreateKartModTabs;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="create_kart")
public class CreateKartMod {
    public static final Logger LOGGER = LogManager.getLogger(CreateKartMod.class);
    public static final String MODID = "create_kart";
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel PACKET_HANDLER = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("create_kart", "create_kart"), () -> "1", "1"::equals, "1"::equals);
    private static int messageID = 0;
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public CreateKartMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        CreateKartModSounds.REGISTRY.register(bus);
        CreateKartModBlocks.REGISTRY.register(bus);
        CreateKartModBlockEntities.REGISTRY.register(bus);
        CreateKartModItems.REGISTRY.register(bus);
        CreateKartModEntities.REGISTRY.register(bus);
        CreateKartModTabs.REGISTRY.register(bus);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigCreateKart.SERVER_SPECS);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ConfigCreateKart.CLIENT_SPECS);
    }

    public static <T> void addNetworkMessage(Class<T> messageType, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, Supplier<NetworkEvent.Context>> messageConsumer) {
        PACKET_HANDLER.registerMessage(messageID, messageType, encoder, decoder, messageConsumer);
        ++messageID;
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }

    @Mod.EventBusSubscriber(modid="create_kart", bus=Mod.EventBusSubscriber.Bus.MOD)
    public class ConfigEventHandler {
        @SubscribeEvent
        public static void onLoad(ModConfigEvent.Loading event) {
            if (event.getConfig().getSpec() == ConfigCreateKart.CLIENT_SPECS) {
                ConfigCreateKart.CONFIG_MOVEMENT_SPEED = ConfigCreateKart.CLIENT.getConfigMovementSpeed();
                ConfigCreateKart.CONFIG_ROTATION_STRENGTH = ConfigCreateKart.CLIENT.getConfigRotationStrength();
                ConfigCreateKart.CONFIG_MAX_UP_STEP = ConfigCreateKart.CLIENT.getConfigMaxUpStep();
                ConfigCreateKart.OLD_MOVEMENT_CHECK = ConfigCreateKart.CLIENT.getOldMovementCheck();
                ConfigCreateKart.CONFIG_FUEL_CONSUMPTION = ConfigCreateKart.CLIENT.getConfigFuelConsumption();
                ConfigCreateKart.MINIMAL_OVERLAY_CHECK = ConfigCreateKart.CLIENT.getMinimalOverlayCheck();
            }
        }

        @SubscribeEvent
        public static void onReload(ModConfigEvent.Reloading event) {
            if (event.getConfig().getSpec() == ConfigCreateKart.CLIENT_SPECS) {
                ConfigCreateKart.CONFIG_MOVEMENT_SPEED = ConfigCreateKart.CLIENT.getConfigMovementSpeed();
                ConfigCreateKart.CONFIG_ROTATION_STRENGTH = ConfigCreateKart.CLIENT.getConfigRotationStrength();
                ConfigCreateKart.CONFIG_MAX_UP_STEP = ConfigCreateKart.CLIENT.getConfigMaxUpStep();
                ConfigCreateKart.OLD_MOVEMENT_CHECK = ConfigCreateKart.CLIENT.getOldMovementCheck();
                ConfigCreateKart.CONFIG_FUEL_CONSUMPTION = ConfigCreateKart.CLIENT.getConfigFuelConsumption();
                ConfigCreateKart.MINIMAL_OVERLAY_CHECK = ConfigCreateKart.CLIENT.getMinimalOverlayCheck();
            }
        }
    }
}

