/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.content.components;

import com.oierbravo.create_mechanical_spawner.content.components.SpawnerConfig;
import com.oierbravo.create_mechanical_spawner.content.components.SpawnerPointDisplay;
import com.oierbravo.create_mechanical_spawner.content.components.SpawnerRecipe;
import com.oierbravo.create_mechanical_spawner.content.components.collector.LootCollectorBlock;
import com.oierbravo.create_mechanical_spawner.foundation.blockEntity.behaviour.DynamicCycleBehavior;
import com.oierbravo.create_mechanical_spawner.foundation.blockEntity.behaviour.IHavePercent;
import com.oierbravo.create_mechanical_spawner.foundation.utility.LivingEntityHelper;
import com.oierbravo.create_mechanical_spawner.foundation.utility.ModLang;
import com.oierbravo.create_mechanical_spawner.registrate.ModRecipeTypes;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.logistics.vault.ItemVaultBlock;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollValueBehaviour;
import com.simibubi.create.foundation.fluid.SmartFluidTank;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpawnerBlockEntity
extends KineticBlockEntity
implements DynamicCycleBehavior.DynamicCycleBehaviorSpecifics,
IHavePercent {
    public UUID owner;
    protected DeployerFakePlayer player;
    DynamicCycleBehavior dynamicCycleBehaviour;
    ScrollValueBehaviour scrollValueBehaviour;
    protected FluidTank fluidTank = this.createFluidTank();
    protected LazyOptional<IFluidHandler> fluidCapability = LazyOptional.of(() -> this.fluidTank);
    public int timer = 100;
    protected int totalTime = 100;
    private SpawnerRecipe lastRecipe;

    public SpawnerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.fluidTank = this.createFluidTank();
        this.fluidCapability = LazyOptional.of(() -> this.fluidTank);
    }

    public void initialize() {
        super.initialize();
        this.initHandler();
    }

    private void initHandler() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            this.player = new DeployerFakePlayer(sLevel, this.owner);
            Vec3 initialPos = VecHelper.getCenterOf((Vec3i)this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_(HorizontalKineticBlock.HORIZONTAL_FACING)));
            this.player.m_6034_(initialPos.f_82479_, initialPos.f_82480_, initialPos.f_82481_);
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        int max = (Integer)SpawnerConfig.SPAWNER_MAX_RANGE.get();
        this.scrollValueBehaviour = new ScrollValueBehaviour((Component)ModLang.translate("spawner.scrollValue.label", new Object[0]).component(), (SmartBlockEntity)this, (ValueBoxTransform)new CenteredSideValueBoxTransform()).between(1, max);
        this.scrollValueBehaviour.value = 1;
        behaviours.add((BlockEntityBehaviour)this.scrollValueBehaviour);
        this.dynamicCycleBehaviour = new DynamicCycleBehavior(this);
        behaviours.add(this.dynamicCycleBehaviour);
    }

    public ScrollValueBehaviour getScrollValueBehavior() {
        return this.scrollValueBehaviour;
    }

    protected SmartFluidTank createFluidTank() {
        return new SmartFluidTank(SpawnerBlockEntity.getCapacityMultiplier(), this::onFluidStackChanged);
    }

    protected void onFluidStackChanged(FluidStack newFluidStack) {
        if (!this.m_58898_()) {
            return;
        }
        if (!this.f_58857_.f_46443_) {
            this.m_6596_();
            this.sendData();
        }
    }

    public static int getCapacityMultiplier() {
        return (Integer)SpawnerConfig.SPAWNER_LIQUID_CAPACITY.get();
    }

    public Optional<SpawnerRecipe> getRecipe() {
        SpawnerRecipe.SpawnerRecipeWrapper recipeWrapper = new SpawnerRecipe.SpawnerRecipeWrapper(this.fluidTank.getFluid());
        assert (this.f_58857_ != null);
        if (this.lastRecipe == null || !this.lastRecipe.matches(recipeWrapper, this.f_58857_)) {
            Optional<SpawnerRecipe> sp = ModRecipeTypes.findSpawner(this.fluidTank.getFluid(), this.f_58857_);
            return ModRecipeTypes.findSpawner(this.fluidTank.getFluid(), this.f_58857_);
        }
        return Optional.ofNullable(this.lastRecipe);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        SpawnerPointDisplay.display(this);
        boolean added = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        if (this.getProgressPercent() > 0) {
            ModLang.translate("spawner.tooltip.progress", this.getProgressPercent()).style(ChatFormatting.YELLOW).forGoggles(tooltip);
            added = true;
        }
        if (this.isSpawnPosBlockLootCollector()) {
            ModLang.translate("spawner.tooltip.with_loot_collector", new Object[0]).style(ChatFormatting.GREEN).forGoggles(tooltip);
            added = true;
        }
        return added;
    }

    public boolean containedFluidTooltip(List<Component> tooltip, boolean isPlayerSneaking, LazyOptional<IFluidHandler> handler) {
        return super.containedFluidTooltip(tooltip, isPlayerSneaking, handler);
    }

    private BlockPos getSpawnPos() {
        return this.m_58899_().m_5487_(Direction.Axis.Y, this.scrollValueBehaviour.getValue());
    }

    private boolean isSpawnableBlockPos() {
        if (this.f_58857_ != null && this.f_58857_.m_8055_(this.getSpawnPos()).m_60734_() == Blocks.f_50016_) {
            return true;
        }
        return this.isSpawnPosBlockLootCollector();
    }

    private boolean isSpawnPosBlockLootCollector() {
        assert (this.f_58857_ != null);
        BlockEntity spawnPosBlockEntity = this.f_58857_.m_7702_(this.getSpawnPos());
        if (spawnPosBlockEntity == null) {
            return false;
        }
        if (((Boolean)SpawnerConfig.ALLOW_ANY_CONTAINER_FOR_LOOT_COLLECTOR.get()).booleanValue()) {
            return spawnPosBlockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).isPresent();
        }
        if (this.f_58857_.m_8055_(this.getSpawnPos()).m_60734_() instanceof ItemVaultBlock && ((Boolean)SpawnerConfig.ALLOW_CREATE_ITEM_VAULT_FOR_LOOT_COLLECTOR.get()).booleanValue()) {
            return true;
        }
        return this.f_58857_.m_8055_(this.getSpawnPos()).m_60734_() instanceof LootCollectorBlock;
    }

    public int getProcessingSpeed() {
        return Mth.m_14045_((int)((int)Math.abs(this.getSpeed() / 16.0f)), (int)1, (int)512);
    }

    public void spawnParticles() {
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (this.isFluidHandlerCap(cap)) {
            if (this.fluidCapability == null) {
                this.initHandler();
            }
            return this.fluidCapability.cast();
        }
        return super.getCapability(cap, side);
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128365_("TankContent", (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        this.fluidTank.readFromNBT(compound.m_128469_("TankContent"));
    }

    public int getScrollValueBehaviour() {
        return this.scrollValueBehaviour.getValue();
    }

    public List<BlockPos> getSpawnBlockPosition(Direction forcedMovement, boolean visualize) {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        int position = visualize ? this.scrollValueBehaviour.getValue() : this.getScrollValueBehaviour();
        BlockPos current = this.f_58858_.m_5487_(Direction.Axis.Y, position);
        positions.add(current);
        return positions;
    }

    public List<SpawnerBlockEntity> collectSpawnGroup() {
        return new ArrayList<SpawnerBlockEntity>();
    }

    private void fillCollector(Level pLevel, SpawnerRecipe pSpawnerRecipe, BlockPos pSpawnPos) {
        assert (this.f_58857_ != null);
        if (pLevel.f_46443_) {
            return;
        }
        BlockEntity lootCollector = this.f_58857_.m_7702_(pSpawnPos);
        @NotNull LazyOptional lootCollectorInventoryHandler = lootCollector.getCapability(ForgeCapabilities.ITEM_HANDLER);
        if (!lootCollectorInventoryHandler.isPresent()) {
            return;
        }
        IItemHandler lootCollectorInventory = (IItemHandler)lootCollectorInventoryHandler.resolve().orElseThrow();
        if (((Boolean)SpawnerConfig.CUSTOM_LOOT_PER_SPAWN_RECIPE_ENABLED.get()).booleanValue() && !pSpawnerRecipe.customLoot.isEmpty()) {
            this.fillCollectorWithCustomLoot(lootCollectorInventory, pSpawnerRecipe);
        } else {
            this.fillCollectorWithMobLoot(lootCollectorInventory, pSpawnerRecipe, pSpawnPos);
        }
        lootCollector.m_6596_();
    }

    protected void fillCollectorWithCustomLoot(IItemHandler pLootCollectorInventory, SpawnerRecipe pSpawnerRecipe) {
        List<ItemStack> customLootStack = pSpawnerRecipe.rollCustomLoot();
        for (ItemStack itemStack : customLootStack) {
            ItemHandlerHelper.insertItem((IItemHandler)pLootCollectorInventory, (ItemStack)itemStack, (boolean)false);
        }
    }

    protected void fillCollectorWithMobLoot(IItemHandler pLootCollectorInventory, SpawnerRecipe pSpawnerRecipe, BlockPos pSpawnPos) {
        Entity entitySpawn = LivingEntityHelper.createEntity((ServerLevel)this.f_58857_, pSpawnerRecipe.getMob(), pSpawnPos);
        if (!(entitySpawn instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entitySpawn;
        List<ItemStack> list = LivingEntityHelper.getLootFromMob((ServerLevel)this.f_58857_, (Entity)mob, pSpawnPos, this.getPlayer());
        for (ItemStack itemStack : list) {
            ItemHandlerHelper.insertItem((IItemHandler)pLootCollectorInventory, (ItemStack)itemStack, (boolean)false);
        }
    }

    @Override
    public int getProgressPercent() {
        return this.dynamicCycleBehaviour.getProgressPercent();
    }

    public DeployerFakePlayer getPlayer() {
        return this.player;
    }

    @Override
    public void onCycleCompleted() {
    }

    @Override
    public float getKineticSpeed() {
        return this.getSpeed();
    }

    @Override
    public int getProcessingTime() {
        if (this.getRecipe().isEmpty()) {
            return 0;
        }
        return this.getRecipe().get().getProcessingTime();
    }

    private boolean checkRequirements(SpawnerRecipe recipe) {
        if (!this.isSpawnPosBlockLootCollector()) {
            return false;
        }
        return recipe == null || recipe.getFluidAmount() <= this.fluidTank.getFluidAmount();
    }

    @Override
    public boolean tryProcess(boolean simulate) {
        if (this.getRecipe().isEmpty()) {
            return false;
        }
        if (this.fluidTank.getFluidAmount() < this.getRecipe().get().getFluidAmount()) {
            return false;
        }
        if (!this.isSpawnableBlockPos()) {
            return false;
        }
        if (simulate) {
            return true;
        }
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            return true;
        }
        this.fluidTank.drain(this.getRecipe().get().getFluidAmount(), IFluidHandler.FluidAction.EXECUTE);
        Optional<SpawnerRecipe> recipe = this.getRecipe();
        if (recipe.isPresent()) {
            if (this.isSpawnPosBlockLootCollector()) {
                this.fillCollector(this.f_58857_, recipe.get(), this.getSpawnPos());
            } else {
                LivingEntityHelper.spawnLivingEntity(this.f_58857_, recipe.get().getMob(), this.getSpawnPos());
            }
        }
        this.sendData();
        this.m_6596_();
        return true;
    }

    private boolean checkLootCollector() {
        if (((Boolean)SpawnerConfig.LOOT_COLLECTOR_REQUIRED.get()).booleanValue() || ((Boolean)SpawnerConfig.ALLOW_CREATE_ITEM_VAULT_FOR_LOOT_COLLECTOR.get()).booleanValue() || ((Boolean)SpawnerConfig.ALLOW_ANY_CONTAINER_FOR_LOOT_COLLECTOR.get()).booleanValue()) {
            return this.isSpawnPosBlockLootCollector();
        }
        return false;
    }

    @Override
    public void playSound() {
    }
}

