/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.content.components;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.oierbravo.create_mechanical_spawner.content.components.SpawnerRecipeBuilder;
import com.oierbravo.create_mechanical_spawner.content.components.SpawnerRecipeOutput;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.recipe.IRecipeTypeInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class SpawnerRecipe
implements Recipe<SimpleContainer>,
IRecipeTypeInfo {
    private ResourceLocation id;
    private final FluidIngredient fluidIngredient;
    protected NonNullList<ProcessingOutput> customLoot;
    private SpawnerRecipeOutput mob;
    private final int processingTime;

    public SpawnerRecipe(SpawnerRecipeBuilder.SpawnerRecipeParams params) {
        this.id = params.id;
        this.mob = params.mob;
        this.fluidIngredient = params.fluidIngredient;
        this.processingTime = params.processingTime;
        this.customLoot = params.customLoot;
    }

    public boolean matches(SpawnerRecipeWrapper pContainer, @NotNull Level pLevel) {
        FluidStack fluidStack = pContainer.getFluidStack();
        boolean test = this.fluidIngredient.test(fluidStack);
        return this.fluidIngredient.test(fluidStack);
    }

    public boolean matches(FluidStack fluidStack) {
        return this.fluidIngredient.test(fluidStack);
    }

    public boolean matches(SimpleContainer pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(SimpleContainer pContainer, RegistryAccess pRegistryAccess) {
        return null;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public int getProcessingTime() {
        return this.processingTime;
    }

    public int getFluidAmount() {
        return this.fluidIngredient.getRequiredAmount();
    }

    public FluidIngredient getFluidIngredient() {
        return this.fluidIngredient;
    }

    public EntityType<?> getMob() {
        return this.mob.getMob();
    }

    public NonNullList<ProcessingOutput> getCustomLoot() {
        return this.customLoot;
    }

    public List<ItemStack> rollCustomLoot() {
        return this.rollCustomLoot((List<ProcessingOutput>)this.getCustomLoot());
    }

    public List<ItemStack> rollCustomLoot(List<ProcessingOutput> rollableResults) {
        ArrayList<ItemStack> results = new ArrayList<ItemStack>();
        for (int i = 0; i < rollableResults.size(); ++i) {
            ProcessingOutput output = rollableResults.get(i);
            ItemStack stack = output.rollOutput();
            if (stack.m_41619_()) continue;
            results.add(stack);
        }
        return results;
    }

    public SpawnerRecipeOutput getOutput() {
        if (this.mob == null) {
            return SpawnerRecipeOutput.EMPTY;
        }
        return this.mob;
    }

    public static class SpawnerRecipeWrapper
    extends SimpleContainer {
        protected FluidStack fluidStack;

        public SpawnerRecipeWrapper(FluidStack fluidStack) {
            super(0);
            this.fluidStack = fluidStack;
        }

        public FluidStack getFluidStack() {
            return this.fluidStack;
        }
    }

    public static class Serializer
    implements RecipeSerializer<SpawnerRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("create_mechanical_spawner", "spawner");

        public SpawnerRecipe fromJson(ResourceLocation id, JsonObject json) {
            SpawnerRecipeBuilder builder = new SpawnerRecipeBuilder(id);
            FluidIngredient fluidIngredient = FluidIngredient.EMPTY;
            SpawnerRecipeOutput mob = SpawnerRecipeOutput.EMPTY;
            NonNullList customLoot = NonNullList.m_122779_();
            fluidIngredient = FluidIngredient.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"fluid"));
            if (GsonHelper.m_13900_((JsonObject)json, (String)"mob")) {
                mob = SpawnerRecipeOutput.fromJson(GsonHelper.m_13906_((JsonObject)json, (String)"mob"));
            }
            int processingTime = 200;
            if (GsonHelper.m_13900_((JsonObject)json, (String)"processingTime")) {
                processingTime = GsonHelper.m_13927_((JsonObject)json, (String)"processingTime");
            }
            if (GsonHelper.m_13900_((JsonObject)json, (String)"processingTime")) {
                processingTime = GsonHelper.m_13927_((JsonObject)json, (String)"processingTime");
            }
            if (GsonHelper.m_13900_((JsonObject)json, (String)"customLoot")) {
                for (JsonElement lootEntry : GsonHelper.m_13933_((JsonObject)json, (String)"customLoot")) {
                    customLoot.add((Object)ProcessingOutput.deserialize((JsonElement)lootEntry));
                }
            }
            builder.withFluid(fluidIngredient).withMob(mob).withCustomLoot((NonNullList<ProcessingOutput>)customLoot).withProcessingTime(processingTime);
            return builder.save();
        }

        protected JsonObject toJson(JsonObject json, SpawnerRecipe pRecipe) {
            json.add("fluid", (JsonElement)pRecipe.getFluidIngredient().serialize());
            json.addProperty("mob", pRecipe.getOutput().toJson());
            json.addProperty("processingTime", (Number)pRecipe.getProcessingTime());
            int processingDuration = pRecipe.getProcessingTime();
            if (processingDuration > 0) {
                json.addProperty("processingTime", (Number)processingDuration);
            }
            JsonArray jsonCustomLoot = new JsonArray();
            if (!pRecipe.getCustomLoot().isEmpty()) {
                pRecipe.getCustomLoot().forEach(o -> jsonCustomLoot.add(o.serialize()));
            }
            json.add("customLoot", (JsonElement)jsonCustomLoot);
            return json;
        }

        public SpawnerRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            SpawnerRecipeBuilder builder = new SpawnerRecipeBuilder(id);
            FluidIngredient fluidIngredient = FluidIngredient.read((FriendlyByteBuf)buffer);
            SpawnerRecipeOutput mob = SpawnerRecipeOutput.fromNetwork(buffer);
            int processingTime = buffer.readInt();
            NonNullList customLoot = NonNullList.m_122779_();
            int size = buffer.m_130242_();
            for (int i = 0; i < size; ++i) {
                customLoot.add((Object)ProcessingOutput.read((FriendlyByteBuf)buffer));
            }
            builder.withFluid(fluidIngredient).withMob(mob).withCustomLoot((NonNullList<ProcessingOutput>)customLoot).withProcessingTime(processingTime);
            return builder.save();
        }

        public void toNetwork(FriendlyByteBuf buffer, SpawnerRecipe recipe) {
            FluidIngredient fluidIngredient = recipe.fluidIngredient;
            SpawnerRecipeOutput mob = recipe.mob;
            fluidIngredient.write(buffer);
            mob.toNetwork(buffer);
            buffer.writeInt(recipe.getProcessingTime());
            buffer.m_130130_(recipe.customLoot.size());
            recipe.customLoot.forEach(o -> o.write(buffer));
        }
    }

    public static class Type
    implements RecipeType<SpawnerRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "spawner";

        private Type() {
        }
    }
}

