/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.foundation.blockEntity.behaviour;

import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;

public class DynamicCycleBehavior
extends BlockEntityBehaviour {
    public static final BehaviourType<DynamicCycleBehavior> TYPE = new BehaviourType();
    public DynamicCycleBehaviorSpecifics specifics;
    private int prevRunningTicks;
    private int runningTicks;
    private int processingTime;
    private int currentTime;
    private boolean running;
    private boolean finished;

    public <T extends SmartBlockEntity> DynamicCycleBehavior(T te) {
        super(te);
        this.specifics = (DynamicCycleBehaviorSpecifics)te;
        this.processingTime = 0;
        this.currentTime = 0;
    }

    public void read(CompoundTag compound, boolean clientPacket) {
        this.currentTime = compound.m_128451_("CurrentTime");
        this.processingTime = compound.m_128451_("ProcessingTime");
        this.running = compound.m_128471_("Running");
        this.finished = compound.m_128471_("Finished");
        super.read(compound, clientPacket);
    }

    public void write(CompoundTag compound, boolean clientPacket) {
        compound.m_128405_("CurrentTime", this.currentTime);
        compound.m_128405_("ProcessingTime", this.processingTime);
        compound.m_128379_("Running", this.running);
        compound.m_128379_("Finished", this.finished);
        super.write(compound, clientPacket);
    }

    public void start() {
        this.running = true;
        this.currentTime = 0;
        this.processingTime = this.specifics.getProcessingTime();
        this.blockEntity.sendData();
    }

    public void stop() {
        this.running = false;
        this.currentTime = 0;
        this.processingTime = 0;
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void tick() {
        super.tick();
        Level level = this.getWorld();
        if (!this.running || level == null) {
            if (level != null && !level.f_46443_) {
                if (this.specifics.getKineticSpeed() == 0.0f) {
                    return;
                }
                if (this.specifics.tryProcess(true)) {
                    this.start();
                }
            }
            return;
        }
        if (this.running) {
            this.currentTime += this.getRunningTickSpeed();
        }
        if (this.currentTime >= this.getProccessingTime() && this.specifics.getKineticSpeed() != 0.0f) {
            this.specifics.playSound();
            if (!level.f_46443_) {
                this.stop();
                this.apply();
                this.specifics.onCycleCompleted();
                this.blockEntity.sendData();
            }
        }
    }

    public float getProgress(float partialTicks) {
        int runningTicks = Math.abs(this.runningTicks);
        float ticks = Mth.m_14179_((float)partialTicks, (float)this.prevRunningTicks, (float)runningTicks);
        return ticks / (float)this.getProccessingTime() * 100.0f;
    }

    protected int getProccessingTime() {
        return this.processingTime;
    }

    protected void apply() {
        Level level = this.getWorld();
        if (level.f_46443_) {
            return;
        }
        if (this.specifics.tryProcess(false)) {
            this.blockEntity.sendData();
        }
    }

    public int getRunningTickSpeed() {
        float speed = this.specifics.getKineticSpeed();
        if (speed == 0.0f) {
            return 0;
        }
        return (int)Mth.m_14179_((float)Mth.m_14036_((float)(Math.abs(speed) / 512.0f), (float)0.0f, (float)1.0f), (float)1.0f, (float)30.0f);
    }

    public int getProgressPercent() {
        if (!this.running) {
            return 0;
        }
        return Mth.m_14045_((int)(this.currentTime * 100 / this.getProccessingTime()), (int)0, (int)100);
    }

    public static interface DynamicCycleBehaviorSpecifics {
        public void onCycleCompleted();

        public float getKineticSpeed();

        public int getProcessingTime();

        public boolean tryProcess(boolean var1);

        public void playSound();
    }
}

