/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.create_mechanical_spawner.foundation.utility;

import com.oierbravo.create_mechanical_spawner.CreateMechanicalSpawner;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class LivingEntityHelper {
    public static void spawnLivingEntity(Level level, EntityType<?> entity, BlockPos pos) {
        Entity entitySpawn;
        if (level.f_46443_) {
            return;
        }
        if (entity == null) {
            LivingEntityHelper.spawnRandomLivingEntity(level, pos);
            return;
        }
        try {
            entitySpawn = entity.m_20615_(level);
        }
        catch (Exception exception) {
            CreateMechanicalSpawner.LOGGER.warn("Failed to create mob", (Throwable)exception);
            return;
        }
        assert (entitySpawn != null);
        entitySpawn.m_7678_((double)pos.m_123341_() + 0.51, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.51, level.m_213780_().m_188501_() * 360.0f, 0.0f);
        if (!(entitySpawn instanceof Mob)) {
            return;
        }
        Mob mob = (Mob)entitySpawn;
        if (mob.m_6914_((LevelReader)level)) {
            level.m_7967_((Entity)mob);
        }
    }

    public static void spawnRandomLivingEntity(Level level, BlockPos pos) {
        Optional spawn = ((Biome)level.m_204166_(pos).m_203334_()).m_47518_().m_151798_(MobCategory.MONSTER).m_216829_(level.m_213780_());
        if (spawn.isPresent()) {
            Entity entity;
            Object spawngroupdata = null;
            try {
                entity = ((MobSpawnSettings.SpawnerData)spawn.get()).f_48404_.m_20615_(level);
            }
            catch (Exception exception) {
                CreateMechanicalSpawner.LOGGER.warn("Failed to create mob", (Throwable)exception);
                return;
            }
            assert (entity != null);
            entity.m_7678_((double)pos.m_123341_() + 0.51, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.51, level.m_213780_().m_188501_() * 360.0f, 0.0f);
            if (!(entity instanceof Mob)) {
                return;
            }
            Mob mob = (Mob)entity;
            if (mob.m_6914_((LevelReader)level)) {
                level.m_7967_((Entity)mob);
            }
        }
    }

    public static Entity createEntity(ServerLevel pLevel, EntityType<?> pEntityType, BlockPos pPos) {
        if (pEntityType == null) {
            Optional spawn = ((Biome)pLevel.m_204166_(pPos).m_203334_()).m_47518_().m_151798_(MobCategory.MONSTER).m_216829_(pLevel.m_213780_());
            try {
                Entity entity = ((MobSpawnSettings.SpawnerData)spawn.get()).f_48404_.m_20615_((Level)pLevel);
                return entity;
            }
            catch (Exception exception) {
                CreateMechanicalSpawner.LOGGER.warn("Failed to create random mob", (Throwable)exception);
                return null;
            }
        }
        try {
            Entity entity = pEntityType.m_20615_((Level)pLevel);
            return entity;
        }
        catch (Exception exception) {
            CreateMechanicalSpawner.LOGGER.warn("Failed to create mob", (Throwable)exception);
            return null;
        }
    }

    public static List<ItemStack> getLootFromMob(ServerLevel pLevel, Entity entity, BlockPos pSpawnPos, DeployerFakePlayer pFakePlayer) {
        if (!(entity instanceof Mob)) {
            return List.of();
        }
        Mob mob = (Mob)entity;
        ResourceLocation resourceLocation = mob.m_5743_();
        DeployerFakePlayer fakePlayer = new DeployerFakePlayer(pLevel, pFakePlayer.m_20148_());
        DamageSource damageSource = pLevel.m_269111_().m_269075_((Player)fakePlayer);
        LootParams.Builder builder = new LootParams.Builder(pLevel);
        builder.m_287286_(LootContextParams.f_81460_, (Object)pSpawnPos.m_252807_());
        builder.m_287239_(3.0f).m_287286_(LootContextParams.f_81455_, (Object)entity).m_287286_(LootContextParams.f_81460_, (Object)entity.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)damageSource).m_287289_(LootContextParams.f_81458_, (Object)fakePlayer).m_287289_(LootContextParams.f_81459_, (Object)damageSource.m_7640_());
        builder = builder.m_287286_(LootContextParams.f_81456_, (Object)fakePlayer);
        LootParams params = builder.m_287235_(LootContextParamSet.m_165477_().m_81405_());
        LootTable table = pLevel.m_7654_().m_278653_().m_278676_(resourceLocation);
        return table.m_287195_(params);
    }
}

