/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.command;

import com.hlysine.create_power_loader.content.AbstractChunkLoaderBlockEntity;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.ChunkLoaderMovementBehaviour;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import com.hlysine.create_power_loader.content.WeakCollection;
import com.hlysine.create_power_loader.content.trains.CarriageChunkLoader;
import com.hlysine.create_power_loader.content.trains.StationChunkLoader;
import com.hlysine.create_power_loader.content.trains.TrainChunkLoader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class SummaryCommand {
    private static int white = ChatFormatting.WHITE.m_126665_();
    private static int gray = ChatFormatting.GRAY.m_126665_();
    private static int blue = 13885148;

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"summary").requires(cs -> cs.m_6761_(2))).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            SummaryCommand.fillReport((ResourceLocation)ctx.getArgument("dimension", ResourceLocation.class), (s, f) -> source.m_288197_(() -> Component.m_237113_((String)s).m_130938_(st -> st.m_178520_(f.intValue())), false), c -> source.m_288197_(() -> c, false));
            return 1;
        }))).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            SummaryCommand.fillReport(null, (s, f) -> source.m_288197_(() -> Component.m_237113_((String)s).m_130938_(st -> st.m_178520_(f.intValue())), false), c -> source.m_288197_(() -> c, false));
            return 1;
        });
    }

    private static void fillReport(@Nullable ResourceLocation dimension, BiConsumer<String, Integer> chat, Consumer<Component> chatRaw) {
        LinkedList<ChunkLoader> loaders = new LinkedList<ChunkLoader>();
        for (WeakCollection<ChunkLoader> list : ChunkLoadManager.allLoaders.values()) {
            loaders.addAll(list);
        }
        if (dimension != null) {
            loaders.removeIf(loader -> !((ResourceLocation)loader.getLocation().getFirst()).equals((Object)dimension));
        }
        chat.accept("", white);
        chat.accept("-+------<< Chunk Loader Summary >>------+-", white);
        if (dimension != null) {
            chat.accept("For " + dimension, gray);
        }
        SummaryCommand.genSummary(null, loaders, chat, chatRaw);
        chat.accept("", white);
        chat.accept("-+------------------------------------+-", white);
    }

    private static void genSummary(@Nullable LoaderMode mode, List<ChunkLoader> loaders, BiConsumer<String, Integer> chat, Consumer<Component> chatRaw) {
        if (mode == LoaderMode.STATIC || mode == null) {
            chat.accept("", white);
            chat.accept("Static chunk loaders", white);
            int staticLoaders = 0;
            int functional = 0;
            int brass = 0;
            int andesite = 0;
            HashSet<ChunkLoadManager.LoadedChunkPos> chunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();
            for (ChunkLoader loader2 : loaders) {
                if (!(loader2 instanceof AbstractChunkLoaderBlockEntity)) continue;
                AbstractChunkLoaderBlockEntity be = (AbstractChunkLoaderBlockEntity)loader2;
                ++staticLoaders;
                if (be.getForcedChunks().size() > 0) {
                    ++functional;
                }
                if (be.type == LoaderType.BRASS) {
                    ++brass;
                } else if (be.type == LoaderType.ANDESITE) {
                    ++andesite;
                }
                chunks.addAll(be.getForcedChunks());
            }
            chatRaw.accept((Component)SummaryCommand.line("Total blocks", staticLoaders));
            chatRaw.accept((Component)SummaryCommand.line("Functional blocks", functional));
            chatRaw.accept((Component)SummaryCommand.line("Brass loaders", brass));
            chatRaw.accept((Component)SummaryCommand.line("Andesite loaders", andesite));
            chatRaw.accept((Component)SummaryCommand.line("Loaded chunks", chunks.size()));
        }
        if (mode == LoaderMode.CONTRAPTION || mode == null) {
            chat.accept("", white);
            chat.accept("Contraption chunk loaders", white);
            int nonTrain = 0;
            HashSet<ChunkLoadManager.LoadedChunkPos> chunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();
            for (ChunkLoader loader3 : loaders) {
                if (!(loader3 instanceof ChunkLoaderMovementBehaviour.SavedState)) continue;
                ChunkLoaderMovementBehaviour.SavedState state = (ChunkLoaderMovementBehaviour.SavedState)loader3;
                if (!state.isTrain) {
                    ++nonTrain;
                }
                chunks.addAll(state.forcedChunks);
            }
            chatRaw.accept((Component)SummaryCommand.line("Non-train contraptions", nonTrain));
            chatRaw.accept((Component)SummaryCommand.line("Loaded chunks", chunks.size()));
        }
        if (mode == LoaderMode.TRAIN || mode == null) {
            chat.accept("", white);
            chat.accept("Train chunk loaders", white);
            int trains = 0;
            int carriages = 0;
            int functionalTrains = 0;
            int functionalCarriages = 0;
            int unknown = 0;
            int brassAndAndesite = 0;
            int brass = 0;
            int andesite = 0;
            HashSet<ChunkLoadManager.LoadedChunkPos> chunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();
            for (ChunkLoader loader4 : loaders) {
                if (!(loader4 instanceof TrainChunkLoader)) continue;
                TrainChunkLoader train = (TrainChunkLoader)loader4;
                ++trains;
                carriages += train.carriageLoaders.size();
                if (train.getForcedChunks().size() > 0) {
                    ++functionalTrains;
                }
                for (CarriageChunkLoader carriage : train.carriageLoaders) {
                    if (carriage.getForcedChunks().size() > 0) {
                        ++functionalCarriages;
                    }
                    if (!carriage.known) {
                        ++unknown;
                    } else if (carriage.brass && carriage.andesite) {
                        ++brassAndAndesite;
                    } else if (carriage.brass) {
                        ++brass;
                    } else if (carriage.andesite) {
                        ++andesite;
                    }
                    chunks.addAll(carriage.getForcedChunks());
                }
            }
            chatRaw.accept((Component)SummaryCommand.line("Total trains", trains));
            chatRaw.accept((Component)SummaryCommand.line("Total carriages", carriages));
            chatRaw.accept((Component)SummaryCommand.line("Functional trains", functionalTrains));
            chatRaw.accept((Component)SummaryCommand.line("Functional carriages", functionalCarriages));
            chatRaw.accept((Component)SummaryCommand.line("Unknown carriages", unknown));
            chatRaw.accept((Component)SummaryCommand.line("Brass+Andesite carriages", brassAndAndesite));
            chatRaw.accept((Component)SummaryCommand.line("Brass carriages", brass));
            chatRaw.accept((Component)SummaryCommand.line("Andesite carriages", andesite));
            chatRaw.accept((Component)SummaryCommand.line("Loaded chunks", chunks.size()));
        }
        if (mode == LoaderMode.STATION || mode == null) {
            chat.accept("", white);
            chat.accept("Station chunk loaders", white);
            int stations = 0;
            int attachments = 0;
            int activeStations = 0;
            int activeAttachments = 0;
            int brass = 0;
            int andesite = 0;
            HashSet<ChunkLoadManager.LoadedChunkPos> chunks = new HashSet<ChunkLoadManager.LoadedChunkPos>();
            for (ChunkLoader loader5 : loaders) {
                if (!(loader5 instanceof StationChunkLoader)) continue;
                StationChunkLoader station = (StationChunkLoader)loader5;
                ++stations;
                attachments += station.attachments.size();
                if (station.getForcedChunks().size() > 0) {
                    ++activeStations;
                    activeAttachments += station.attachments.size();
                }
                for (StationChunkLoader.AttachedLoader attachment : station.attachments) {
                    if (attachment.type() == LoaderType.ANDESITE) {
                        ++andesite;
                        continue;
                    }
                    if (attachment.type() != LoaderType.BRASS) continue;
                    ++brass;
                }
                chunks.addAll(station.getForcedChunks());
            }
            chatRaw.accept((Component)SummaryCommand.line("Total stations", stations));
            chatRaw.accept((Component)SummaryCommand.line("Total attachments", attachments));
            chatRaw.accept((Component)SummaryCommand.line("Active stations", activeStations));
            chatRaw.accept((Component)SummaryCommand.line("Active attachments", activeAttachments));
            chatRaw.accept((Component)SummaryCommand.line("Brass attachments", brass));
            chatRaw.accept((Component)SummaryCommand.line("Andesite attachments", andesite));
            chatRaw.accept((Component)SummaryCommand.line("Loaded chunks", chunks.size()));
        }
        if (mode == null) {
            chat.accept("", white);
            chat.accept("All chunk loaders", white);
            chatRaw.accept((Component)SummaryCommand.line("Total units", loaders.size()));
            HashSet allChunks = new HashSet();
            loaders.forEach(loader -> allChunks.addAll(loader.getForcedChunks()));
            chatRaw.accept((Component)SummaryCommand.line("Total chunks", allChunks.size()));
        }
    }

    private static MutableComponent text(String text, int color) {
        return Component.m_237113_((String)text).m_130938_(style -> style.m_178520_(color));
    }

    private static MutableComponent line(String label, Object value) {
        return SummaryCommand.text("    ", gray).m_7220_((Component)SummaryCommand.text(label + ": ", gray)).m_7220_((Component)SummaryCommand.text(String.valueOf(value), blue));
    }
}

