/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_power_loader.content;

import com.hlysine.create_power_loader.config.CPLConfigs;
import com.hlysine.create_power_loader.content.ChunkLoadManager;
import com.hlysine.create_power_loader.content.ChunkLoader;
import com.hlysine.create_power_loader.content.ContraptionRenderer;
import com.hlysine.create_power_loader.content.LoaderMode;
import com.hlysine.create_power_loader.content.LoaderType;
import com.mojang.logging.LogUtils;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import java.util.HashSet;
import java.util.Set;
import net.createmod.catnip.data.Pair;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChunkLoaderMovementBehaviour
implements MovementBehaviour {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final LoaderType type;

    public ChunkLoaderMovementBehaviour(LoaderType type) {
        this.type = type;
    }

    public void startMoving(MovementContext context) {
        if (context.world.f_46443_ || !(context.world instanceof ServerLevel)) {
            return;
        }
        if (context.contraption.entity == null) {
            return;
        }
        Object tempState = context.temporaryData;
        if (!(tempState instanceof SavedState)) {
            tempState = new SavedState(this.type, null, null, context.contraption instanceof CarriageContraption, new HashSet<ChunkLoadManager.LoadedChunkPos>());
        }
        SavedState savedState = (SavedState)tempState;
        savedState.chunkPos = null;
        context.temporaryData = savedState;
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        if (context.world.f_46443_ || !(context.world instanceof ServerLevel)) {
            return;
        }
        if (context.contraption.entity == null) {
            return;
        }
        ChunkLoadManager.LoadedChunkPos entityChunkPos = new ChunkLoadManager.LoadedChunkPos(context.world.m_46472_().m_135782_(), context.contraption.entity.m_146902_());
        BlockPos entityBlockPos = context.contraption.entity.m_20183_();
        Object tempState = context.temporaryData;
        if (!(tempState instanceof SavedState)) {
            context.temporaryData = tempState = new SavedState(this.type, null, null, context.contraption instanceof CarriageContraption, new HashSet<ChunkLoadManager.LoadedChunkPos>());
        }
        SavedState savedState = (SavedState)tempState;
        if (entityChunkPos.equals(savedState.chunkPos)) {
            return;
        }
        savedState.chunkPos = entityChunkPos;
        savedState.blockPos = entityBlockPos;
        if (this.shouldFunction(context)) {
            ChunkLoadManager.updateForcedChunks(context.world.m_7654_(), entityChunkPos, context.contraption.entity.m_20148_(), (int)((Integer)CPLConfigs.server().getFor((LoaderType)savedState.loaderType).rangeOnContraption.get()), savedState.forcedChunks);
            LOGGER.debug("CPL: Entity {} at new chunk {}, loaded {} chunks", new Object[]{context.contraption.entity, entityChunkPos, savedState.forcedChunks.size()});
        } else {
            ChunkLoadManager.unforceAllChunks(context.world.m_7654_(), context.contraption.entity.m_20148_(), savedState.forcedChunks);
        }
        context.temporaryData = savedState;
    }

    public void tick(MovementContext context) {
        if (context.world.f_46443_ || !(context.world instanceof ServerLevel)) {
            return;
        }
        if (context.contraption.entity == null) {
            return;
        }
        ResourceLocation dimension = context.world.m_46472_().m_135782_();
        ChunkLoadManager.LoadedChunkPos entityChunkPos = new ChunkLoadManager.LoadedChunkPos(dimension, context.contraption.entity.m_146902_());
        BlockPos entityBlockPos = context.contraption.entity.m_20183_();
        Object tempState = context.temporaryData;
        if (!(tempState instanceof SavedState)) {
            context.temporaryData = tempState = new SavedState(this.type, entityChunkPos, entityBlockPos, context.contraption instanceof CarriageContraption, new HashSet<ChunkLoadManager.LoadedChunkPos>());
            SavedState savedState = (SavedState)tempState;
            Set<ChunkLoadManager.LoadedChunkPos> savedForcedChunks = ChunkLoadManager.getSavedForcedChunks(context.contraption.entity.m_20148_());
            if (savedForcedChunks != null) {
                ((SavedState)tempState).forcedChunks.addAll(savedForcedChunks);
                LOGGER.debug("CPL: Entity {} reclaimed {} chunks", (Object)context.contraption.entity, (Object)savedForcedChunks.size());
            }
            if (this.shouldFunction(context)) {
                ChunkLoadManager.updateForcedChunks(context.world.m_7654_(), entityChunkPos, context.contraption.entity.m_20148_(), (int)((Integer)CPLConfigs.server().getFor((LoaderType)savedState.loaderType).rangeOnContraption.get()), savedState.forcedChunks);
                LOGGER.debug("CPL: Entity {} starts moving at chunk {}, loaded {} chunks", new Object[]{context.contraption.entity, entityChunkPos, savedState.forcedChunks.size()});
            } else {
                ChunkLoadManager.unforceAllChunks(context.world.m_7654_(), context.contraption.entity.m_20148_(), savedState.forcedChunks);
            }
            savedState.chunkPos = entityChunkPos;
            savedState.blockPos = entityBlockPos;
        }
    }

    public void stopMoving(MovementContext context) {
        if (context.world.f_46443_ || !(context.world instanceof ServerLevel)) {
            return;
        }
        if (context.contraption.entity == null) {
            return;
        }
        Object tempState = context.temporaryData;
        if (!(tempState instanceof SavedState)) {
            return;
        }
        SavedState savedState = (SavedState)tempState;
        if (this.shouldFunction(context)) {
            LOGGER.debug("CPL: Entity {} stops moving in {}, unloaded {} chunks", new Object[]{context.contraption.entity, savedState.chunkPos, savedState.forcedChunks.size()});
        }
        ChunkLoadManager.unforceAllChunks(context.world.m_7654_(), context.contraption.entity.m_20148_(), savedState.forcedChunks);
        savedState.chunkPos = null;
        savedState.blockPos = null;
        savedState.removeFromManager();
        context.temporaryData = null;
    }

    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        ContraptionRenderer.renderInContraption(context, renderWorld, matrices, buffer, this.type);
    }

    private boolean shouldFunction(MovementContext context) {
        if (context.contraption instanceof CarriageContraption) {
            return false;
        }
        return (Boolean)CPLConfigs.server().getFor((LoaderType)this.type).enableContraption.get();
    }

    public static class SavedState
    implements ChunkLoader {
        private final LoaderType loaderType;
        @Nullable
        public ChunkLoadManager.LoadedChunkPos chunkPos;
        @Nullable
        public BlockPos blockPos;
        public final boolean isTrain;
        public Set<ChunkLoadManager.LoadedChunkPos> forcedChunks;
        public boolean registered = false;

        public SavedState(LoaderType type, @Nullable ChunkLoadManager.LoadedChunkPos chunkPos, @Nullable BlockPos blockPos, boolean isTrain, Set<ChunkLoadManager.LoadedChunkPos> forcedChunks) {
            this.loaderType = type;
            this.chunkPos = chunkPos;
            this.blockPos = blockPos;
            this.isTrain = isTrain;
            this.forcedChunks = forcedChunks;
            this.addToManager();
        }

        @Override
        @NotNull
        public Set<ChunkLoadManager.LoadedChunkPos> getForcedChunks() {
            return this.forcedChunks;
        }

        @Override
        public LoaderMode getLoaderMode() {
            return LoaderMode.CONTRAPTION;
        }

        @Override
        public LoaderType getLoaderType() {
            return this.loaderType;
        }

        @Override
        public void addToManager() {
            if (!this.isTrain) {
                ChunkLoader.super.addToManager();
            }
        }

        @Override
        @Nullable
        public Pair<ResourceLocation, BlockPos> getLocation() {
            if (this.chunkPos == null || this.blockPos == null) {
                return null;
            }
            return Pair.of((Object)this.chunkPos.dimension(), (Object)this.blockPos);
        }
    }
}

