/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.index;

import java.util.LinkedList;
import java.util.List;
import net.createcobblestone.CreateCobblestoneMod;
import net.createcobblestone.data.GeneratorType;
import net.createcobblestone.index.Blocks;
import net.createcobblestone.index.Config;
import net.createcobblestone.index.CreativeTabs;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;

public final class RegistrateDisplayItemsGenerator
implements CreativeModeTab.DisplayItemsGenerator {
    private final CreativeTabs.Tabs tab;

    public RegistrateDisplayItemsGenerator(CreativeTabs.Tabs tab) {
        this.tab = tab;
    }

    public void m_257865_(CreativeModeTab.ItemDisplayParameters pParameters, CreativeModeTab.Output output) {
        ResourceKey<CreativeModeTab> tab = this.tab.getKey();
        LinkedList<ItemStack> stacks = new LinkedList<ItemStack>();
        ItemStack stack = Blocks.MECHANICAL_GENERATOR_BLOCK.asStack();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", GeneratorType.NONE.getId());
        stack.m_41700_("BlockEntityTag", (Tag)tag);
        stacks.add(stack);
        for (GeneratorType type : GeneratorType.getTypes()) {
            if (type == GeneratorType.NONE) continue;
            stack = Blocks.MECHANICAL_GENERATOR_BLOCK.asStack();
            tag = new CompoundTag();
            tag.m_128359_("type", type.getId());
            stack.m_41700_("BlockEntityTag", (Tag)tag);
            stacks.add(stack);
            if (!((Boolean)Config.common().enableDebugLogging.get()).booleanValue()) continue;
            CreateCobblestoneMod.LOGGER.info("Added {} generator to creative menu", (Object)type.getId());
        }
        RegistrateDisplayItemsGenerator.outputAll(output, stacks);
    }

    private static void outputAll(CreativeModeTab.Output output, List<ItemStack> stacks) {
        for (ItemStack stack : stacks) {
            if (stack.m_41613_() != 1) {
                CreateCobblestoneMod.LOGGER.error("Invalid stack size {} for stack {}.", (Object)stack.m_41613_(), (Object)stack);
                continue;
            }
            output.m_246267_(stack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public record TabInfo(ResourceKey<CreativeModeTab> key, CreativeModeTab tab) {
    }
}

