/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.jei;

import com.jesz.createdieselgenerators.CDGBlocks;
import com.jesz.createdieselgenerators.compat.jei.AnimatedDieselEngineElement;
import com.jesz.createdieselgenerators.compat.jei.DieselEngineJeiRecipeType;
import com.jesz.createdieselgenerators.content.diesel_engine.normal.DieselEngineBlock;
import com.jesz.createdieselgenerators.fuel_type.FuelTypeManager;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.fluids.FluidStack;

@ParametersAreNonnullByDefault
public class DieselEngineCategory
implements IRecipeCategory<DieselEngineJeiRecipeType> {
    IGuiHelper guiHelper;
    AnimatedDieselEngineElement engine = new AnimatedDieselEngineElement();

    public DieselEngineCategory(IGuiHelper helper) {
        this.guiHelper = helper;
    }

    public RecipeType<DieselEngineJeiRecipeType> getRecipeType() {
        return DieselEngineJeiRecipeType.DIESEL_COMBUSTION;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"createdieselgenerators.recipe.diesel_combustion");
    }

    public IDrawable getBackground() {
        return new EmptyBackground(177, 70);
    }

    public IDrawable getIcon() {
        return this.guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)CDGBlocks.DIESEL_ENGINE.asStack());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DieselEngineJeiRecipeType recipe, IFocusGroup iFocusGroup) {
        CreateRecipeCategory.addFluidSlot((IRecipeLayoutBuilder)builder, (int)10, (int)10, (FluidStack)new FluidStack(recipe.fluid, 1000));
    }

    public void draw(DieselEngineJeiRecipeType recipe, IRecipeSlotsView iRecipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        AllGuiTextures.JEI_ARROW.render(graphics, 82, 40);
        AllGuiTextures.JEI_SHADOW.render(graphics, 28, 52);
        byte enginesEnabled = (byte)((DieselEngineBlock.EngineTypes.NORMAL.enabled() ? 1 : 0) + (DieselEngineBlock.EngineTypes.MODULAR.enabled() ? 1 : 0) + (DieselEngineBlock.EngineTypes.HUGE.enabled() ? 1 : 0));
        int currentEngineIndex = AnimationTickHolder.getTicks() % 120 / 20;
        List<DieselEngineBlock.EngineTypes> enabledEngines = Arrays.stream(DieselEngineBlock.EngineTypes.values()).filter(DieselEngineBlock.EngineTypes::enabled).toList();
        DieselEngineBlock.EngineTypes currentEngine = enabledEngines.get(currentEngineIndex % enginesEnabled);
        float currentSpeed = FuelTypeManager.getGeneratedSpeed(currentEngine, recipe.fluid);
        float currentCapacity = FuelTypeManager.getGeneratedStress(currentEngine, recipe.fluid);
        float currentBurn = FuelTypeManager.getBurnRate(currentEngine, recipe.fluid);
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)CreateLang.number((double)currentBurn).component().m_7220_((Component)Component.m_237115_((String)"createdieselgenerators.generic.unit.mbps")), 5, 40, 0x888888, false);
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)CreateLang.number((double)(currentCapacity / currentSpeed)).component().m_130946_("x").m_7220_((Component)Component.m_237115_((String)"create.generic.unit.rpm")), 125, 41, 0x888888, false);
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)CreateLang.number((double)currentSpeed).component().m_7220_((Component)Component.m_237115_((String)"create.generic.unit.rpm")), 85, 33, 0x888888, false);
        graphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)CreateLang.number((double)currentCapacity).component().m_7220_((Component)Component.m_237115_((String)"create.generic.unit.stress")), 81, 50, 0x888888, false);
        this.engine.draw(graphics, 47, 62);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 40, 15);
    }
}

