/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.data.group;

import com.illusivesoulworks.diet.DietCommonMod;
import com.illusivesoulworks.diet.api.type.IDietGroup;
import com.illusivesoulworks.diet.api.util.DietColor;
import com.illusivesoulworks.diet.platform.Services;
import java.util.Objects;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public final class DietGroup
implements IDietGroup {
    private final String name;
    private final Item icon;
    private final DietColor color;
    private final float defaultValue;
    private final int order;
    private final double gainMultiplier;
    private final double decayMultiplier;
    private final boolean beneficial;
    private final TagKey<Item> tag;

    private DietGroup(Builder builder) {
        this.name = builder.name;
        this.icon = builder.icon;
        this.color = builder.color;
        this.defaultValue = builder.defaultValue;
        this.order = builder.order;
        this.gainMultiplier = builder.gainMultiplier;
        this.decayMultiplier = builder.decayMultiplier;
        this.beneficial = builder.beneficial;
        this.tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)DietCommonMod.resource(this.name));
    }

    public static IDietGroup load(CompoundTag tag) {
        String name = tag.m_128461_("Name");
        String icon = tag.m_128461_("Icon");
        Item item = Services.REGISTRY.getItem(new ResourceLocation(icon)).orElse(null);
        int order = tag.m_128451_("Order");
        boolean beneficial = tag.m_128471_("Beneficial");
        int color = tag.m_128451_("Color");
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        Builder builder = new Builder(name);
        builder.icon(item);
        builder.order(order);
        builder.beneficial(beneficial);
        builder.color(new DietColor(r, g, b));
        builder.gainMultiplier((float)tag.m_128459_("Gain"));
        builder.decayMultiplier((float)tag.m_128459_("Decay"));
        return builder.build();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Item getIcon() {
        return this.icon;
    }

    @Override
    public DietColor getColor() {
        return this.color;
    }

    @Override
    public float getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public double getGainMultiplier() {
        return this.gainMultiplier;
    }

    @Override
    public double getDecayMultiplier() {
        return this.decayMultiplier;
    }

    @Override
    public boolean isBeneficial() {
        return this.beneficial;
    }

    @Override
    public TagKey<Item> getTag() {
        return this.tag;
    }

    @Override
    public boolean contains(ItemStack stack) {
        return stack.m_204117_(this.tag);
    }

    @Override
    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("Name", this.name);
        tag.m_128359_("Icon", Services.REGISTRY.getItemKey(this.icon).toString());
        tag.m_128405_("Order", this.order);
        tag.m_128379_("Beneficial", this.beneficial);
        tag.m_128405_("Color", this.color.getRGB());
        tag.m_128347_("Gain", this.gainMultiplier);
        tag.m_128347_("Decay", this.decayMultiplier);
        return tag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DietGroup dietGroup = (DietGroup)o;
        return this.name.equals(dietGroup.name);
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public static class Builder {
        private final String name;
        private Item icon = Items.f_41852_;
        private DietColor color = new DietColor(255, 255, 255);
        private float defaultValue = 0.0f;
        private int order = 1;
        private float gainMultiplier = 1.0f;
        private float decayMultiplier = 1.0f;
        private boolean beneficial = true;

        public Builder(String name) {
            this.name = name;
        }

        public Builder icon(Item icon) {
            this.icon = icon;
            return this;
        }

        public Builder color(DietColor color) {
            this.color = color;
            return this;
        }

        public Builder defaultValue(float defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder order(int order) {
            this.order = order;
            return this;
        }

        public Builder gainMultiplier(float gainMultiplier) {
            this.gainMultiplier = gainMultiplier;
            return this;
        }

        public Builder decayMultiplier(float decayMultiplier) {
            this.decayMultiplier = decayMultiplier;
            return this;
        }

        public Builder beneficial(boolean beneficial) {
            this.beneficial = beneficial;
            return this;
        }

        public IDietGroup build() {
            return new DietGroup(this);
        }
    }
}

