/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.data.suite;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.illusivesoulworks.diet.DietConstants;
import com.illusivesoulworks.diet.api.type.IDietAttribute;
import com.illusivesoulworks.diet.api.type.IDietCondition;
import com.illusivesoulworks.diet.api.type.IDietStatusEffect;
import com.illusivesoulworks.diet.api.type.IDietSuite;
import com.illusivesoulworks.diet.common.data.effect.DietEffect;
import com.illusivesoulworks.diet.common.data.group.DietGroups;
import com.illusivesoulworks.diet.common.data.suite.DietSuite;
import com.illusivesoulworks.diet.platform.Services;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.level.Level;

public class DietSuites
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String UUID_PREFIX = "ea4130c8-9065-48a6-9207-ddc020fb9fc8";
    public static final DietSuites SERVER = Services.CAPABILITY.getSuitesListener();
    public static final DietSuites CLIENT = Services.CAPABILITY.getSuitesListener();
    private Map<String, IDietSuite> suites = new HashMap<String, IDietSuite>();
    private int uuidSuffix = 0;

    public DietSuites() {
        super(GSON, "diet/suites");
    }

    public static Optional<IDietSuite> getSuite(Level level, String name) {
        DietSuites instance = level.m_5776_() ? CLIENT : SERVER;
        return Optional.ofNullable(instance.suites.get(name));
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<String, IDietSuite> entry : this.suites.entrySet()) {
            tag.m_128365_(entry.getKey(), (Tag)entry.getValue().save());
        }
        return tag;
    }

    public void load(CompoundTag tag) {
        HashMap<String, IDietSuite> loaded = new HashMap<String, IDietSuite>();
        for (String key : tag.m_128431_()) {
            loaded.put(key, DietSuite.load((CompoundTag)Objects.requireNonNull(tag.m_128423_(key))));
        }
        this.suites = loaded;
    }

    public void sync(ServerPlayer player) {
        Services.NETWORK.sendDietSuitesS2C(player, this.save());
    }

    protected void apply(@Nonnull Map<ResourceLocation, JsonElement> object, @Nonnull ResourceManager resourceManager, @Nonnull ProfilerFiller profilerFiller) {
        ResourceLocation resourcelocation;
        HashMap<String, DietSuite.Builder> map = new HashMap<String, DietSuite.Builder>();
        this.uuidSuffix = 0;
        for (Map.Entry<ResourceLocation, JsonElement> entry2 : object.entrySet()) {
            resourcelocation = entry2.getKey();
            if (!resourcelocation.m_135827_().equals("diet")) continue;
            try {
                this.buildSuite(map.computeIfAbsent(resourcelocation.m_135815_(), DietSuite.Builder::new), GsonHelper.m_13918_((JsonElement)entry2.getValue(), (String)"top element"));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DietConstants.LOG.error("Parsing error loading diet suite {}", (Object)resourcelocation, (Object)e);
            }
        }
        for (Map.Entry<ResourceLocation, JsonElement> entry2 : object.entrySet()) {
            resourcelocation = entry2.getKey();
            if (resourcelocation.m_135815_().startsWith("_") || resourcelocation.m_135827_().equals("diet")) continue;
            try {
                this.buildSuite(map.computeIfAbsent(resourcelocation.m_135815_(), DietSuite.Builder::new), GsonHelper.m_13918_((JsonElement)entry2.getValue(), (String)"top element"));
            }
            catch (JsonParseException | IllegalArgumentException e) {
                DietConstants.LOG.error("Parsing error loading diet suite {}", (Object)resourcelocation, (Object)e);
            }
        }
        this.suites = (Map)map.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ((DietSuite.Builder)entry.getValue()).build()));
        DietConstants.LOG.info("Loaded {} diet suites", (Object)map.size());
    }

    private void buildSuite(DietSuite.Builder builder, JsonObject topElement) {
        boolean replace = GsonHelper.m_13855_((JsonObject)topElement, (String)"replace", (boolean)false);
        JsonArray empty = new JsonArray();
        JsonArray groups = GsonHelper.m_13832_((JsonObject)topElement, (String)"groups", (JsonArray)empty);
        if (replace) {
            builder.clear();
        }
        for (JsonElement group : groups) {
            DietGroups.SERVER.getGroup(group.getAsString()).ifPresent(builder::group);
        }
        JsonArray effects = GsonHelper.m_13832_((JsonObject)topElement, (String)"effects", (JsonArray)empty);
        for (JsonElement effect : effects) {
            Object condition2;
            JsonObject effectObject = effect.getAsJsonObject();
            JsonArray conditions = GsonHelper.m_13832_((JsonObject)effectObject, (String)"conditions", (JsonArray)empty);
            JsonArray attributes = GsonHelper.m_13832_((JsonObject)effectObject, (String)"attributes", (JsonArray)empty);
            JsonArray statusEffects = GsonHelper.m_13832_((JsonObject)effectObject, (String)"status_effects", (JsonArray)empty);
            if (conditions.size() == 0) {
                throw new IllegalArgumentException("Conditions cannot be empty!");
            }
            if (attributes.size() == 0 && statusEffects.size() == 0) {
                throw new IllegalArgumentException("Both attributes and status_effects cannot be empty!");
            }
            ArrayList<IDietCondition> finalConditions = new ArrayList<IDietCondition>();
            for (Object condition2 : conditions) {
                JsonObject conditionObject = condition2.getAsJsonObject();
                JsonArray conditionGroups = GsonHelper.m_13832_((JsonObject)conditionObject, (String)"groups", (JsonArray)empty);
                HashSet<String> set = new HashSet<String>();
                for (JsonElement conditionGroup : conditionGroups) {
                    set.add(conditionGroup.getAsString());
                }
                String match = GsonHelper.m_13851_((JsonObject)conditionObject, (String)"match", (String)"any");
                float above = GsonHelper.m_13820_((JsonObject)conditionObject, (String)"above", (float)0.0f);
                float below = GsonHelper.m_13820_((JsonObject)conditionObject, (String)"below", (float)1.0f);
                finalConditions.add(new DietEffect.DietCondition(set, DietEffect.MatchMethod.findOrDefault(match, DietEffect.MatchMethod.ANY), above, below));
            }
            ArrayList<IDietAttribute> finalAttributes = new ArrayList<IDietAttribute>();
            condition2 = attributes.iterator();
            while (condition2.hasNext()) {
                JsonElement attribute = (JsonElement)condition2.next();
                JsonObject attributeObject = attribute.getAsJsonObject();
                if (!attributeObject.has("name")) {
                    throw new IllegalArgumentException("Attribute requires a name!");
                }
                String name = GsonHelper.m_13906_((JsonObject)attributeObject, (String)"name");
                Services.REGISTRY.getAttribute(new ResourceLocation(name)).ifPresentOrElse(att -> {
                    float amount = GsonHelper.m_13820_((JsonObject)attributeObject, (String)"amount", (float)1.0f);
                    AttributeModifier.Operation op = DietSuites.getOperation(GsonHelper.m_13851_((JsonObject)attributeObject, (String)"operation", (String)""));
                    float increment = GsonHelper.m_13820_((JsonObject)attributeObject, (String)"increment", (float)amount);
                    finalAttributes.add(new DietEffect.DietAttribute((Attribute)att, op, amount, increment));
                }, () -> {
                    throw new IllegalArgumentException("Attribute " + name + " does not exist!");
                });
            }
            ArrayList<IDietStatusEffect> finalStatusEffects = new ArrayList<IDietStatusEffect>();
            for (JsonElement statusEffect : statusEffects) {
                JsonObject statusEffectObject = statusEffect.getAsJsonObject();
                if (!statusEffectObject.has("name")) {
                    throw new IllegalArgumentException("Status effect requires a name!");
                }
                String name = GsonHelper.m_13906_((JsonObject)statusEffectObject, (String)"name");
                Services.REGISTRY.getStatusEffect(new ResourceLocation(name)).ifPresentOrElse(eff -> {
                    int power = GsonHelper.m_13824_((JsonObject)statusEffectObject, (String)"power", (int)0);
                    int increment = GsonHelper.m_13824_((JsonObject)statusEffectObject, (String)"increment", (int)1);
                    finalStatusEffects.add(new DietEffect.DietStatusEffect((MobEffect)eff, power, increment));
                }, () -> {
                    throw new IllegalArgumentException("Attribute " + name + " does not exist!");
                });
            }
            UUID uuid = UUID.nameUUIDFromBytes((UUID_PREFIX + this.uuidSuffix).getBytes());
            ++this.uuidSuffix;
            builder.effect(new DietEffect(uuid, finalAttributes, finalStatusEffects, finalConditions));
        }
    }

    private static AttributeModifier.Operation getOperation(String name) {
        if (name.equals("multiply_total")) {
            return AttributeModifier.Operation.MULTIPLY_TOTAL;
        }
        if (name.equals("multiply_base")) {
            return AttributeModifier.Operation.MULTIPLY_BASE;
        }
        return AttributeModifier.Operation.ADDITION;
    }
}

