/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.utils.tradebox;

import java.util.Random;

public class GoodsRarity {
    public static final int NORMAL = 1;
    public static final int RARE = 2;
    public static final int SUPER_RARE = 3;
    public static final int UNIQUE = 4;
    public static final int DEFAULT_RARITY = 1;
    public static final int EMPTY_RARITY = 0;
    public static final int GOOD_FROM_LOCATION_RARITY_WEIGHT_SUM = GoodsRarity.getRarityWeight(1) + GoodsRarity.getRarityWeight(2) + GoodsRarity.getRarityWeight(3) + GoodsRarity.getRarityWeight(4);
    public static final int GOOD_TO_LOCATION_RARITY_WEIGHT_SUM = GoodsRarity.getRarityWeight(1) + GoodsRarity.getRarityWeight(2);

    public static int getRarityWeight(int rarity) {
        switch (rarity) {
            case 1: {
                return 49;
            }
            case 2: {
                return 30;
            }
            case 3: {
                return 15;
            }
            case 4: {
                return 6;
            }
        }
        return 49;
    }

    public static int genRandomRarity(int fromOrToLocation) {
        int sumWeight = fromOrToLocation == 1 ? GOOD_FROM_LOCATION_RARITY_WEIGHT_SUM : GOOD_TO_LOCATION_RARITY_WEIGHT_SUM;
        int point = new Random().nextInt(sumWeight) + 1;
        if (point <= GoodsRarity.getRarityWeight(1)) {
            return 1;
        }
        if (point > GoodsRarity.getRarityWeight(1) && point <= GoodsRarity.getRarityWeight(1) + GoodsRarity.getRarityWeight(2)) {
            return 2;
        }
        if (point > GoodsRarity.getRarityWeight(1) + GoodsRarity.getRarityWeight(2) && point <= GoodsRarity.getRarityWeight(1) + GoodsRarity.getRarityWeight(2) + GoodsRarity.getRarityWeight(3)) {
            return 3;
        }
        if (point > GoodsRarity.getRarityWeight(1) + GoodsRarity.getRarityWeight(2) + GoodsRarity.getRarityWeight(3)) {
            return 4;
        }
        return 1;
    }
}

