/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.functions;

import com.moepus.flerovium.functions.FastSimpleBakedModel;
import com.moepus.flerovium.functions.MathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import me.jellysquid.mods.sodium.client.model.color.interop.ItemColorsExtended;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.ColorARGB;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.caffeinemc.mods.sodium.api.vertex.format.common.ModelVertex;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import org.joml.Math;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class FastSimpleBakedModelRenderer {
    private static final MemoryStack STACK = MemoryStack.create();
    private static final int VERTEX_COUNT = 4;
    private static final int BUFFER_VERTEX_COUNT = 48;
    private static final int STRIDE = 8;
    private static final long SCRATCH_BUFFER;
    private static long BUFFER_PTR;
    private static int BUFFED_VERTEX;
    private static final int[] CUBE_NORMALS;
    private static int LAST_TINT_INDEX;
    private static int LAST_TINT;
    private static final int DONT_RENDER = -1;

    public static void prepareNormals(FastSimpleBakedModel model, PoseStack.Pose pose) {
        Matrix4f mat = pose.m_252922_();
        FastSimpleBakedModelRenderer.CUBE_NORMALS[0] = model.shouldRenderFace(Direction.DOWN) ? MathUtil.normal2Int(-mat.m10(), -mat.m11(), -mat.m12()) : -1;
        FastSimpleBakedModelRenderer.CUBE_NORMALS[1] = model.shouldRenderFace(Direction.UP) ? MathUtil.normal2Int(mat.m10(), mat.m11(), mat.m12()) : -1;
        FastSimpleBakedModelRenderer.CUBE_NORMALS[2] = model.shouldRenderFace(Direction.NORTH) ? MathUtil.normal2Int(-mat.m20(), -mat.m21(), -mat.m22()) : -1;
        FastSimpleBakedModelRenderer.CUBE_NORMALS[3] = model.shouldRenderFace(Direction.SOUTH) ? MathUtil.normal2Int(mat.m20(), mat.m21(), mat.m22()) : -1;
        FastSimpleBakedModelRenderer.CUBE_NORMALS[4] = model.shouldRenderFace(Direction.WEST) ? MathUtil.normal2Int(-mat.m00(), -mat.m01(), -mat.m02()) : -1;
        int n = FastSimpleBakedModelRenderer.CUBE_NORMALS[5] = model.shouldRenderFace(Direction.EAST) ? MathUtil.normal2Int(mat.m00(), mat.m01(), mat.m02()) : -1;
        if (model.isNeedExtraCulling()) {
            float scalar = 127.0f * Math.invsqrt((float)Math.fma((float)mat.m30(), (float)mat.m30(), (float)Math.fma((float)mat.m31(), (float)mat.m31(), (float)(mat.m32() * mat.m32()))));
            byte viewX = (byte)(mat.m30() * scalar);
            byte viewY = (byte)(mat.m31() * scalar);
            byte viewZ = (byte)(mat.m32() * scalar);
            for (int i = 0; i < 6; ++i) {
                if (CUBE_NORMALS[i] == -1 || !MathUtil.cullBackFace(viewX, viewY, viewZ, CUBE_NORMALS[i])) continue;
                FastSimpleBakedModelRenderer.CUBE_NORMALS[i] = -1;
            }
        }
    }

    private static int getQuadNormal(Matrix3f mat, int baked) {
        float factor = MathUtil.PACK_FACTOR[(baked & 0x808080) == 0 ? 0 : 1];
        int tmp = baked - 0x7E7E7F & 0xFDFDFD;
        if ((tmp & 0xFF0000) == 0) {
            return MathUtil.packSafe(mat.m20, mat.m21, mat.m22, factor);
        }
        if ((tmp & 0xFF) == 0) {
            return MathUtil.packSafe(mat.m00, mat.m01, mat.m02, factor);
        }
        if ((tmp & 0xFF00) == 0) {
            return MathUtil.packSafe(mat.m10, mat.m11, mat.m12, factor);
        }
        float unpackedX = NormI8.unpackX((int)baked);
        float unpackedY = NormI8.unpackY((int)baked);
        float unpackedZ = NormI8.unpackZ((int)baked);
        float x = MatrixHelper.transformNormalX((Matrix3f)mat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
        float y = MatrixHelper.transformNormalY((Matrix3f)mat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
        float z = MatrixHelper.transformNormalZ((Matrix3f)mat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
        return MathUtil.packSafe(x, y, z);
    }

    public static int multiplyIntBytes(int a, int b) {
        int first = ((a & 0xFF) * (b & 0xFF) + 127) / 255;
        int second = ((a >>> 8 & 0xFF) * (b >>> 8 & 0xFF) + 127) / 255;
        int third = ((a >>> 16 & 0xFF) * (b >>> 16 & 0xFF) + 127) / 255;
        return first | second << 8 | third << 16 | b & 0xFF000000;
    }

    private static void flush(VertexBufferWriter writer) {
        if (BUFFED_VERTEX == 0) {
            return;
        }
        STACK.push();
        writer.push(STACK, SCRATCH_BUFFER, BUFFED_VERTEX, ModelVertex.FORMAT);
        STACK.pop();
        BUFFER_PTR = SCRATCH_BUFFER;
        BUFFED_VERTEX = 0;
    }

    private static boolean isBufferMax() {
        return BUFFED_VERTEX >= 48;
    }

    private static void putBulkData(VertexBufferWriter writer, PoseStack.Pose pose, BakedQuad bakedQuad, int light, int overlay, int color) {
        int[] vertices = bakedQuad.m_111303_();
        if (vertices.length != 32) {
            return;
        }
        Matrix4f pose_matrix = pose.m_252922_();
        int n = FastSimpleBakedModelRenderer.getQuadNormal(pose.m_252943_(), vertices[7]);
        int c = color != -1 ? FastSimpleBakedModelRenderer.multiplyIntBytes(color, vertices[3]) : vertices[3];
        int baked = vertices[6];
        int l = Math.max((int)((baked & 0xFFFF) << 16 | baked >> 16), (int)light);
        long buffer = BUFFER_PTR;
        int READ_PTR = 0;
        long WRITE_PTR = buffer;
        for (int index = 0; index < 4; ++index) {
            float x = Float.intBitsToFloat(vertices[READ_PTR]);
            float y = Float.intBitsToFloat(vertices[READ_PTR + 1]);
            float z = Float.intBitsToFloat(vertices[READ_PTR + 2]);
            int u = vertices[READ_PTR + 4];
            int v = vertices[READ_PTR + 5];
            ModelVertex.write((long)WRITE_PTR, (float)MatrixHelper.transformPositionX((Matrix4f)pose_matrix, (float)x, (float)y, (float)z), (float)MatrixHelper.transformPositionY((Matrix4f)pose_matrix, (float)x, (float)y, (float)z), (float)MatrixHelper.transformPositionZ((Matrix4f)pose_matrix, (float)x, (float)y, (float)z), (int)c, (float)Float.intBitsToFloat(u), (float)Float.intBitsToFloat(v), (int)overlay, (int)l, (int)n);
            READ_PTR += 8;
            WRITE_PTR += 36L;
        }
        BUFFER_PTR = WRITE_PTR;
        BUFFED_VERTEX += 4;
        if (FastSimpleBakedModelRenderer.isBufferMax()) {
            FastSimpleBakedModelRenderer.flush(writer);
        }
    }

    public static int GetItemTint(int tintIndex, ItemStack itemStack, ItemColor colorProvider) {
        if (tintIndex == LAST_TINT_INDEX) {
            return LAST_TINT;
        }
        int tint = colorProvider.m_92671_(itemStack, tintIndex);
        LAST_TINT = ColorARGB.toABGR((int)tint, (int)255);
        LAST_TINT_INDEX = tintIndex;
        return LAST_TINT;
    }

    private static void renderQuadList(PoseStack.Pose pose, VertexBufferWriter writer, List<BakedQuad> bakedQuads, int light, int overlay, ItemStack itemStack, ItemColor colorProvider) {
        for (BakedQuad bakedQuad : bakedQuads) {
            int normal = CUBE_NORMALS[bakedQuad.m_111306_().ordinal()];
            if (normal == -1) continue;
            int color = colorProvider != null && bakedQuad.m_111305_() != -1 ? FastSimpleBakedModelRenderer.GetItemTint(bakedQuad.m_111305_(), itemStack, colorProvider) : -1;
            FastSimpleBakedModelRenderer.putBulkData(writer, pose, bakedQuad, light, overlay, color);
        }
        if (pose.m_252922_().m32() > -8.0f) {
            for (BakedQuad bakedQuad : bakedQuads) {
                SpriteUtil.markSpriteActive((TextureAtlasSprite)bakedQuad.m_173410_());
            }
        }
    }

    public static void render(FastSimpleBakedModel model, ItemStack itemStack, int packedLight, int packedOverlay, PoseStack poseStack, VertexBufferWriter writer, ItemColors itemColors) {
        PoseStack.Pose pose = poseStack.m_85850_();
        FastSimpleBakedModelRenderer.prepareNormals(model, pose);
        ItemColor colorProvider = !itemStack.m_41619_() ? ((ItemColorsExtended)itemColors).sodium$getColorProvider(itemStack) : null;
        LAST_TINT = -1;
        LAST_TINT_INDEX = -1;
        for (Direction direction : Direction.values()) {
            FastSimpleBakedModelRenderer.renderQuadList(pose, writer, model.m_213637_(null, direction, null), packedLight, packedOverlay, itemStack, colorProvider);
        }
        FastSimpleBakedModelRenderer.renderQuadList(pose, writer, model.m_213637_(null, null, null), packedLight, packedOverlay, itemStack, colorProvider);
        FastSimpleBakedModelRenderer.flush(writer);
    }

    static {
        BUFFER_PTR = SCRATCH_BUFFER = MemoryUtil.nmemAlignedAlloc((long)64L, (long)1728L);
        BUFFED_VERTEX = 0;
        CUBE_NORMALS = new int[Direction.values().length];
        LAST_TINT_INDEX = -1;
        LAST_TINT = -1;
    }
}

