/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.flerovium.mixins.Chunk;

import com.moepus.flerovium.functions.Chunk.Occlusion;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.occlusion.OcclusionCuller;
import me.jellysquid.mods.sodium.client.render.chunk.occlusion.VisibilityEncoding;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import me.jellysquid.mods.sodium.client.util.collections.ReadQueue;
import me.jellysquid.mods.sodium.client.util.collections.WriteQueue;
import net.minecraft.core.SectionPos;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={OcclusionCuller.class}, remap=false)
public abstract class OcclusionCullerMixin {
    @Shadow
    private static boolean isSectionVisible(RenderSection section, Viewport viewport, float searchDistance) {
        return false;
    }

    @Shadow
    private static int getOutwardDirections(SectionPos origin, RenderSection section) {
        return 0;
    }

    @Shadow
    private static void visitNeighbors(WriteQueue<RenderSection> queue, RenderSection section, int outgoing, int frame) {
    }

    @Overwrite
    private static void processQueue(OcclusionCuller.Visitor visitor, Viewport viewport, float searchDistance, boolean useOcclusionCulling, int frame, ReadQueue<RenderSection> readQueue, WriteQueue<RenderSection> writeQueue) {
        RenderSection section;
        while ((section = (RenderSection)readQueue.dequeue()) != null) {
            boolean visible = OcclusionCullerMixin.isSectionVisible(section, viewport, searchDistance);
            visitor.visit(section, visible);
            if (!visible) continue;
            if (useOcclusionCulling) {
                long visibilityData = OcclusionCullerMixin.flerovium$processVisibilityByAngleOcculusion(viewport, section, section.getVisibilityData());
                connections = VisibilityEncoding.getConnections((long)visibilityData, (int)section.getIncomingDirections());
            } else {
                connections = 63;
            }
            OcclusionCullerMixin.visitNeighbors(writeQueue, section, connections &= OcclusionCullerMixin.getOutwardDirections(viewport.getChunkCoord(), section), frame);
        }
    }

    @Unique
    private static long flerovium$processVisibilityByAngleOcculusion(Viewport viewport, RenderSection section, long visibilityData) {
        double dx = Math.abs(viewport.getTransform().x - (double)section.getCenterX());
        double dy = Math.abs(viewport.getTransform().y - (double)section.getCenterY());
        double dz = Math.abs(viewport.getTransform().z - (double)section.getCenterZ());
        long mask = 0L;
        if (dx < dy || dx < dz) {
            mask |= Occlusion.ThroughEastWest;
        }
        if (dy < dx || dy < dz) {
            mask |= Occlusion.ThroughUpDown;
        }
        if (dz < dx || dz < dy) {
            mask |= Occlusion.ThroughNorthSouth;
        }
        return visibilityData & (mask ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

