/*
 * Decompiled with CFR 0.152.
 */
package immersive_paintings.network;

import immersive_paintings.client.gui.ImmersivePaintingScreen;
import immersive_paintings.cobalt.network.NetworkHandler;
import immersive_paintings.entity.ImmersivePaintingEntity;
import immersive_paintings.network.NetworkManager;
import immersive_paintings.network.c2s.PaintingModifyRequest;
import immersive_paintings.network.s2c.OpenGuiRequest;
import immersive_paintings.network.s2c.PaintingListMessage;
import immersive_paintings.network.s2c.PaintingModifyMessage;
import immersive_paintings.network.s2c.RegisterPaintingResponse;
import immersive_paintings.resources.ClientPaintingManager;
import immersive_paintings.resources.Painting;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ClientNetworkManager
implements NetworkManager {
    @Override
    public void handleOpenGuiRequest(OpenGuiRequest request) {
        if (request.gui == OpenGuiRequest.Type.EDITOR) {
            Minecraft.m_91087_().m_91152_((Screen)new ImmersivePaintingScreen(request.entity, request.minResolution, request.maxResolution, request.showOtherPlayersPaintings, request.uploadPermissionLevel));
        }
    }

    @Override
    public void handlePaintingListResponse(PaintingListMessage response) {
        if (response.shouldClear()) {
            ClientPaintingManager.getPaintings().clear();
        }
        for (Map.Entry<ResourceLocation, Painting> entry : response.getPaintings().entrySet()) {
            if (entry.getValue() == null) {
                ClientPaintingManager.getPaintings().remove(entry.getKey());
                continue;
            }
            ClientPaintingManager.getPaintings().put(entry.getKey(), entry.getValue());
        }
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ImmersivePaintingScreen) {
            ImmersivePaintingScreen screen2 = (ImmersivePaintingScreen)screen;
            screen2.refreshPage();
        }
    }

    @Override
    public void handlePaintingModifyMessage(PaintingModifyMessage message) {
        Entity entity;
        LocalPlayer e = Minecraft.m_91087_().f_91074_;
        if (e != null && (entity = e.m_9236_().m_6815_(message.getEntityId())) instanceof ImmersivePaintingEntity) {
            ImmersivePaintingEntity painting = (ImmersivePaintingEntity)entity;
            painting.setMotive(message.getMotive());
            painting.setFrame(message.getFrame());
            painting.setMaterial(message.getMaterial());
            painting.setFacing(message.getFacing(), message.getRotation());
            painting.setAttachmentPos(message.getPos());
        }
    }

    @Override
    public void handleRegisterPaintingResponse(RegisterPaintingResponse response) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ImmersivePaintingScreen) {
            ImmersivePaintingScreen screen2 = (ImmersivePaintingScreen)screen;
            if (response.error.isEmpty()) {
                if (screen2.entity != null) {
                    screen2.entity.setMotive(new ResourceLocation(response.identifier));
                    NetworkHandler.sendToServer(new PaintingModifyRequest(screen2.entity));
                    if (screen2.entity.isGraffiti()) {
                        Minecraft.m_91087_().m_91152_(null);
                    } else {
                        screen2.setPage(ImmersivePaintingScreen.Page.FRAME);
                    }
                }
            } else {
                screen2.setPage(ImmersivePaintingScreen.Page.CREATE);
                screen2.setError((Component)Component.m_237115_((String)("immersive_paintings.error." + response.error)));
            }
        }
    }
}

