/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PrivateRecipeBookGhostSlots {
    private final List<PrivateGhostInputSlot> slots = Lists.newArrayList();
    float time;

    public void reset() {
        this.slots.clear();
        this.time = 0.0f;
    }

    public void addSlot(ItemStack itemStack, int x, int y) {
        this.slots.add(new PrivateGhostInputSlot(itemStack, x, y));
    }

    public PrivateGhostInputSlot getSlot(int index) {
        return this.slots.get(index);
    }

    public int getSlotCount() {
        return this.slots.size();
    }

    public void draw(GuiGraphics guiGraphics, Minecraft client, int i, int j, boolean bl, float f) {
        if (!Screen.m_96637_()) {
            this.time += f;
        }
        for (int k = 0; k < this.slots.size(); ++k) {
            PrivateGhostInputSlot ghostIngredient = this.slots.get(k);
            int l = ghostIngredient.getX() + i;
            int m = ghostIngredient.getY() + j;
            if (k == 0 && bl) {
                guiGraphics.m_280509_(l - 4, m - 4, l + 20, m + 20, 0x30FF0000);
            } else {
                guiGraphics.m_280509_(l, m, l + 16, m + 16, 0x30FF0000);
            }
            ItemStack itemStack = ghostIngredient.itemStack;
            guiGraphics.m_280203_(itemStack, l, m);
            guiGraphics.m_285944_(RenderType.m_285811_(), l, m, l + 16, m + 16, 0x30FFFFFF);
            if (k != 0) continue;
            guiGraphics.m_280370_(client.f_91062_, itemStack, l, m);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PrivateGhostInputSlot {
        private final ItemStack itemStack;
        private final int x;
        private final int y;

        public PrivateGhostInputSlot(ItemStack itemStack, int x, int y) {
            this.itemStack = itemStack;
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public ItemStack getCurrentItemStack() {
            return this.itemStack;
        }
    }
}

