/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import de.cristelknight.doapi.DoApiRL;
import de.cristelknight.doapi.client.recipebook.handler.AbstractPrivateRecipeScreenHandler;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateRecipeBookWidget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class AbstractRecipeBookGUIScreen<T extends AbstractPrivateRecipeScreenHandler>
extends AbstractContainerScreen<T> {
    private final ResourceLocation BACKGROUND;
    private static final ResourceLocation RECIPE_BUTTON_TEXTURE = new DoApiRL("textures/gui/recipe_button.png");
    public final PrivateRecipeBookWidget recipeBook;
    private boolean narrow;

    public AbstractRecipeBookGUIScreen(T handler, Inventory inventory, Component title, PrivateRecipeBookWidget recipeBook, ResourceLocation background) {
        super(handler, inventory, title);
        this.BACKGROUND = background;
        this.recipeBook = recipeBook;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.narrow = this.f_96543_ < 379;
        this.recipeBook.initialize(this.f_96543_, this.f_96544_, this.f_96541_, this.narrow, (AbstractPrivateRecipeScreenHandler)this.f_97732_);
        this.f_97735_ = this.recipeBook.findLeftEdge(this.f_96543_, this.f_97726_);
        this.m_142416_((GuiEventListener)new ImageButton(this.f_97735_ + 5, this.f_97736_ + 25, 20, 18, 0, 0, 19, this.getRecipeButtonTexture(), button -> {
            this.recipeBook.toggleOpen();
            this.f_97735_ = this.recipeBook.findLeftEdge(this.f_96543_, this.f_97726_);
            button.m_264152_(this.f_97735_ + 5, this.f_97736_ + 25);
        }));
        this.f_97728_ += 20;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(guiGraphics);
        if (this.recipeBook.isOpen() && this.narrow) {
            this.m_7286_(guiGraphics, delta, mouseX, mouseY);
            this.recipeBook.m_88315_(guiGraphics, mouseX, mouseY, delta);
        } else {
            this.recipeBook.m_88315_(guiGraphics, mouseX, mouseY, delta);
            super.m_88315_(guiGraphics, mouseX, mouseY, delta);
            this.recipeBook.drawGhostSlots(guiGraphics, this.f_97735_, this.f_97736_, true, delta);
        }
        this.m_280072_(guiGraphics, mouseX, mouseY);
        this.recipeBook.drawTooltip(guiGraphics, this.f_97735_, this.f_97736_, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics guiGraphics, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.BACKGROUND);
        int posX = this.f_97735_;
        int posY = this.f_97736_;
        guiGraphics.m_280218_(this.BACKGROUND, posX, posY, 0, 0, this.f_97726_ - 1, this.f_97727_);
        this.renderProgressArrow(guiGraphics);
        this.renderBurnIcon(guiGraphics, posX, posY);
    }

    protected void renderProgressArrow(GuiGraphics guiGraphics) {
    }

    protected void renderBurnIcon(GuiGraphics guiGraphics, int posX, int posY) {
    }

    protected void m_181908_() {
        super.m_181908_();
        this.recipeBook.update();
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.recipeBook.m_6375_(mouseX, mouseY, button)) {
            return true;
        }
        return this.narrow && this.recipeBook.isOpen() || super.m_6375_(mouseX, mouseY, button);
    }

    protected void m_6597_(Slot slot, int slotId, int button, ClickType actionType) {
        super.m_6597_(slot, slotId, button, actionType);
        this.recipeBook.slotClicked(slot);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return !this.recipeBook.m_7933_(keyCode, scanCode, modifiers) && super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int left, int top, int button) {
        boolean bl = mouseX < (double)left || mouseY < (double)top || mouseX >= (double)(left + this.f_97726_) || mouseY >= (double)(top + this.f_97727_);
        return this.recipeBook.isClickOutsideBounds(mouseX, mouseY, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_) && bl;
    }

    public boolean m_5534_(char chr, int modifiers) {
        return this.recipeBook.m_5534_(chr, modifiers) || super.m_5534_(chr, modifiers);
    }

    public void m_7861_() {
        super.m_7861_();
    }

    public ResourceLocation getRecipeButtonTexture() {
        return RECIPE_BUTTON_TEXTURE;
    }
}

