/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.forge.terraform.boat.impl.client;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import de.cristelknight.doapi.client.terraform.TerraformBoatClientHelper;
import de.cristelknight.doapi.forge.terraform.boat.api.TerraformBoatTypeRegistry;
import de.cristelknight.doapi.forge.terraform.boat.impl.entity.TerraformBoatHolder;
import de.cristelknight.doapi.terraform.boat.TerraformBoatType;
import java.util.Map;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ChestRaftModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.RaftModel;
import net.minecraft.client.model.WaterPatchModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

public class CustomBoatEntityRenderer
extends BoatRenderer {
    private final Map<TerraformBoatType, Pair<ResourceLocation, ListModel<Boat>>> texturesAndModels = (Map)TerraformBoatTypeRegistry.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getValue, entry -> {
        boolean raft = ((TerraformBoatType)entry.getValue()).isRaft();
        String prefix = raft ? (chest ? "chest_raft/" : "raft/") : (chest ? "chest_boat/" : "boat/");
        ResourceLocation id = (ResourceLocation)entry.getKey();
        ResourceLocation textureId = new ResourceLocation(id.m_135827_(), "textures/entity/" + prefix + id.m_135815_() + ".png");
        ModelLayerLocation layer = TerraformBoatClientHelper.getLayer(id, raft, chest);
        ListModel<Boat> model = this.createModel(context.m_174023_(layer), raft, chest);
        return new Pair((Object)textureId, model);
    }));

    public CustomBoatEntityRenderer(EntityRendererProvider.Context context, boolean chest) {
        super(context, chest);
    }

    public void m_7392_(Boat boat, float f, float g, PoseStack poseStack, MultiBufferSource multiBufferSource, int i) {
        if (boat instanceof TerraformBoatHolder) {
            TerraformBoatHolder myHolder = (TerraformBoatHolder)boat;
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.375f, 0.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - f));
            float h = (float)boat.m_38385_() - g;
            float j = boat.m_38384_() - g;
            if (j < 0.0f) {
                j = 0.0f;
            }
            if (h > 0.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(Mth.m_14031_((float)h) * h * j / 10.0f * (float)boat.m_38386_()));
            }
            if (!Mth.m_14033_((float)boat.m_38352_(g), (float)0.0f)) {
                poseStack.m_252781_(new Quaternionf().setAngleAxis(boat.m_38352_(g) * ((float)Math.PI / 180), 1.0f, 0.0f, 1.0f));
            }
            Pair<ResourceLocation, ListModel<Boat>> pair = this.getTextureAndModel(myHolder);
            ResourceLocation resourceLocation = (ResourceLocation)pair.getFirst();
            ListModel listModel = (ListModel)pair.getSecond();
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(90.0f));
            listModel.m_6973_((Entity)boat, g, 0.0f, -0.1f, 0.0f, 0.0f);
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(listModel.m_103119_(resourceLocation));
            listModel.m_7695_(poseStack, vertexConsumer, i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            if (!boat.m_5842_()) {
                VertexConsumer vertexConsumer2 = multiBufferSource.m_6299_(RenderType.m_110478_());
                if (listModel instanceof WaterPatchModel) {
                    WaterPatchModel waterPatchModel = (WaterPatchModel)listModel;
                    waterPatchModel.m_102282_().m_104301_(poseStack, vertexConsumer2, i, OverlayTexture.f_118083_);
                }
            }
            poseStack.m_85849_();
        } else {
            super.m_7392_(boat, f, g, poseStack, multiBufferSource, i);
        }
    }

    @NotNull
    public ResourceLocation m_5478_(@NotNull Boat entity) {
        if (entity instanceof TerraformBoatHolder) {
            TerraformBoatType boat = ((TerraformBoatHolder)entity).getTerraformBoat();
            return (ResourceLocation)this.texturesAndModels.get(boat).getFirst();
        }
        return super.m_5478_(entity);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getTextureAndModel(TerraformBoatHolder holder) {
        return this.texturesAndModels.get(holder.getTerraformBoat());
    }

    private ListModel<Boat> createModel(ModelPart part, boolean raft, boolean chest) {
        if (raft) {
            return chest ? new ChestRaftModel(part) : new RaftModel(part);
        }
        return chest ? new ChestBoatModel(part) : new BoatModel(part);
    }
}

