/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.bakery.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.satisfy.bakery.block.CraftingBowlBlock;
import net.satisfy.bakery.block.entity.CraftingBowlBlockEntity;
import net.satisfy.bakery.client.model.CraftingBowlModel;

public class CraftingBowlRenderer
implements BlockEntityRenderer<CraftingBowlBlockEntity> {
    private final ModelPart bowl;
    private final ModelPart swing;

    public CraftingBowlRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.m_173582_(CraftingBowlModel.LAYER_LOCATION);
        this.bowl = root.m_171324_("bowl");
        this.swing = root.m_171324_("swing");
    }

    public void render(CraftingBowlBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        Level level = blockEntity.m_58904_();
        assert (level != null);
        BlockState blockState = level.m_8055_(blockEntity.m_58899_());
        if (!(blockState.m_60734_() instanceof CraftingBowlBlock)) {
            return;
        }
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
        poseStack.m_252880_(0.5f, -1.5f, -0.5f);
        ResourceLocation location = blockEntity.m_8020_(4) == ItemStack.f_41583_ ? new ResourceLocation("bakery", "textures/entity/crafting_bowl.png") : new ResourceLocation("bakery", "textures/entity/crafting_bowl_full.png");
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)location));
        this.bowl.m_104301_(poseStack, vertexConsumer, i, j);
        if ((Integer)level.m_8055_(blockEntity.m_58899_()).m_61143_((Property)CraftingBowlBlock.STIRRING) > 0) {
            poseStack.m_252781_(Axis.f_252436_.m_252961_((float)(System.currentTimeMillis() % 100000L) / 100.0f % 360.0f));
        }
        this.swing.m_104301_(poseStack, vertexConsumer, i, j);
        this.renderItems(poseStack, multiBufferSource, blockEntity.m_7086_(), i, j);
        poseStack.m_85849_();
    }

    private void renderItems(PoseStack poseStack, MultiBufferSource multiBufferSource, NonNullList<ItemStack> items, int i, int j) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        poseStack.m_252880_(0.0f, 1.25f, 0.0f);
        poseStack.m_85841_(0.35f, 0.35f, 0.35f);
        float offset = 0.26f;
        poseStack.m_252880_(-offset, 0.1f, -offset);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        itemRenderer.m_269491_((LivingEntity)player, (ItemStack)items.get(0), ItemDisplayContext.FIXED, false, poseStack, multiBufferSource, (Level)Minecraft.m_91087_().f_91073_, i, j, 0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        poseStack.m_252880_(2.0f * offset, 0.1f, 0.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        itemRenderer.m_269491_((LivingEntity)player, (ItemStack)items.get(1), ItemDisplayContext.FIXED, false, poseStack, multiBufferSource, (Level)Minecraft.m_91087_().f_91073_, i, j, 0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        poseStack.m_252880_(0.0f, 0.1f, 2.0f * offset);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        itemRenderer.m_269491_((LivingEntity)player, (ItemStack)items.get(2), ItemDisplayContext.FIXED, false, poseStack, multiBufferSource, (Level)Minecraft.m_91087_().f_91073_, i, j, 0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
        poseStack.m_252880_(-2.0f * offset, 0.1f, 0.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        itemRenderer.m_269491_((LivingEntity)player, (ItemStack)items.get(3), ItemDisplayContext.FIXED, false, poseStack, multiBufferSource, (Level)Minecraft.m_91087_().f_91073_, i, j, 0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
    }
}

