/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.effects;

import java.util.List;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class FortuneEffect
extends MobEffect {
    private static final UUID FORTUNE_EFFECT_UUID = UUID.fromString("d699bf1f-74a3-4b1d-a5f2-ccaa49d6d873");
    private static final String MODIFIER_NAME = "Fortune Effect";

    public FortuneEffect() {
        super(MobEffectCategory.BENEFICIAL, 65280);
    }

    public void m_6742_(LivingEntity entity, int amplifier) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_6084_()) {
            int finalAmplifier;
            Level world = player.m_9236_();
            double radius = 10.0;
            List nearbyPlayers = world.m_45976_(Player.class, player.m_20191_().m_82400_(radius));
            int playerCount = nearbyPlayers.size() - 1;
            if (playerCount < 0) {
                playerCount = 0;
            }
            if ((finalAmplifier = this.calculateFinalAmplifier(playerCount)) > 0) {
                double fortuneModifierValue = 1.0 * (double)(finalAmplifier + 1);
                AttributeInstance luckAttr = player.m_21051_(Attributes.f_22286_);
                if (luckAttr != null) {
                    AttributeModifier existingModifier = luckAttr.m_22111_(FORTUNE_EFFECT_UUID);
                    if (existingModifier != null) {
                        if (existingModifier.m_22218_() != fortuneModifierValue) {
                            luckAttr.m_22120_(FORTUNE_EFFECT_UUID);
                            AttributeModifier fortuneModifier = new AttributeModifier(FORTUNE_EFFECT_UUID, MODIFIER_NAME, fortuneModifierValue, AttributeModifier.Operation.ADDITION);
                            luckAttr.m_22125_(fortuneModifier);
                        }
                    } else {
                        AttributeModifier fortuneModifier = new AttributeModifier(FORTUNE_EFFECT_UUID, MODIFIER_NAME, fortuneModifierValue, AttributeModifier.Operation.ADDITION);
                        luckAttr.m_22125_(fortuneModifier);
                    }
                }
            } else {
                AttributeInstance luckAttr = player.m_21051_(Attributes.f_22286_);
                if (luckAttr != null) {
                    luckAttr.m_22120_(FORTUNE_EFFECT_UUID);
                }
            }
        }
    }

    private int calculateFinalAmplifier(int playerCount) {
        float baseAmplifier = 1.0f;
        float reductionPerPlayer = 0.1f;
        float calculatedAmplifier = baseAmplifier - (float)playerCount * reductionPerPlayer;
        if (calculatedAmplifier < 0.0f) {
            calculatedAmplifier = 0.0f;
        }
        int finalAmplifier = Math.round(calculatedAmplifier);
        return Math.max(0, Math.min(finalAmplifier, 3));
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

