/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.vinery.core.util.GeneralUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackableLogBlock
extends SlabBlock {
    public static final BooleanProperty FIRED = BooleanProperty.m_61465_((String)"fired");
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    private static final Supplier<VoxelShape> BOTTOM_AABB_SUPPLIER = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0, (double)0.3125, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.6875, (double)1.0, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.0, (double)0.0, (double)0.9375, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0625, (double)1.0, (double)0.5, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    private static final Supplier<VoxelShape> TOP_AABB_SUPPLIER = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.5, (double)0.0, (double)0.3125, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.6875, (double)1.0, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.5, (double)0.0, (double)0.9375, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.0625, (double)1.0, (double)1.0, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    private static final Supplier<VoxelShape> DOUBLE_SUPPLIER = () -> {
        VoxelShape shape = Shapes.m_83040_();
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.0, (double)0.0, (double)0.3125, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0625, (double)0.5, (double)0.0, (double)0.3125, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.6875, (double)1.0, (double)0.5, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.6875, (double)1.0, (double)1.0, (double)0.9375), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.0, (double)0.0, (double)0.9375, (double)0.25, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.5, (double)0.0, (double)0.9375, (double)0.75, (double)1.0), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.25, (double)0.0625, (double)1.0, (double)0.5, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        shape = Shapes.m_83148_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.0, (double)0.75, (double)0.0625, (double)1.0, (double)1.0, (double)0.3125), (BooleanOp)BooleanOp.f_82695_);
        return shape;
    };
    protected static final VoxelShape BOTTOM_AABB = BOTTOM_AABB_SUPPLIER.get();
    protected static final VoxelShape TOP_AABB = TOP_AABB_SUPPLIER.get();
    protected static final VoxelShape DOUBLE = DOUBLE_SUPPLIER.get();
    public static final Map<Direction, Map<SlabType, VoxelShape>> SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
        for (Direction direction : Direction.Plane.HORIZONTAL.m_122557_().toList()) {
            map.put(direction, new HashMap());
            ((Map)map.get(direction)).put(SlabType.DOUBLE, GeneralUtil.rotateShape(Direction.NORTH, direction, DOUBLE_SUPPLIER.get()));
            ((Map)map.get(direction)).put(SlabType.TOP, GeneralUtil.rotateShape(Direction.NORTH, direction, TOP_AABB_SUPPLIER.get()));
            ((Map)map.get(direction)).put(SlabType.BOTTOM, GeneralUtil.rotateShape(Direction.NORTH, direction, BOTTOM_AABB_SUPPLIER.get()));
        }
    });

    public StackableLogBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_56353_, (Comparable)SlabType.BOTTOM)).m_61124_((Property)FIRED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_56354_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        SlabType stackSize = (SlabType)state.m_61143_((Property)f_56353_);
        if (stack.m_150930_(Items.f_42409_) && stackSize == SlabType.DOUBLE) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)FIRED, (Comparable)Boolean.valueOf(true)), 3);
            world.m_5594_(player, pos, SoundEvents.f_11942_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        if (stack.m_41720_() instanceof ShovelItem && stackSize == SlabType.DOUBLE && ((Boolean)state.m_61143_((Property)FIRED)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)FIRED, (Comparable)Boolean.valueOf(false)));
            world.m_5594_(player, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            boolean clientSide = world.m_5776_();
            if (clientSide) {
                for (int i = 0; i < 20; ++i) {
                    CampfireBlock.m_51251_((Level)world, (BlockPos)pos, (boolean)false, (boolean)false);
                }
            }
            return InteractionResult.m_19078_((boolean)clientSide);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos blockPos = ctx.m_8083_();
        BlockState blockState = ctx.m_43725_().m_8055_(blockPos);
        if (blockState.m_60713_((Block)this)) {
            return (BlockState)((BlockState)((BlockState)((BlockState)blockState.m_61124_((Property)f_56353_, (Comparable)SlabType.DOUBLE)).m_61124_((Property)FIRED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_56354_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
        }
        FluidState fluidState = ctx.m_43725_().m_6425_(blockPos);
        BlockState blockState2 = (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_56353_, (Comparable)SlabType.BOTTOM)).m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)f_56354_, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        Direction direction = ctx.m_43719_();
        return !(direction == Direction.DOWN || direction != Direction.UP && ctx.m_43720_().m_7098_() - (double)blockPos.m_123342_() > 0.5) ? blockState2 : (BlockState)blockState2.m_61124_((Property)f_56353_, (Comparable)SlabType.TOP);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FIRED, FACING});
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)FIRED)).booleanValue()) {
            StackableLogBlock.displayTickLikeCampfire(world, pos, random, world.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50335_));
        }
    }

    public static void displayTickLikeCampfire(Level world, BlockPos pos, RandomSource random, boolean isSignal) {
        int i;
        if (random.m_188501_() < 0.8f) {
            for (i = 0; i < random.m_188503_(5) + 3; ++i) {
                CampfireBlock.m_51251_((Level)world, (BlockPos)pos, (boolean)isSignal, (boolean)true);
            }
        }
        if (random.m_188503_(10) == 0) {
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + random.m_188501_(), random.m_188501_() * 0.7f + 0.6f, false);
        }
        if (random.m_188503_(5) == 0) {
            for (i = 0; i < random.m_188503_(4) + 3; ++i) {
                world.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (double)(random.m_188501_() / 2.0f), 5.0E-5, (double)(random.m_188501_() / 2.0f));
            }
        }
    }

    public void m_141947_(Level world, BlockPos pos, BlockState state, Entity entity) {
        LivingEntity livingEntity;
        boolean isLit = (Boolean)world.m_8055_(pos).m_61143_((Property)FIRED);
        if (isLit && !entity.m_5825_() && entity instanceof LivingEntity && !EnchantmentHelper.m_44938_((LivingEntity)(livingEntity = (LivingEntity)entity))) {
            entity.m_6469_(world.m_269111_().m_269387_(), 1.0f);
        }
        super.m_141947_(world, pos, state, entity);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        SlabType slabType = (SlabType)blockState.m_61143_((Property)f_56353_);
        Direction facing = (Direction)blockState.m_61143_((Property)FACING);
        return switch (slabType) {
            case SlabType.DOUBLE -> SHAPE.get(facing).get(SlabType.DOUBLE);
            case SlabType.TOP -> SHAPE.get(facing).get(SlabType.TOP);
            default -> SHAPE.get(facing).get(SlabType.BOTTOM);
        };
    }
}

