/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.vinery.core.registry;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.satisfy.vinery.core.recipe.ApplePressFermentingRecipe;
import net.satisfy.vinery.core.recipe.ApplePressMashingRecipe;
import net.satisfy.vinery.core.recipe.FermentationBarrelRecipe;
import net.satisfy.vinery.core.util.VineryIdentifier;

public class RecipeTypesRegistry {
    private static final Registrar<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((String)"vinery", (ResourceKey)Registries.f_256954_).getRegistrar();
    private static final Registrar<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((String)"vinery", (ResourceKey)Registries.f_256764_).getRegistrar();
    public static final RegistrySupplier<RecipeType<FermentationBarrelRecipe>> FERMENTATION_BARREL_RECIPE_TYPE = RecipeTypesRegistry.create("wine_fermentation");
    public static final RegistrySupplier<RecipeSerializer<FermentationBarrelRecipe>> FERMENTATION_BARREL_RECIPE_SERIALIZER = RecipeTypesRegistry.create("wine_fermentation", FermentationBarrelRecipe.Serializer::new);
    public static final RegistrySupplier<RecipeType<ApplePressMashingRecipe>> APPLE_PRESS_MASHING_RECIPE_TYPE = RecipeTypesRegistry.create("apple_mashing");
    public static final RegistrySupplier<RecipeSerializer<ApplePressMashingRecipe>> APPLE_PRESS_MASHING_RECIPE_SERIALIZER = RecipeTypesRegistry.create("apple_mashing", ApplePressMashingRecipe.Serializer::new);
    public static final RegistrySupplier<RecipeType<ApplePressFermentingRecipe>> APPLE_PRESS_FERMENTING_RECIPE_TYPE = RecipeTypesRegistry.create("apple_fermenting");
    public static final RegistrySupplier<RecipeSerializer<ApplePressFermentingRecipe>> APPLE_PRESS_FERMENTING_RECIPE_SERIALIZER = RecipeTypesRegistry.create("apple_fermenting", ApplePressFermentingRecipe.Serializer::new);

    private static <T extends Recipe<?>> RegistrySupplier<RecipeSerializer<T>> create(String name, Supplier<RecipeSerializer<T>> serializer) {
        return RECIPE_SERIALIZERS.register((ResourceLocation)new VineryIdentifier(name), serializer);
    }

    private static <T extends Recipe<?>> RegistrySupplier<RecipeType<T>> create(final String name) {
        Supplier<RecipeType> type = () -> new RecipeType<T>(){

            public String toString() {
                return name;
            }
        };
        return RECIPE_TYPES.register((ResourceLocation)new VineryIdentifier(name), type);
    }

    public static void init() {
    }
}

